/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.loaders.s3;

import org.infinispan.loaders.BaseCacheStoreFunctionalTest;
import org.infinispan.loaders.CacheStoreConfig;
import org.infinispan.loaders.s3.MockS3Bucket;
import org.infinispan.loaders.s3.MockS3Connection;
import org.infinispan.loaders.s3.S3CacheStoreConfig;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Optional;
import org.testng.annotations.Parameters;
import org.testng.annotations.Test;

@Test(groups={"unit"}, sequential=true, testName="loaders.s3.S3CacheStoreFunctionalIntegrationTest")
public class S3CacheStoreFunctionalIntegrationTest
extends BaseCacheStoreFunctionalTest {
    private String proxyHost;
    private int proxyPort = -1;
    private int maxConnections = 20;
    private boolean isSecure = false;
    private String csBucket;
    private String accessKey;
    private String secretKey;
    String connectionClass;
    String bucketClass;
    private static final String sysAWSAccessKeyId = System.getProperty("jclouds.aws.accesskeyid");
    private static final String sysAWSSecretAccessKey = System.getProperty("jclouds.aws.secretaccesskey");

    @BeforeTest
    @Parameters(value={"jclouds.aws.accesskeyid", "jclouds.aws.secretaccesskey"})
    protected void setUpClient(@Optional String AWSAccessKeyId, @Optional String AWSSecretAccessKey) throws Exception {
        this.accessKey = AWSAccessKeyId == null ? sysAWSAccessKeyId : AWSAccessKeyId;
        String string = this.secretKey = AWSSecretAccessKey == null ? sysAWSSecretAccessKey : AWSSecretAccessKey;
        if (this.accessKey == null || this.accessKey.trim().equals("") || this.secretKey == null || this.secretKey.trim().equals("")) {
            this.accessKey = "dummy";
            this.secretKey = "dummy";
            this.connectionClass = MockS3Connection.class.getName();
            this.bucketClass = MockS3Bucket.class.getName();
        } else {
            this.proxyHost = "localhost";
            this.proxyPort = 8888;
        }
        this.csBucket = (System.getProperty("user.name") + "." + ((Object)((Object)this)).getClass().getSimpleName()).toLowerCase();
        System.out.printf("accessKey: %1$s, bucket: %2$s%n", this.accessKey, this.csBucket);
    }

    protected CacheStoreConfig createCacheStoreConfig() throws Exception {
        S3CacheStoreConfig cfg = new S3CacheStoreConfig();
        cfg.setBucketPrefix(this.csBucket);
        cfg.setAwsAccessKey(this.accessKey);
        cfg.setAwsSecretKey(this.secretKey);
        cfg.setProxyHost(this.proxyHost);
        cfg.setProxyPort(this.proxyPort);
        cfg.setSecure(this.isSecure);
        cfg.setMaxConnections(this.maxConnections);
        cfg.setBucketClass(this.bucketClass);
        cfg.setConnectionClass(this.connectionClass);
        cfg.setPurgeSynchronously(Boolean.valueOf(true));
        return cfg;
    }
}

