/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.loaders.s3.jclouds;

import java.io.InputStream;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.infinispan.loaders.bucket.Bucket;
import org.infinispan.loaders.s3.S3Bucket;
import org.infinispan.loaders.s3.S3ConnectionException;
import org.infinispan.loaders.s3.jclouds.JCloudsConnection;
import org.jclouds.aws.s3.S3InputStreamMap;

public class JCloudsBucket
implements S3Bucket<org.jclouds.aws.s3.domain.S3Bucket, JCloudsConnection> {
    private JCloudsConnection connection;
    private String name;
    private org.jclouds.aws.s3.domain.S3Bucket rootS3Bucket;
    private Map<String, InputStream> map;

    @Override
    public void init(JCloudsConnection connection, org.jclouds.aws.s3.domain.S3Bucket bucket) {
        this.connection = connection;
        this.rootS3Bucket = bucket;
        this.name = bucket.getName();
        this.map = connection.context.createInputStreamMap(this.rootS3Bucket.getName());
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Bucket get(String key) throws S3ConnectionException {
        InputStream input;
        block5: {
            input = null;
            input = this.map.get(key);
            if (input == null) break block5;
            Bucket bucket = this.bucketFromStream(key, input);
            this.safeClose(input);
            return bucket;
        }
        try {
            Bucket bucket = null;
            this.safeClose(input);
            return bucket;
        }
        catch (Exception e) {
            try {
                throw this.connection.convertToS3ConnectionException("Error while reading from object: " + key, e);
            }
            catch (Throwable throwable) {
                this.safeClose(input);
                throw throwable;
            }
        }
    }

    private Bucket bucketFromStream(String key, InputStream input) throws S3ConnectionException {
        try {
            Bucket bucket = (Bucket)this.connection.marshaller.objectFromInputStream(input);
            bucket.setBucketName(key);
            Bucket bucket2 = bucket;
            return bucket2;
        }
        catch (Exception e) {
            throw this.connection.convertToS3ConnectionException("Error while reading from object: " + key, e);
        }
        finally {
            this.safeClose(input);
        }
    }

    @Override
    public void remove(String key) throws S3ConnectionException {
        try {
            this.map.remove(key);
        }
        catch (Exception ex) {
            throw this.connection.convertToS3ConnectionException("Exception removing key " + key, ex);
        }
    }

    @Override
    public Set<String> keySet() throws S3ConnectionException {
        return this.connection.keysInBucket(this.rootS3Bucket);
    }

    @Override
    public Set<Bucket> values() throws S3ConnectionException {
        HashSet<Bucket> buckets = new HashSet<Bucket>();
        for (Map.Entry<String, InputStream> entry : this.map.entrySet()) {
            buckets.add(this.bucketFromStream(entry.getKey(), entry.getValue()));
        }
        return buckets;
    }

    @Override
    public void clear() throws S3ConnectionException {
        try {
            this.map.clear();
        }
        catch (Exception ex) {
            throw this.connection.convertToS3ConnectionException("Exception clearing store", ex);
        }
    }

    @Override
    public void insert(Bucket b) throws S3ConnectionException {
        try {
            if (b.getEntries().isEmpty()) {
                this.map.remove(b.getBucketName());
            } else {
                ((S3InputStreamMap)this.map).putBytes(b.getBucketName(), this.connection.marshaller.objectToByteBuffer((Object)b));
            }
        }
        catch (Exception ex) {
            throw this.connection.convertToS3ConnectionException("Exception while saving bucket " + b, ex);
        }
    }

    protected final void safeClose(InputStream stream) throws S3ConnectionException {
        if (stream == null) {
            return;
        }
        try {
            stream.close();
        }
        catch (Exception e) {
            throw new S3ConnectionException("Problems closing input stream", e);
        }
    }
}

