/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.sql;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Set;
import java.util.concurrent.CompletionException;
import java.util.stream.Stream;
import org.infinispan.Cache;
import org.infinispan.commons.CacheConfigurationException;
import org.infinispan.commons.test.ExceptionRunnable;
import org.infinispan.commons.test.Exceptions;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.manager.EmbeddedCacheManagerStartupException;
import org.infinispan.persistence.jdbc.common.UnitTestDatabaseManager;
import org.infinispan.persistence.jdbc.common.configuration.AbstractJdbcStoreConfigurationBuilder;
import org.infinispan.persistence.jdbc.common.configuration.ConnectionFactoryConfiguration;
import org.infinispan.persistence.jdbc.common.configuration.ConnectionFactoryConfigurationBuilder;
import org.infinispan.persistence.jdbc.common.connectionfactory.ConnectionFactory;
import org.infinispan.persistence.sql.configuration.QueriesJdbcConfigurationBuilder;
import org.infinispan.persistence.sql.configuration.QueriesJdbcStoreConfigurationBuilder;
import org.infinispan.protostream.SerializationContextInitializer;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.test.TestDataSCI;
import org.infinispan.test.data.Address;
import org.infinispan.test.data.Person;
import org.infinispan.test.data.Sex;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="persistence.sql.QueriesJdbcJoinTest")
public class QueriesJdbcJoinTest
extends AbstractInfinispanTest {
    private static final String TABLE1_NAME = "Person";
    private static final String TABLE2_NAME = "Address";
    private ConnectionFactory FACTORY;

    @AfterMethod(alwaysRun=true)
    public void afterClass() {
        if (this.FACTORY != null) {
            this.FACTORY.stop();
        }
    }

    protected EmbeddedCacheManager createCacheManager(TestType type, boolean idJoin) {
        ConfigurationBuilder builder = new ConfigurationBuilder();
        builder.encoding().mediaType("application/x-protostream");
        QueriesJdbcStoreConfigurationBuilder queriesBuilder = (QueriesJdbcStoreConfigurationBuilder)((QueriesJdbcStoreConfigurationBuilder)builder.persistence().addStore(QueriesJdbcStoreConfigurationBuilder.class)).ignoreModifications(true);
        queriesBuilder.keyColumns("name");
        queriesBuilder.schemaJdbcConfigurationBuilder().messageName(TABLE1_NAME).packageName("org.infinispan.test.core");
        UnitTestDatabaseManager.configureUniqueConnectionFactory((AbstractJdbcStoreConfigurationBuilder)queriesBuilder);
        this.createTables((ConnectionFactoryConfigurationBuilder<ConnectionFactoryConfiguration>)queriesBuilder.getConnectionFactory(), idJoin);
        type.modifyConfiguration(queriesBuilder, idJoin);
        return TestCacheManagerFactory.createCacheManager((SerializationContextInitializer)TestDataSCI.INSTANCE, (ConfigurationBuilder)builder);
    }

    private void createTables(ConnectionFactoryConfigurationBuilder<ConnectionFactoryConfiguration> builder, boolean idJoin) {
        ConnectionFactoryConfiguration config = (ConnectionFactoryConfiguration)builder.create();
        this.FACTORY = ConnectionFactory.getConnectionFactory((Class)config.connectionFactoryClass());
        this.FACTORY.start(config, ((Object)((Object)this)).getClass().getClassLoader());
        Connection connection = null;
        try {
            connection = this.FACTORY.getConnection();
            try (Statement stmt = connection.createStatement();){
                String tableCreation = "CREATE TABLE Person (name VARCHAR(255) NOT NULL, " + (idJoin ? "address INT, " : "") + "picture VARBINARY(255), sex VARCHAR(255), birthdate TIMESTAMP, notused VARCHAR(255), PRIMARY KEY (NAME))";
                stmt.execute(tableCreation);
                tableCreation = "create TABLE Address (" + (idJoin ? "id INT NOT NULL, " : "name VARCHAR(255) NOT NULL, ") + "street VARCHAR(255), city VARCHAR(255), zip INT, PRIMARY KEY (" + (idJoin ? "id" : "name") + "))";
                stmt.execute(tableCreation);
            }
        }
        catch (SQLException t) {
            throw new AssertionError((Object)t);
        }
        finally {
            this.FACTORY.releaseConnection(connection);
        }
    }

    public void testUpsertMultipleValues() {
        ConfigurationBuilder builder = new ConfigurationBuilder();
        builder.encoding().mediaType("application/x-protostream");
        QueriesJdbcStoreConfigurationBuilder queriesBuilder = (QueriesJdbcStoreConfigurationBuilder)builder.persistence().addStore(QueriesJdbcStoreConfigurationBuilder.class);
        queriesBuilder.keyColumns("name");
        queriesBuilder.schemaJdbcConfigurationBuilder().messageName(TABLE1_NAME).packageName("org.infinispan.test.core");
        UnitTestDatabaseManager.configureUniqueConnectionFactory((AbstractJdbcStoreConfigurationBuilder)queriesBuilder);
        this.createTables((ConnectionFactoryConfigurationBuilder<ConnectionFactoryConfiguration>)queriesBuilder.getConnectionFactory(), false);
        TestType.PASS.modifyConfiguration(queriesBuilder, false);
        queriesBuilder.queriesJdbcConfigurationBuilder().delete("DELETE FROM Person t1 WHERE t1.name = :name; DELETE FROM Address t2 where t2.name = :name").deleteAll("DELETE FROM Person; DELETE FROM Address").upsert(this.insertTable1Statement(false, true) + "; " + this.insertTable2Statement(false, true));
        EmbeddedCacheManager embeddedCacheManager = TestCacheManagerFactory.createCacheManager((SerializationContextInitializer)TestDataSCI.INSTANCE, (ConfigurationBuilder)builder);
        Cache cache = embeddedCacheManager.getCache();
        String name = "Mircea Markus";
        Person person = this.samplePerson(name);
        cache.put((Object)name, (Object)person);
        AssertJUnit.assertEquals((Object)person, (Object)cache.get((Object)name));
        cache.remove((Object)name);
        AssertJUnit.assertNull((Object)cache.get((Object)name));
    }

    @DataProvider(name="testTypes")
    public static Object[][] testTypes() {
        return (Object[][])Stream.of(TestType.values()).flatMap(t -> Stream.of({t, true}, {t, false})).toArray(x$0 -> new Object[x$0][]);
    }

    @Test(dataProvider="testTypes")
    public void testIdJoinTypes(TestType type, boolean idJoin) throws Exception {
        type.runTest(() -> {
            EmbeddedCacheManager cacheManager = this.createCacheManager(type, idJoin);
            Cache cache = cacheManager.getCache();
            Connection connection = this.FACTORY.getConnection();
            try {
                String name = "Manik Surtani";
                Person person = this.samplePerson(name);
                this.insertData(connection, Collections.singleton(person), idJoin);
                AssertJUnit.assertEquals((Object)person, (Object)cache.get((Object)name));
            }
            finally {
                this.FACTORY.releaseConnection(connection);
            }
        });
    }

    private Person samplePerson(String name) {
        Address address = new Address();
        address.setCity("London");
        address.setStreet("Cool Street");
        address.setZip(1321);
        return new Person(name, address, new byte[]{1, 18}, Sex.MALE, new Date(1629495308L));
    }

    private String insertTable1Statement(boolean idJoin, boolean namedParams) {
        return "INSERT INTO Person (name, " + (idJoin ? "address, " : "") + " picture, sex, birthdate) " + (namedParams ? "VALUES (:name" + (idJoin ? ", :address" : "") + ", :picture, :sex, :birthdate)" : "VALUES (?, ?, ?, ?" + (idJoin ? ", ?)" : ")"));
    }

    private String insertTable2Statement(boolean idJoin, boolean namedParams) {
        return "INSERT INTO Address(" + (idJoin ? "id" : "name") + ", street, city, zip) " + (namedParams ? "VALUES (" + (idJoin ? ":id" : ":name") + ", :street, :city, :zip)" : "VALUES (?, ?, ?, ?)");
    }

    private void insertData(Connection connection, Set<Person> peopleToCreate, boolean idJoin) throws SQLException {
        String insertStatement = this.insertTable1Statement(idJoin, false);
        int addressCount = 0;
        HashMap<Address, Integer> addressIntegerMap = idJoin ? new HashMap<Address, Integer>() : null;
        try (PreparedStatement ps = connection.prepareStatement(insertStatement);){
            for (Person person : peopleToCreate) {
                int offset = 1;
                ps.setString(offset++, person.getName());
                if (addressIntegerMap != null) {
                    Address address = person.getAddress();
                    Integer addressNumber = (Integer)addressIntegerMap.get(address);
                    if (addressNumber == null) {
                        addressNumber = addressCount++;
                        addressIntegerMap.put(address, addressNumber);
                    }
                    ps.setInt(offset++, addressNumber);
                }
                ps.setBytes(offset++, person.getPicture());
                ps.setString(offset++, person.getSex().toString());
                ps.setTimestamp(offset, new Timestamp(person.getBirthDate().getTime()));
                ps.addBatch();
            }
            ps.executeBatch();
        }
        insertStatement = this.insertTable2Statement(idJoin, false);
        ps = connection.prepareStatement(insertStatement);
        try {
            for (Person person : peopleToCreate) {
                Address address = person.getAddress();
                if (addressIntegerMap != null) {
                    Integer id = (Integer)addressIntegerMap.get(address);
                    assert (id != null);
                    ps.setInt(1, id);
                } else {
                    ps.setString(1, person.getName());
                }
                ps.setString(2, address.getStreet());
                ps.setString(3, address.getCity());
                ps.setInt(4, address.getZip());
                ps.addBatch();
            }
            ps.executeBatch();
        }
        finally {
            if (ps != null) {
                ps.close();
            }
        }
    }

    static enum TestType {
        TOO_MANY_COLUMNS{

            @Override
            void runTest(ExceptionRunnable runnable) {
                Exceptions.expectException((String)".*Additional value columns.*found that were not part of the schema.*", (ExceptionRunnable)runnable, (Class[])new Class[]{EmbeddedCacheManagerStartupException.class, CacheConfigurationException.class, CompletionException.class, CacheConfigurationException.class});
            }

            @Override
            void modifyConfiguration(QueriesJdbcStoreConfigurationBuilder builder, boolean idJoin) {
                super.modifyConfiguration(builder, idJoin);
                QueriesJdbcConfigurationBuilder queryBuilder = builder.queriesJdbcConfigurationBuilder();
                if (idJoin) {
                    queryBuilder.select("SELECT * FROM Person t1 JOIN Address t2 ON t1.address = t2.id WHERE t1.name = :name").selectAll("SELECT * FROM Person t1 JOIN Address t2 ON t1.address = t2.id");
                } else {
                    queryBuilder.select("SELECT * FROM Person t1 JOIN Address t2 WHERE t1.name = :name AND t2.name = :name").selectAll("SELECT * FROM Person t1 JOIN Address t2 WHERE t1.name = t2.name");
                }
            }
        }
        ,
        NOT_EMBEDDED_KEY{

            @Override
            void runTest(ExceptionRunnable runnable) {
                Exceptions.expectException((String)".*was found in the value schema .* but embedded key was not true", (ExceptionRunnable)runnable, (Class[])new Class[]{EmbeddedCacheManagerStartupException.class, CacheConfigurationException.class, CompletionException.class, CacheConfigurationException.class});
            }

            @Override
            void modifyConfiguration(QueriesJdbcStoreConfigurationBuilder builder, boolean idJoin) {
                super.modifyConfiguration(builder, idJoin);
                builder.schemaJdbcConfigurationBuilder().embeddedKey(false);
            }
        }
        ,
        PASS;


        void runTest(ExceptionRunnable runnable) throws Exception {
            runnable.run();
        }

        void modifyConfiguration(QueriesJdbcStoreConfigurationBuilder builder, boolean idJoin) {
            QueriesJdbcConfigurationBuilder queryBuilder = builder.queriesJdbcConfigurationBuilder();
            queryBuilder.size("SELECT COUNT(*) FROM Person");
            builder.schemaJdbcConfigurationBuilder().embeddedKey(true);
            if (idJoin) {
                builder.queriesJdbcConfigurationBuilder().select("SELECT t1.name, t1.picture, t1.sex, t1.birthdate, t2.street, t2.city, t2.zip FROM Person t1 JOIN Address t2 ON t1.address = t2.id WHERE t1.name = :name").selectAll("SELECT t1.name, t1.picture, t1.sex, t1.birthdate, t2.street, t2.city, t2.zip FROM Person t1 JOIN Address t2 ON t1.address = t2.id");
            } else {
                builder.queriesJdbcConfigurationBuilder().select("SELECT t1.name, t1.picture, t1.sex, t1.birthdate, t2.street, t2.city, t2.zip FROM Person t1 JOIN Address t2 WHERE t1.name = :name AND t2.name = :name").selectAll("SELECT t1.name, t1.picture, t1.sex, t1.birthdate, t2.street, t2.city, t2.zip FROM Person t1 JOIN Address t2 WHERE t1.name = t2.name");
            }
        }
    }
}

