/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.sql;

import java.util.Arrays;
import java.util.stream.Stream;
import org.infinispan.configuration.cache.PersistenceConfigurationBuilder;
import org.infinispan.persistence.jdbc.common.DatabaseType;
import org.infinispan.persistence.jdbc.common.configuration.ConnectionFactoryConfiguration;
import org.infinispan.persistence.jdbc.common.configuration.ConnectionFactoryConfigurationBuilder;
import org.infinispan.persistence.sql.AbstractSQLStoreFunctionalTest;
import org.infinispan.persistence.sql.configuration.AbstractSchemaJdbcConfigurationBuilder;
import org.infinispan.persistence.sql.configuration.TableJdbcStoreConfigurationBuilder;
import org.testng.annotations.Factory;
import org.testng.annotations.Test;

@Test(groups={"functional", "smoke"}, testName="persistence.jdbc.stringbased.TableJdbcStoreFunctionalTest")
public class TableJdbcStoreFunctionalTest
extends AbstractSQLStoreFunctionalTest {
    public TableJdbcStoreFunctionalTest(DatabaseType databaseType, boolean transactionalCache, boolean transactionalStore) {
        super(databaseType, transactionalCache, transactionalStore);
    }

    @Factory
    public static Object[] factory() {
        DatabaseType[] databases = DATABASE == null ? new DatabaseType[]{DatabaseType.H2, DatabaseType.SQLITE} : (DatabaseType[])databasesFromSystemProperty.keySet().stream().toArray(DatabaseType[]::new);
        return Arrays.stream(databases).flatMap(dt -> Stream.of(new TableJdbcStoreFunctionalTest((DatabaseType)dt, true, true), new TableJdbcStoreFunctionalTest((DatabaseType)dt, true, false), new TableJdbcStoreFunctionalTest((DatabaseType)dt, false, false))).toArray();
    }

    protected PersistenceConfigurationBuilder createCacheStoreConfig(PersistenceConfigurationBuilder persistence, String cacheName, boolean preload) {
        TableJdbcStoreConfigurationBuilder storeBuilder = (TableJdbcStoreConfigurationBuilder)((TableJdbcStoreConfigurationBuilder)((TableJdbcStoreConfigurationBuilder)persistence.addStore(TableJdbcStoreConfigurationBuilder.class)).transactional(this.transactionalStore)).preload(preload);
        this.configureCommonConfiguration((AbstractSchemaJdbcConfigurationBuilder<?, ?>)storeBuilder);
        storeBuilder.tableName(this.tableToSearch(cacheName));
        this.createTable(this.tableToSearch(cacheName), (ConnectionFactoryConfigurationBuilder<ConnectionFactoryConfiguration>)storeBuilder.getConnectionFactory());
        return persistence;
    }
}

