/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.sql.configuration;

import org.infinispan.configuration.cache.StoreConfiguration;
import org.infinispan.configuration.serializer.AbstractConfigurationSerializerTest;
import org.infinispan.persistence.jdbc.common.configuration.AbstractJdbcStoreConfiguration;
import org.infinispan.persistence.sql.configuration.QueriesJdbcStoreConfiguration;
import org.infinispan.persistence.sql.configuration.TableJdbcStoreConfiguration;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(testName="persistence.sql.configuration.ConfigurationSerializerTest", groups={"functional"})
public class ConfigurationSerializerTest
extends AbstractConfigurationSerializerTest {
    protected void compareStoreConfiguration(String name, StoreConfiguration beforeStore, StoreConfiguration afterStore) {
        AbstractJdbcStoreConfiguration after;
        AbstractJdbcStoreConfiguration before;
        if (beforeStore instanceof AbstractJdbcStoreConfiguration) {
            before = (AbstractJdbcStoreConfiguration)beforeStore;
            after = (AbstractJdbcStoreConfiguration)afterStore;
            AssertJUnit.assertEquals((String)("Configuration " + name + " JDBC connection factory"), (Object)before.connectionFactory(), (Object)after.connectionFactory());
        }
        if (beforeStore instanceof QueriesJdbcStoreConfiguration) {
            before = (QueriesJdbcStoreConfiguration)beforeStore;
            after = (QueriesJdbcStoreConfiguration)afterStore;
            this.compareAttributeSets("Configuration " + name + " schema", before.getSchemaJdbcConfiguration().attributes(), after.getSchemaJdbcConfiguration().attributes(), new String[0]);
            this.compareAttributeSets("Configuration " + name + " queries", before.getQueriesJdbcConfiguration().attributes(), after.getQueriesJdbcConfiguration().attributes(), new String[0]);
        } else if (beforeStore instanceof TableJdbcStoreConfiguration) {
            before = (TableJdbcStoreConfiguration)beforeStore;
            after = (TableJdbcStoreConfiguration)afterStore;
            this.compareAttributeSets("Configuration " + name + " schema", before.getSchemaJdbcConfiguration().attributes(), after.getSchemaJdbcConfiguration().attributes(), new String[0]);
        }
        super.compareStoreConfiguration(name, beforeStore, afterStore);
    }
}

