/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.sql;

import java.io.File;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.concurrent.CompletionException;
import java.util.function.Consumer;
import javax.transaction.NotSupportedException;
import javax.transaction.SystemException;
import javax.transaction.TransactionManager;
import org.infinispan.Cache;
import org.infinispan.commons.CacheConfigurationException;
import org.infinispan.commons.test.CommonsTestingUtil;
import org.infinispan.commons.test.Exceptions;
import org.infinispan.commons.util.Util;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.persistence.BaseStoreFunctionalTest;
import org.infinispan.persistence.jdbc.common.DatabaseType;
import org.infinispan.persistence.jdbc.common.UnitTestDatabaseManager;
import org.infinispan.persistence.jdbc.common.configuration.ConnectionFactoryConfiguration;
import org.infinispan.persistence.jdbc.common.configuration.ConnectionFactoryConfigurationBuilder;
import org.infinispan.persistence.jdbc.common.connectionfactory.ConnectionFactory;
import org.infinispan.persistence.sql.configuration.AbstractSchemaJdbcConfigurationBuilder;
import org.infinispan.test.data.Address;
import org.infinispan.test.data.Key;
import org.infinispan.test.data.Person;
import org.infinispan.test.data.Sex;
import org.infinispan.transaction.TransactionMode;
import org.postgresql.Driver;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public abstract class AbstractSQLStoreFunctionalTest
extends BaseStoreFunctionalTest {
    protected final DatabaseType DB_TYPE;
    protected final boolean transactionalCache;
    protected final boolean transactionalStore;
    protected String tmpDirectory;
    protected Consumer<AbstractSchemaJdbcConfigurationBuilder<?, ?>> schemaConsumer;

    public AbstractSQLStoreFunctionalTest(DatabaseType databaseType, boolean transactionalCache, boolean transactionalStore) {
        this.DB_TYPE = databaseType;
        this.transactionalCache = transactionalCache;
        this.transactionalStore = transactionalStore;
    }

    @BeforeClass(alwaysRun=true)
    protected void setUpTempDir() {
        this.tmpDirectory = CommonsTestingUtil.tmpDirectory(((Object)((Object)this)).getClass());
        new File(this.tmpDirectory).mkdirs();
    }

    @BeforeMethod(alwaysRun=true)
    protected void createBeforeMethod() throws Exception {
        this.schemaConsumer = null;
        super.createBeforeMethod();
    }

    @AfterClass(alwaysRun=true)
    protected void clearTempDir() {
        Util.recursiveFileRemove((String)this.tmpDirectory);
    }

    protected Person createEmptyPerson(String name) {
        return new Person(name, new Address(), null, null, null);
    }

    protected String parameters() {
        return "[" + this.DB_TYPE + ", transactionalCache=" + this.transactionalCache + ", transactionalStore=" + this.transactionalStore + "]";
    }

    protected ConfigurationBuilder getDefaultCacheConfiguration() {
        ConfigurationBuilder builder = super.getDefaultCacheConfiguration();
        builder.encoding().mediaType("application/x-protostream");
        if (this.transactionalCache) {
            builder.transaction().transactionMode(TransactionMode.TRANSACTIONAL);
        }
        return builder;
    }

    public void testPreloadStoredAsBinary() {
        this.schemaConsumer = builder -> builder.schemaJdbcConfigurationBuilder().embeddedKey(false).messageName("Person").packageName("org.infinispan.test.core");
        super.testPreloadStoredAsBinary();
    }

    @Test(enabled=false, description="Expiration not supported")
    public void testPreloadAndExpiry() {
    }

    @Test(enabled=false, description="Not applicable")
    public void testTwoCachesSameCacheStore() {
    }

    public void testRemoveCacheWithPassivation() {
        if (!this.transactionalStore) {
            super.testRemoveCacheWithPassivation();
        }
    }

    public void testRollback() throws SystemException, NotSupportedException {
        if (!this.transactionalCache) {
            return;
        }
        String cacheName = "testRollback";
        ConfigurationBuilder cb = this.getDefaultCacheConfiguration();
        this.createCacheStoreConfig(cb.persistence(), cacheName, false);
        this.cacheManager.defineConfiguration(cacheName, cb.build());
        Cache cache = this.cacheManager.getCache(cacheName);
        String key = "rollback-test";
        AssertJUnit.assertNull((Object)cache.get((Object)key));
        TransactionManager manager = cache.getAdvancedCache().getTransactionManager();
        String value = "the-value";
        manager.begin();
        cache.put((Object)key, (Object)value);
        AssertJUnit.assertEquals((Object)value, (Object)cache.get((Object)key));
        manager.rollback();
        AssertJUnit.assertNull((Object)cache.get((Object)key));
    }

    public void testDBHasMoreKeyColumnsWithKeySchema(Method m) {
        this.schemaConsumer = builder -> builder.schemaJdbcConfigurationBuilder().embeddedKey(false).keyMessageName("Key").packageName("org.infinispan.test.core");
        Exceptions.expectException(CacheConfigurationException.class, CompletionException.class, CacheConfigurationException.class, (String)".*Primary key (?i)(KEYCOLUMN2) was not found.*", () -> this.testSimpleGetAndPut(m.getName(), new Key("mykey"), "value"));
    }

    public void testDBHasMoreKeyColumnsWithNoKeySchema(Method m) {
        Exceptions.expectException(CacheConfigurationException.class, CompletionException.class, CacheConfigurationException.class, (String)".*Primary key has multiple columns .*", () -> this.testSimpleGetAndPut(m.getName(), "key", "value"));
    }

    public void testDBHasMoreValueColumnsWithValueSchema(Method m) {
        this.schemaConsumer = builder -> builder.schemaJdbcConfigurationBuilder().embeddedKey(false).messageName("Person").packageName("org.infinispan.test.core");
        Exceptions.expectException(CacheConfigurationException.class, CompletionException.class, CacheConfigurationException.class, (String)".*Additional value columns .* found that were not part of the schema,.*", () -> this.testSimpleGetAndPut(m.getName(), "key", new Person("man2")));
    }

    public void testDBHasMoreValueColumnsWithNoValueSchema(Method m) {
        Exceptions.expectException(CacheConfigurationException.class, CompletionException.class, CacheConfigurationException.class, (String)".*Multiple non key columns but no value message schema defined.*", () -> this.testSimpleGetAndPut(m.getName(), "key", "value"));
    }

    public void testDBHasLessValueColumnsWithSchema(Method m) {
        this.schemaConsumer = builder -> builder.schemaJdbcConfigurationBuilder().embeddedKey(false).messageName("Person").packageName("org.infinispan.test.core");
        this.testSimpleGetAndPut(m.getName(), "key", new Person("joe"));
    }

    public void testEmbeddedKey(Method m) {
        this.schemaConsumer = builder -> builder.schemaJdbcConfigurationBuilder().embeddedKey(true).messageName("Person").packageName("org.infinispan.test.core");
        this.testSimpleGetAndPut(m.getName(), "joe", new Person("joe"));
    }

    public void testEnumForKey(Method m) {
        this.schemaConsumer = builder -> builder.schemaJdbcConfigurationBuilder().embeddedKey(false).keyMessageName("Sex").packageName("org.infinispan.test.core");
        this.testSimpleGetAndPut(m.getName(), Sex.FEMALE, "samantha");
    }

    public void testEnumForValue(Method m) {
        this.schemaConsumer = builder -> builder.schemaJdbcConfigurationBuilder().embeddedKey(false).messageName("Sex").packageName("org.infinispan.test.core");
        this.testSimpleGetAndPut(m.getName(), "samantha", Sex.FEMALE);
    }

    private void testSimpleGetAndPut(String cacheName, Object key, Object value) {
        ConfigurationBuilder cb = this.getDefaultCacheConfiguration();
        this.createCacheStoreConfig(cb.persistence(), cacheName, false);
        this.cacheManager.defineConfiguration(cacheName, cb.build());
        Cache cache = this.cacheManager.getCache(cacheName);
        AssertJUnit.assertNull((Object)cache.get(key));
        cache.put(key, value);
        AssertJUnit.assertEquals((Object)value, (Object)cache.get(key));
    }

    protected void configureCommonConfiguration(AbstractSchemaJdbcConfigurationBuilder<?, ?> builder) {
        if (this.schemaConsumer != null) {
            this.schemaConsumer.accept(builder);
        }
        switch (this.DB_TYPE) {
            case POSTGRES: {
                builder.connectionPool().driverClass(Driver.class).connectionUrl("jdbc:postgresql://172.17.0.1:5432/test1").username("postgres").password("example");
                break;
            }
            case ORACLE: {
                builder.connectionPool().driverClass("oracle.jdbc.OracleDriver").connectionUrl("jdbc:oracle:thin:@(DESCRIPTION=(LOAD_BALANCE=on)(ADDRESS=(PROTOCOL=TCP)(HOST=oracle-19c-rac-01.hosts.mwqe.eng.bos.redhat.com)(PORT=1521))(ADDRESS=(PROTOCOL=TCP)(HOST=oracle-19c-rac-02.hosts.mwqe.eng.bos.redhat.com)(PORT=1521))(CONNECT_DATA=(SERVICE_NAME=dballo)))").username("dballo10").password("dballo10");
                break;
            }
            case MARIA_DB: {
                builder.connectionPool().driverClass("org.mariadb.jdbc.Driver").connectionUrl("jdbc:mariadb://mariadb-101.hosts.mwqe.eng.bos.redhat.com:3306/dballo12").username("dballo12").password("dballo12");
                break;
            }
            case DB2: {
                builder.connectionPool().driverClass("com.ibm.db2.jcc.DB2Driver").connectionUrl("jdbc:db2://db2-111.hosts.mwqe.eng.bos.redhat.com:50000/dballo").username("dballo16").password("dballo16");
                break;
            }
            case MYSQL: {
                builder.connectionPool().driverClass("com.mysql.cj.jdbc.Driver").connectionUrl("jdbc:mysql://mysql-80.hosts.mwqe.eng.bos.redhat.com:3306/dballo09").username("dballo09").password("dballo09");
                break;
            }
            case SQLITE: {
                builder.connectionPool().driverClass("org.sqlite.JDBC").connectionUrl("jdbc:sqlite:" + this.tmpDirectory + File.separator + "sqllite.data").username("sa");
                break;
            }
            case SQL_SERVER: {
                builder.connectionPool().driverClass("com.microsoft.sqlserver.jdbc.SQLServerDriver").connectionUrl("jdbc:sqlserver://mssql-2019.msdomain.mw.lab.eng.bos.redhat.com:1433;DatabaseName=dballo04").username("dballo04").password("dballo04");
                break;
            }
            case SYBASE: {
                builder.connectionPool().driverClass("com.sybase.jdbc4.jdbc.SybDriver").connectionUrl("jdbc:sybase:Tds:sybase-160.hosts.mwqe.eng.bos.redhat.com:5000/dballo13").username("dballo13").password("dballo13");
                break;
            }
            default: {
                UnitTestDatabaseManager.configureUniqueConnectionFactory(builder);
            }
        }
    }

    String binaryType() {
        switch (this.DB_TYPE) {
            case POSTGRES: {
                return "BYTEA";
            }
            case ORACLE: {
                return "RAW(255)";
            }
            case SQLITE: {
                return "BINARY";
            }
        }
        return "VARBINARY(255)";
    }

    String dateTimeType() {
        switch (this.DB_TYPE) {
            case MYSQL: 
            case SYBASE: {
                return "DATETIME";
            }
            case SQL_SERVER: {
                return "DATETIME2";
            }
        }
        return "TIMESTAMP";
    }

    protected void createTable(String cacheName, ConnectionFactoryConfigurationBuilder<ConnectionFactoryConfiguration> builder) {
        block17: {
            String upperCaseCacheName = cacheName.toUpperCase();
            String tableCreation = cacheName.equalsIgnoreCase("testPreloadStoredAsBinary") ? "CREATE TABLE " + cacheName + " (keycolumn VARCHAR(255) NOT NULL, NAME VARCHAR(255) NOT NULL, street VARCHAR(255), city VARCHAR(255), zip INT, picture " + this.binaryType() + ", sex VARCHAR(255), birthdate " + this.dateTimeType() + ", PRIMARY KEY (keycolumn))" : (cacheName.equalsIgnoreCase("testStoreByteArrays") ? "CREATE TABLE " + cacheName + " (keycolumn " + this.binaryType() + " NOT NULL, value1 " + this.binaryType() + " NOT NULL, PRIMARY KEY (keycolumn))" : (upperCaseCacheName.startsWith("TESTDBHASMOREVALUECOLUMNS") ? "CREATE TABLE " + cacheName + " (keycolumn VARCHAR(255) NOT NULL, NAME VARCHAR(255) NOT NULL, street VARCHAR(255), city VARCHAR(255), zip INT, picture " + this.binaryType() + ", sex VARCHAR(255), birthdate " + this.dateTimeType() + ", value2 VARCHAR(255), value3 VARCHAR(255), PRIMARY KEY (keycolumn))" : (upperCaseCacheName.startsWith("TESTDBHASMOREKEYCOLUMNS") ? "CREATE TABLE " + cacheName + " (value VARCHAR(255) NOT NULL, keycolumn2 VARCHAR(255) NOT NULL,value1 VARCHAR(255) NOT NULL, PRIMARY KEY (value, keycolumn2))" : (upperCaseCacheName.startsWith("TESTDBHASLESSVALUECOLUMNS") ? "CREATE TABLE " + cacheName + " (keycolumn VARCHAR(255) NOT NULL, NAME VARCHAR(255) NOT NULL, street VARCHAR(255), PRIMARY KEY (keycolumn))" : (upperCaseCacheName.startsWith("TESTEMBEDDED") ? "CREATE TABLE " + cacheName + " (NAME VARCHAR(255) NOT NULL, street VARCHAR(255), city VARCHAR(255), zip INT, picture " + this.binaryType() + ", sex VARCHAR(255), birthdate " + this.dateTimeType() + ", PRIMARY KEY (name))" : (upperCaseCacheName.startsWith("TESTENUMFORVALUE") ? "CREATE TABLE " + cacheName + " (NAME VARCHAR(255) NOT NULL, sex VARCHAR(255), PRIMARY KEY (name))" : (upperCaseCacheName.startsWith("TESTENUMFORKEY") ? "CREATE TABLE " + cacheName + " (sex VARCHAR(255) NOT NULL, name VARCHAR(255), PRIMARY KEY (sex))" : "CREATE TABLE " + cacheName + " (keycolumn VARCHAR(255) NOT NULL, value1 VARCHAR(255) NOT NULL, PRIMARY KEY (keycolumn))")))))));
            ConnectionFactoryConfiguration config = (ConnectionFactoryConfiguration)builder.create();
            ConnectionFactory factory = ConnectionFactory.getConnectionFactory((Class)config.connectionFactoryClass());
            factory.start(config, ((Object)((Object)this)).getClass().getClassLoader());
            Connection connection = null;
            try {
                connection = factory.getConnection();
                String tableName = this.tableToSearch(cacheName);
                try (ResultSet rs = connection.getMetaData().getTables(null, null, tableName, new String[]{"TABLE"});){
                    if (rs.next()) break block17;
                    try (Statement stmt = connection.createStatement();){
                        log.debugf("Table: %s doesn't exist, creating via %s%n", (Object)tableName, (Object)tableCreation);
                        stmt.execute(tableCreation);
                    }
                }
            }
            catch (SQLException t) {
                throw new AssertionError((Object)t);
            }
            finally {
                factory.releaseConnection(connection);
                factory.stop();
            }
        }
    }

    String tableToSearch(String tableName) {
        if (this.DB_TYPE == DatabaseType.POSTGRES) {
            return tableName.toLowerCase();
        }
        return tableName.toUpperCase();
    }
}

