/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.sql;

import java.util.ArrayList;
import java.util.List;
import org.infinispan.persistence.jdbc.common.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class QueryNamedParameterParser {
    private static final Log log = (Log)LogFactory.getLog(QueryNamedParameterParser.class, Log.class);
    private static final String[] START_SKIP = new String[]{"'", "\"", "--", "/*"};
    private static final String[] STOP_SKIP = new String[]{"'", "\"", "\n", "*/"};
    private static final String PARAMETER_SEPARATORS = "\"':&,;()|=+-*%/\\<>^";
    private static final boolean[] separatorIndex = new boolean[128];

    public static ParserResults parseSqlStatement(String sql) {
        StringBuilder sqlToUse = new StringBuilder(sql);
        ArrayList<String> parameterList = new ArrayList<String>();
        char[] statement = sql.toCharArray();
        int escapes = 0;
        int i = 0;
        while (i < statement.length) {
            int j;
            int skipToPosition;
            while (i < statement.length && i != (skipToPosition = QueryNamedParameterParser.skipCommentsAndQuotes(statement, i))) {
                i = skipToPosition;
            }
            if (i >= statement.length) break;
            char c = statement[i];
            if (c == ':' || c == '&') {
                String parameter;
                if (c == ':' && j < statement.length && statement[j] == ':') {
                    i += 2;
                    continue;
                }
                if (c == ':' && j < statement.length && statement[j] == '{') {
                    while (statement[j] != '}') {
                        if (++j >= statement.length) {
                            throw log.nonTerminatedNamedParamInSql(i, sql);
                        }
                        if (statement[j] != ':' && statement[j] != '{') continue;
                        throw log.invalidCharacterInSql(statement[j], i, sql);
                    }
                    if (j - i > 2) {
                        sqlToUse.replace(i - escapes, j - escapes, "?");
                        escapes += j - i - 1;
                        parameter = sql.substring(i + 2, j);
                        parameterList.add(parameter);
                    }
                    ++j;
                } else {
                    for (j = i + 1; j < statement.length && !QueryNamedParameterParser.isParameterSeparator(statement[j]); ++j) {
                    }
                    if (j - i > 1) {
                        sqlToUse.replace(i - escapes, j - escapes, "?");
                        escapes += j - i - 1;
                        parameter = sql.substring(i + 1, j);
                        parameterList.add(parameter);
                    }
                }
                i = j - 1;
            } else {
                if (c == '\\' && (j = i + 1) < statement.length && statement[j] == ':') {
                    sqlToUse.deleteCharAt(i - escapes);
                    ++escapes;
                    i += 2;
                    continue;
                }
                if (c == '?') {
                    throw log.unnamedParametersNotAllowed(i, sql);
                }
            }
            ++i;
        }
        return new ParserResults(sqlToUse.toString(), parameterList);
    }

    private static int skipCommentsAndQuotes(char[] statement, int position) {
        for (int i = 0; i < START_SKIP.length; ++i) {
            if (statement[position] != START_SKIP[i].charAt(0)) continue;
            boolean match = true;
            for (int j = 1; j < START_SKIP[i].length(); ++j) {
                if (statement[position + j] == START_SKIP[i].charAt(j)) continue;
                match = false;
                break;
            }
            if (!match) continue;
            int offset = START_SKIP[i].length();
            for (int m = position + offset; m < statement.length; ++m) {
                if (statement[m] != STOP_SKIP[i].charAt(0)) continue;
                boolean endMatch = true;
                int endPos = m;
                for (int n = 1; n < STOP_SKIP[i].length(); ++n) {
                    if (m + n >= statement.length) {
                        return statement.length;
                    }
                    if (statement[m + n] != STOP_SKIP[i].charAt(n)) {
                        endMatch = false;
                        break;
                    }
                    endPos = m + n;
                }
                if (!endMatch) continue;
                return endPos + 1;
            }
            return statement.length;
        }
        return position;
    }

    private static boolean isParameterSeparator(char c) {
        return c < '\u0080' && separatorIndex[c] || Character.isWhitespace(c);
    }

    static {
        for (char c : PARAMETER_SEPARATORS.toCharArray()) {
            QueryNamedParameterParser.separatorIndex[c] = true;
        }
    }

    public static class ParserResults {
        private final String sqlToUse;
        private final List<String> orderedParameters;

        public ParserResults(String sqlToUse, List<String> orderedParameters) {
            this.sqlToUse = sqlToUse;
            this.orderedParameters = orderedParameters;
        }

        public String getSqlToUse() {
            return this.sqlToUse;
        }

        public List<String> getOrderedParameters() {
            return this.orderedParameters;
        }
    }
}

