/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.sql.configuration;

import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.configuration.cache.PersistenceConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.persistence.jdbc.common.configuration.ConnectionFactoryConfiguration;
import org.infinispan.persistence.jdbc.common.logging.Log;
import org.infinispan.persistence.sql.configuration.AbstractSchemaJdbcConfigurationBuilder;
import org.infinispan.persistence.sql.configuration.TableJdbcStoreConfiguration;

public class TableJdbcStoreConfigurationBuilder
extends AbstractSchemaJdbcConfigurationBuilder<TableJdbcStoreConfiguration, TableJdbcStoreConfigurationBuilder> {
    public TableJdbcStoreConfigurationBuilder(PersistenceConfigurationBuilder builder) {
        super(builder, TableJdbcStoreConfiguration.attributeDefinitionSet());
    }

    public AttributeSet attributes() {
        return this.attributes;
    }

    public TableJdbcStoreConfigurationBuilder self() {
        return this;
    }

    public void validate(GlobalConfiguration globalConfig) {
        super.validate(globalConfig);
        if (this.attributes.attribute(TableJdbcStoreConfiguration.TABLE_NAME).get() == null) {
            throw Log.CONFIG.tableNameMissing();
        }
    }

    public TableJdbcStoreConfigurationBuilder tableName(String tableName) {
        this.attributes.attribute(TableJdbcStoreConfiguration.TABLE_NAME).set((Object)tableName);
        return this;
    }

    public TableJdbcStoreConfiguration create() {
        return new TableJdbcStoreConfiguration(this.attributes.protect(), this.async.create(), this.connectionFactory != null ? (ConnectionFactoryConfiguration)this.connectionFactory.create() : null, this.schemaJdbcConfigurationBuilder.create());
    }

    public String toString() {
        return "TableJdbcStoreConfigurationBuilder [connectionFactory=" + this.connectionFactory + ", attributes=" + this.attributes + ", async=" + this.async + "]";
    }
}

