/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.sql;

import jakarta.transaction.NotSupportedException;
import jakarta.transaction.SystemException;
import jakarta.transaction.TransactionManager;
import java.io.File;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletionException;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.infinispan.Cache;
import org.infinispan.commons.CacheConfigurationException;
import org.infinispan.commons.test.CommonsTestingUtil;
import org.infinispan.commons.test.Exceptions;
import org.infinispan.commons.util.Util;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.persistence.BaseStoreFunctionalTest;
import org.infinispan.persistence.jdbc.common.DatabaseType;
import org.infinispan.persistence.jdbc.common.UnitTestDatabaseManager;
import org.infinispan.persistence.jdbc.common.configuration.ConnectionFactoryConfiguration;
import org.infinispan.persistence.jdbc.common.configuration.ConnectionFactoryConfigurationBuilder;
import org.infinispan.persistence.jdbc.common.configuration.PooledConnectionFactoryConfigurationBuilder;
import org.infinispan.persistence.jdbc.common.connectionfactory.ConnectionFactory;
import org.infinispan.persistence.sql.configuration.AbstractSchemaJdbcConfigurationBuilder;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.data.Address;
import org.infinispan.test.data.Key;
import org.infinispan.test.data.Person;
import org.infinispan.test.data.Sex;
import org.infinispan.transaction.TransactionMode;
import org.postgresql.Driver;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;
import util.JdbcConnection;

public abstract class AbstractSQLStoreFunctionalTest
extends BaseStoreFunctionalTest {
    protected final DatabaseType DB_TYPE;
    protected final boolean transactionalCache;
    protected final boolean transactionalStore;
    protected String tmpDirectory;
    protected Consumer<AbstractSchemaJdbcConfigurationBuilder<?, ?>> schemaConsumer;
    protected static final String DATABASE = System.getProperty("org.infinispan.test.sqlstore.database");
    protected static final String JDBC_URL = System.getProperty("org.infinispan.test.sqlstore.jdbc.url");
    protected static final String JDBC_USERNAME = System.getProperty("org.infinispan.test.sqlstore.jdbc.username");
    protected static final String JDBC_PASSWORD = System.getProperty("org.infinispan.test.sqlstore.jdbc.password");
    protected static Map<DatabaseType, JdbcConnection> databasesFromSystemProperty = new HashMap<DatabaseType, JdbcConnection>();

    public AbstractSQLStoreFunctionalTest(DatabaseType databaseType, boolean transactionalCache, boolean transactionalStore) {
        this.DB_TYPE = databaseType;
        this.transactionalCache = transactionalCache;
        this.transactionalStore = transactionalStore;
    }

    @BeforeClass(alwaysRun=true)
    protected void setUpTempDir() {
        this.tmpDirectory = CommonsTestingUtil.tmpDirectory(((Object)((Object)this)).getClass());
        new File(this.tmpDirectory).mkdirs();
    }

    @BeforeMethod(alwaysRun=true)
    protected void createBeforeMethod() throws Exception {
        this.schemaConsumer = null;
        super.createBeforeMethod();
    }

    @AfterClass(alwaysRun=true)
    protected void clearTempDir() {
        Util.recursiveFileRemove((String)this.tmpDirectory);
    }

    protected Person createEmptyPerson(String name) {
        return new Person(name, new Address(), null, null, null, false);
    }

    protected String parameters() {
        return "[" + this.DB_TYPE + ", transactionalCache=" + this.transactionalCache + ", transactionalStore=" + this.transactionalStore + "]";
    }

    protected ConfigurationBuilder getDefaultCacheConfiguration() {
        ConfigurationBuilder builder = super.getDefaultCacheConfiguration();
        builder.encoding().mediaType("application/x-protostream");
        if (this.transactionalCache) {
            builder.transaction().transactionMode(TransactionMode.TRANSACTIONAL);
        }
        return builder;
    }

    public void testPreloadStoredAsBinary() {
        this.schemaConsumer = builder -> builder.schemaJdbcConfigurationBuilder().embeddedKey(false).messageName("Person").packageName("org.infinispan.test.core");
        super.testPreloadStoredAsBinary();
    }

    @Test(enabled=false, description="Expiration not supported")
    public void testPreloadAndExpiry() {
    }

    @Test(enabled=false, description="Not applicable")
    public void testTwoCachesSameCacheStore() {
    }

    public void testRemoveCacheWithPassivation() {
        if (!this.transactionalStore) {
            super.testRemoveCacheWithPassivation();
        }
    }

    public void testRollback() throws SystemException, NotSupportedException {
        if (!this.transactionalCache) {
            return;
        }
        String cacheName = "testRollback";
        ConfigurationBuilder cb = this.getDefaultCacheConfiguration();
        this.createCacheStoreConfig(cb.persistence(), cacheName, false);
        TestingUtil.defineConfiguration((EmbeddedCacheManager)this.cacheManager, (String)cacheName, (Configuration)cb.build());
        Cache cache = this.cacheManager.getCache(cacheName);
        String key = "rollback-test";
        AssertJUnit.assertNull((Object)cache.get((Object)key));
        TransactionManager manager = cache.getAdvancedCache().getTransactionManager();
        String value = "the-value";
        manager.begin();
        cache.put((Object)key, (Object)value);
        AssertJUnit.assertEquals((Object)value, (Object)cache.get((Object)key));
        manager.rollback();
        AssertJUnit.assertNull((Object)cache.get((Object)key));
    }

    public void testDBHasMoreKeyColumnsWithKeySchema(Method m) {
        this.schemaConsumer = builder -> builder.schemaJdbcConfigurationBuilder().embeddedKey(false).keyMessageName("Key").packageName("org.infinispan.test.core");
        Exceptions.expectException(CacheConfigurationException.class, CompletionException.class, CacheConfigurationException.class, (String)".*Primary key (?i)(KEYCOLUMN2) was not found.*", () -> this.testSimpleGetAndPut(m.getName(), new Key("mykey"), "value"));
    }

    public void testDBHasMoreKeyColumnsWithNoKeySchema(Method m) {
        Exceptions.expectException(CacheConfigurationException.class, CompletionException.class, CacheConfigurationException.class, (String)".*Primary key has multiple columns .*", () -> this.testSimpleGetAndPut(m.getName(), "key", "value"));
    }

    public void testDBHasMoreValueColumnsWithValueSchema(Method m) {
        this.schemaConsumer = builder -> builder.schemaJdbcConfigurationBuilder().embeddedKey(false).messageName("Person").packageName("org.infinispan.test.core");
        Exceptions.expectException(CacheConfigurationException.class, CompletionException.class, CacheConfigurationException.class, (String)".*Additional value columns .* found that were not part of the schema,.*", () -> this.testSimpleGetAndPut(m.getName(), "key", new Person("man2")));
    }

    public void testDBHasMoreValueColumnsWithNoValueSchema(Method m) {
        Exceptions.expectException(CacheConfigurationException.class, CompletionException.class, CacheConfigurationException.class, (String)".*Multiple non key columns but no value message schema defined.*", () -> this.testSimpleGetAndPut(m.getName(), "key", "value"));
    }

    public void testDBHasLessValueColumnsWithSchema(Method m) {
        this.schemaConsumer = builder -> builder.schemaJdbcConfigurationBuilder().embeddedKey(false).messageName("Person").packageName("org.infinispan.test.core");
        this.testSimpleGetAndPut(m.getName(), "key", new Person("joe"));
    }

    public void testEmbeddedKey(Method m) {
        this.schemaConsumer = builder -> builder.schemaJdbcConfigurationBuilder().embeddedKey(true).messageName("Person").packageName("org.infinispan.test.core");
        this.testSimpleGetAndPut(m.getName(), "joe", new Person("joe"));
    }

    public void testEnumForKey(Method m) {
        this.schemaConsumer = builder -> builder.schemaJdbcConfigurationBuilder().embeddedKey(false).keyMessageName("Sex").packageName("org.infinispan.test.core");
        this.testSimpleGetAndPut(m.getName(), Sex.FEMALE, "samantha");
    }

    public void testEnumForValue(Method m) {
        this.schemaConsumer = builder -> builder.schemaJdbcConfigurationBuilder().embeddedKey(false).messageName("Sex").packageName("org.infinispan.test.core");
        this.testSimpleGetAndPut(m.getName(), "samantha", Sex.FEMALE);
    }

    private void testSimpleGetAndPut(String cacheName, Object key, Object value) {
        ConfigurationBuilder cb = this.getDefaultCacheConfiguration();
        this.createCacheStoreConfig(cb.persistence(), cacheName, false);
        TestingUtil.defineConfiguration((EmbeddedCacheManager)this.cacheManager, (String)cacheName, (Configuration)cb.build());
        Cache cache = this.cacheManager.getCache(cacheName);
        AssertJUnit.assertNull((Object)cache.get(key));
        cache.put(key, value);
        AssertJUnit.assertEquals((Object)value, (Object)cache.get(key));
    }

    protected void configureCommonConfiguration(AbstractSchemaJdbcConfigurationBuilder<?, ?> builder) {
        if (this.schemaConsumer != null) {
            this.schemaConsumer.accept(builder);
        }
        PooledConnectionFactoryConfigurationBuilder<?> connectionPool = null;
        if (this.DB_TYPE != DatabaseType.SQLITE && this.DB_TYPE != DatabaseType.H2) {
            connectionPool = this.addJdbcConnection(builder);
        }
        switch (this.DB_TYPE) {
            case POSTGRES: {
                connectionPool.driverClass(Driver.class);
                break;
            }
            case ORACLE: {
                connectionPool.driverClass("oracle.jdbc.OracleDriver");
                break;
            }
            case MARIA_DB: {
                connectionPool.driverClass("org.mariadb.jdbc.Driver");
                break;
            }
            case DB2: {
                connectionPool.driverClass("com.ibm.db2.jcc.DB2Driver");
                break;
            }
            case MYSQL: {
                connectionPool.driverClass("com.mysql.cj.jdbc.Driver");
                break;
            }
            case SQLITE: {
                builder.connectionPool().driverClass("org.sqlite.JDBC").connectionUrl("jdbc:sqlite:" + this.tmpDirectory + File.separator + "sqllite.data").username("sa");
                break;
            }
            case SQL_SERVER: {
                connectionPool.driverClass("com.microsoft.sqlserver.jdbc.SQLServerDriver");
                break;
            }
            case SYBASE: {
                connectionPool.driverClass("com.sybase.jdbc4.jdbc.SybDriver");
                break;
            }
            default: {
                UnitTestDatabaseManager.configureUniqueConnectionFactory(builder);
            }
        }
    }

    String binaryType() {
        switch (this.DB_TYPE) {
            case POSTGRES: {
                return "BYTEA";
            }
            case ORACLE: {
                return "RAW(255)";
            }
            case SQLITE: {
                return "BINARY";
            }
        }
        return "VARBINARY(255)";
    }

    String booleanType() {
        switch (this.DB_TYPE) {
            case SQL_SERVER: {
                return "BIT";
            }
            case ORACLE: 
            case ORACLE_XE: {
                return "NUMBER(1, 0)";
            }
        }
        return "BOOLEAN";
    }

    String dateTimeType() {
        switch (this.DB_TYPE) {
            case MARIA_DB: 
            case MYSQL: 
            case SYBASE: {
                return "DATETIME";
            }
            case SQL_SERVER: {
                return "DATETIME2";
            }
        }
        return "TIMESTAMP";
    }

    protected void createTable(String cacheName, String tableName, ConnectionFactoryConfigurationBuilder<ConnectionFactoryConfiguration> builder) {
        block17: {
            String upperCaseCacheName = cacheName.toUpperCase();
            String tableCreation = cacheName.equalsIgnoreCase("testPreloadStoredAsBinary") ? "CREATE TABLE " + tableName + " (keycolumn VARCHAR(255) NOT NULL, NAME VARCHAR(255) NOT NULL, street VARCHAR(255), city VARCHAR(255), zip INT, picture " + this.binaryType() + ", accepted_tos " + this.booleanType() + ", sex VARCHAR(255), birthdate " + this.dateTimeType() + ", PRIMARY KEY (keycolumn))" : (cacheName.equalsIgnoreCase("testStoreByteArrays") ? "CREATE TABLE " + tableName + " (keycolumn " + this.binaryType() + " NOT NULL, value1 " + this.binaryType() + " NOT NULL, PRIMARY KEY (keycolumn))" : (upperCaseCacheName.startsWith("TESTDBHASMOREVALUECOLUMNS") ? "CREATE TABLE " + tableName + " (keycolumn VARCHAR(255) NOT NULL, NAME VARCHAR(255) NOT NULL, street VARCHAR(255), city VARCHAR(255), zip INT, picture " + this.binaryType() + ", sex VARCHAR(255), birthdate " + this.dateTimeType() + ", value2 VARCHAR(255), value3 VARCHAR(255), PRIMARY KEY (keycolumn))" : (upperCaseCacheName.startsWith("TESTDBHASMOREKEYCOLUMNS") ? "CREATE TABLE " + tableName + " (value VARCHAR(255) NOT NULL, keycolumn2 VARCHAR(255) NOT NULL,value1 VARCHAR(255) NOT NULL, PRIMARY KEY (value, keycolumn2))" : (upperCaseCacheName.startsWith("TESTDBHASLESSVALUECOLUMNS") ? "CREATE TABLE " + tableName + " (keycolumn VARCHAR(255) NOT NULL, NAME VARCHAR(255) NOT NULL, street VARCHAR(255), PRIMARY KEY (keycolumn))" : (upperCaseCacheName.startsWith("TESTEMBEDDED") ? "CREATE TABLE " + tableName + " (NAME VARCHAR(255) NOT NULL, street VARCHAR(255), city VARCHAR(255), zip INT, picture " + this.binaryType() + ", sex VARCHAR(255), birthdate " + this.dateTimeType() + ", PRIMARY KEY (name))" : (upperCaseCacheName.startsWith("TESTENUMFORVALUE") ? "CREATE TABLE " + tableName + " (NAME VARCHAR(255) NOT NULL, sex VARCHAR(255), PRIMARY KEY (name))" : (upperCaseCacheName.startsWith("TESTENUMFORKEY") ? "CREATE TABLE " + tableName + " (sex VARCHAR(255) NOT NULL, name VARCHAR(255), PRIMARY KEY (sex))" : "CREATE TABLE " + tableName + " (keycolumn VARCHAR(255) NOT NULL, value1 VARCHAR(255) NOT NULL, PRIMARY KEY (keycolumn))")))))));
            ConnectionFactoryConfiguration config = (ConnectionFactoryConfiguration)builder.create();
            ConnectionFactory factory = ConnectionFactory.getConnectionFactory((Class)config.connectionFactoryClass());
            factory.start(config, ((Object)((Object)this)).getClass().getClassLoader());
            Connection connection = null;
            try {
                connection = factory.getConnection();
                String modifiedTableName = this.tableToSearch(tableName);
                try (ResultSet rs = connection.getMetaData().getTables(null, null, modifiedTableName, new String[]{"TABLE"});){
                    if (rs.next()) break block17;
                    try (Statement stmt = connection.createStatement();){
                        log.debugf("Table: %s doesn't exist, creating via %s%n", (Object)modifiedTableName, (Object)tableCreation);
                        stmt.execute(tableCreation);
                    }
                }
            }
            catch (SQLException t) {
                throw new AssertionError((Object)t);
            }
            finally {
                factory.releaseConnection(connection);
                factory.stop();
            }
        }
    }

    String tableToSearch(String tableName) {
        if (this.DB_TYPE == DatabaseType.POSTGRES) {
            return tableName.toLowerCase();
        }
        return tableName.toUpperCase();
    }

    private PooledConnectionFactoryConfigurationBuilder<?> addJdbcConnection(AbstractSchemaJdbcConfigurationBuilder<?, ?> builder) {
        if (JDBC_URL != null && JDBC_PASSWORD != null && JDBC_USERNAME != null) {
            JdbcConnection jdbcConnection = databasesFromSystemProperty.get(this.DB_TYPE);
            return builder.connectionPool().connectionUrl(jdbcConnection.getJdbcUrl()).username(jdbcConnection.getUsername()).password(jdbcConnection.getPassword());
        }
        throw new IllegalArgumentException("JDBC connection wasn't provided through System Properties");
    }

    protected static HashMap<DatabaseType, JdbcConnection> getDatabases() {
        Objects.requireNonNull(JDBC_URL);
        Objects.requireNonNull(JDBC_USERNAME);
        Objects.requireNonNull(JDBC_PASSWORD);
        Objects.requireNonNull(DATABASE);
        List databaseTypes = Arrays.stream(DATABASE.split(",")).map(DatabaseType::guessDialect).collect(Collectors.toList());
        HashMap<DatabaseType, JdbcConnection> map = new HashMap<DatabaseType, JdbcConnection>();
        for (int i = 0; i < databaseTypes.size(); ++i) {
            String jdbcURL = JDBC_URL.split(",")[i];
            String username = JDBC_USERNAME.split(",")[i];
            String password = JDBC_PASSWORD.split(",")[i];
            JdbcConnection jdbcConnection = new JdbcConnection(jdbcURL, username, password);
            DatabaseType databaseType = (DatabaseType)databaseTypes.get(i);
            map.put(databaseType, jdbcConnection);
        }
        return map;
    }

    static {
        if (DATABASE != null) {
            databasesFromSystemProperty = AbstractSQLStoreFunctionalTest.getDatabases();
        }
    }
}

