/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.cdi.embedded.test.cachemanager.registration;

import java.util.Arrays;
import java.util.Set;
import javax.inject.Inject;
import org.infinispan.Cache;
import org.infinispan.cdi.embedded.test.DefaultTestEmbeddedCacheManagerProducer;
import org.infinispan.cdi.embedded.test.cachemanager.registration.VeryLarge;
import org.infinispan.cdi.embedded.test.testutil.Deployments;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.fwk.TestResourceTracker;
import org.infinispan.test.fwk.TestResourceTrackingListener;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.testng.Arquillian;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.testng.Assert;
import org.testng.annotations.Listeners;
import org.testng.annotations.Test;

@Listeners(value={TestResourceTrackingListener.class})
@Test(groups={"functional"}, testName="cdi.test.cachemanager.embedded.registration.CacheRegistrationTest")
public class CacheRegistrationTest
extends Arquillian {
    @Inject
    private EmbeddedCacheManager defaultCacheManager;
    @Inject
    private Cache<String, String> cache;
    @VeryLarge
    @Inject
    private EmbeddedCacheManager specificCacheManager;

    @Deployment
    public static Archive<?> deployment() {
        return ((WebArchive)Deployments.baseDeployment().addPackage(CacheRegistrationTest.class.getPackage())).addClass(DefaultTestEmbeddedCacheManagerProducer.class);
    }

    public void testCacheRegistrationInDefaultCacheManager() {
        this.cache.put((Object)"foo", (Object)"bar");
        Set cacheNames = this.defaultCacheManager.getCacheConfigurationNames();
        Assert.assertEquals((int)cacheNames.size(), (int)3);
        Assert.assertTrue((boolean)cacheNames.containsAll(Arrays.asList("small", "large", TestResourceTracker.getCurrentTestShortName())));
    }

    public void testCacheRegistrationInSpecificCacheManager() {
        this.cache.put((Object)"foo", (Object)"bar");
        Set cacheNames = this.specificCacheManager.getCacheConfigurationNames();
        Assert.assertEquals((int)cacheNames.size(), (int)2);
        Assert.assertTrue((boolean)cacheNames.containsAll(Arrays.asList("very-large", TestResourceTracker.getCurrentTestShortName())));
    }
}

