/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.cdi.embedded.test.cache.specific;

import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Disposes;
import javax.enterprise.inject.Produces;
import org.infinispan.cdi.embedded.ConfigureCache;
import org.infinispan.cdi.embedded.test.cache.specific.Large;
import org.infinispan.cdi.embedded.test.cache.specific.Small;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.parsing.ConfigurationBuilderHolder;
import org.infinispan.manager.DefaultCacheManager;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.TestingUtil;

public class Config {
    @Large
    @ConfigureCache(value="large")
    @Produces
    public Configuration largeConfiguration(@Large EmbeddedCacheManager cacheManager) {
        return new ConfigurationBuilder().read(cacheManager.getDefaultCacheConfiguration()).memory().size(2000L).build();
    }

    @Small
    @ConfigureCache(value="small")
    @Produces
    public Configuration smallConfiguration(@Small EmbeddedCacheManager cacheManager) {
        return new ConfigurationBuilder().read(cacheManager.getDefaultCacheConfiguration()).memory().size(20L).build();
    }

    @Large
    @Small
    @Produces
    @ApplicationScoped
    public EmbeddedCacheManager specificCacheManager() {
        ConfigurationBuilderHolder holder = new ConfigurationBuilderHolder();
        holder.getGlobalConfigurationBuilder().defaultCacheName("default");
        ConfigurationBuilder builder = new ConfigurationBuilder();
        builder.memory().size(4000L);
        holder.getNamedConfigurationBuilders().put("default", builder);
        return new DefaultCacheManager(holder, true);
    }

    public void killCacheManager(@Disposes @Small @Large EmbeddedCacheManager cacheManager) {
        TestingUtil.killCacheManagers((EmbeddedCacheManager[])new EmbeddedCacheManager[]{cacheManager});
    }
}

