/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.cdi.embedded.test.assertions;

import java.util.List;
import org.infinispan.cdi.embedded.test.event.CacheObserver;
import org.infinispan.distribution.ch.ConsistentHash;
import org.infinispan.notifications.cachelistener.event.CacheEntriesEvictedEvent;
import org.infinispan.notifications.cachelistener.event.CacheEntryActivatedEvent;
import org.infinispan.notifications.cachelistener.event.CacheEntryCreatedEvent;
import org.infinispan.notifications.cachelistener.event.CacheEntryExpiredEvent;
import org.infinispan.notifications.cachelistener.event.CacheEntryInvalidatedEvent;
import org.infinispan.notifications.cachelistener.event.CacheEntryLoadedEvent;
import org.infinispan.notifications.cachelistener.event.CacheEntryModifiedEvent;
import org.infinispan.notifications.cachelistener.event.CacheEntryPassivatedEvent;
import org.infinispan.notifications.cachelistener.event.CacheEntryRemovedEvent;
import org.infinispan.notifications.cachelistener.event.CacheEntryVisitedEvent;
import org.infinispan.notifications.cachelistener.event.DataRehashedEvent;
import org.infinispan.notifications.cachelistener.event.TopologyChangedEvent;
import org.infinispan.notifications.cachelistener.event.TransactionCompletedEvent;
import org.infinispan.notifications.cachelistener.event.TransactionRegisteredEvent;
import org.infinispan.notifications.cachemanagerlistener.event.CacheStartedEvent;
import org.infinispan.notifications.cachemanagerlistener.event.CacheStoppedEvent;
import org.infinispan.notifications.cachemanagerlistener.event.ViewChangedEvent;
import org.infinispan.remoting.transport.Address;
import org.testng.Assert;

public class ObserverAssertion {
    private CacheObserver observer;
    private Class<?> cacheAnnotation;

    private ObserverAssertion(CacheObserver observer, Class<?> cacheAnnotation) {
        this.cacheAnnotation = cacheAnnotation;
        this.observer = observer;
    }

    public static ObserverAssertion assertThat(CacheObserver observer, Class<?> cacheAnnotation) {
        return new ObserverAssertion(observer, cacheAnnotation);
    }

    private <T> List<T> getNonEmptyListOfEvents(Class<T> eventClass) {
        List<T> events = this.observer.getEventsMap().getEvents(this.cacheAnnotation, eventClass);
        Assert.assertTrue((events.size() > 0 ? 1 : 0) != 0);
        return events;
    }

    public ObserverAssertion hasProperName(String cacheName) {
        Assert.assertEquals((String)this.getNonEmptyListOfEvents(CacheStartedEvent.class).get(0).getCacheName(), (String)cacheName);
        return this;
    }

    public ObserverAssertion hasStartedEvent() {
        this.getNonEmptyListOfEvents(CacheStartedEvent.class);
        return this;
    }

    public ObserverAssertion hasStoppedEvent() {
        this.getNonEmptyListOfEvents(CacheStoppedEvent.class);
        return this;
    }

    public ObserverAssertion hasEntryCreatedEvent(String key) {
        Assert.assertEquals((Object)this.getNonEmptyListOfEvents(CacheEntryCreatedEvent.class).get(0).getKey(), (Object)key);
        return this;
    }

    public ObserverAssertion hasEntryRemovedEvent(String key) {
        Assert.assertEquals((Object)this.getNonEmptyListOfEvents(CacheEntryRemovedEvent.class).get(0).getKey(), (Object)key);
        return this;
    }

    public ObserverAssertion hasEntryActivatedEvent(String key) {
        Assert.assertEquals((Object)this.getNonEmptyListOfEvents(CacheEntryActivatedEvent.class).get(0).getKey(), (Object)key);
        return this;
    }

    public ObserverAssertion hasEntriesEvictedEvent(String key) {
        Assert.assertTrue((boolean)this.getNonEmptyListOfEvents(CacheEntriesEvictedEvent.class).get(0).getEntries().containsKey(key));
        return this;
    }

    public ObserverAssertion hasEntryExpiredEvent(String key) {
        Assert.assertEquals((Object)this.getNonEmptyListOfEvents(CacheEntryExpiredEvent.class).get(0).getKey(), (Object)key);
        return this;
    }

    public ObserverAssertion hasEntryModifiedEvent(String key) {
        Assert.assertEquals((Object)this.getNonEmptyListOfEvents(CacheEntryModifiedEvent.class).get(0).getKey(), (Object)key);
        return this;
    }

    public ObserverAssertion hasEntryInvalidatedEvent(String key) {
        Assert.assertEquals((Object)this.getNonEmptyListOfEvents(CacheEntryInvalidatedEvent.class).get(0).getKey(), (Object)key);
        return this;
    }

    public ObserverAssertion hasEntryLoadedEvent(String key) {
        Assert.assertEquals((Object)this.getNonEmptyListOfEvents(CacheEntryLoadedEvent.class).get(0).getKey(), (Object)key);
        return this;
    }

    public ObserverAssertion hasEntryPassivatedEvent(String key) {
        Assert.assertEquals((Object)this.getNonEmptyListOfEvents(CacheEntryPassivatedEvent.class).get(0).getKey(), (Object)key);
        return this;
    }

    public ObserverAssertion hasEntryVisitedEvent(String key) {
        Assert.assertEquals((Object)this.getNonEmptyListOfEvents(CacheEntryVisitedEvent.class).get(0).getKey(), (Object)key);
        return this;
    }

    public ObserverAssertion hasDataRehashEvent(ConsistentHash newHash) {
        Assert.assertEquals((Object)this.getNonEmptyListOfEvents(DataRehashedEvent.class).get(0).getConsistentHashAtEnd(), (Object)newHash);
        return this;
    }

    public ObserverAssertion hasTransactionCompletedEvent(boolean isSuccesful) {
        Assert.assertEquals((boolean)this.getNonEmptyListOfEvents(TransactionCompletedEvent.class).get(0).isTransactionSuccessful(), (boolean)isSuccesful);
        return this;
    }

    public ObserverAssertion hasTransactionRegisteredEvent(boolean isOriginLocal) {
        Assert.assertEquals((boolean)this.getNonEmptyListOfEvents(TransactionRegisteredEvent.class).get(0).isOriginLocal(), (boolean)isOriginLocal);
        return this;
    }

    public ObserverAssertion hasViewChangedEvent(Address myAddress) {
        Assert.assertEquals((Object)this.getNonEmptyListOfEvents(ViewChangedEvent.class).get(0).getLocalAddress(), (Object)myAddress);
        return this;
    }

    public ObserverAssertion hasTopologyChangedEvent(int topologyId) {
        Assert.assertEquals((int)this.getNonEmptyListOfEvents(TopologyChangedEvent.class).get(0).getNewTopologyId(), (int)topologyId);
        return this;
    }
}

