/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.cdi.test.cache.specific;

import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Disposes;
import javax.enterprise.inject.Produces;
import org.infinispan.cdi.ConfigureCache;
import org.infinispan.cdi.test.cache.specific.Large;
import org.infinispan.cdi.test.cache.specific.Small;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.eviction.EvictionStrategy;
import org.infinispan.manager.DefaultCacheManager;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.TestingUtil;

public class Config {
    @Large
    @ConfigureCache(value="large")
    @Produces
    public Configuration largeConfiguration(@Large EmbeddedCacheManager cacheManager) {
        return new ConfigurationBuilder().read(cacheManager.getDefaultCacheConfiguration()).eviction().maxEntries(2000).build();
    }

    @Small
    @ConfigureCache(value="small")
    @Produces
    public Configuration smallConfiguration(@Small EmbeddedCacheManager cacheManager) {
        return new ConfigurationBuilder().read(cacheManager.getDefaultCacheConfiguration()).eviction().maxEntries(20).build();
    }

    @Large
    @Small
    @Produces
    @ApplicationScoped
    public EmbeddedCacheManager specificCacheManager() {
        ConfigurationBuilder builder = new ConfigurationBuilder();
        builder.eviction().maxEntries(4000).strategy(EvictionStrategy.LIRS);
        return new DefaultCacheManager(builder.build());
    }

    public void killCacheManager(@Disposes @Small @Large EmbeddedCacheManager cacheManager) {
        TestingUtil.killCacheManagers((EmbeddedCacheManager[])new EmbeddedCacheManager[]{cacheManager});
    }
}

