/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.cdi.test.distexec;

import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import javax.inject.Inject;
import org.infinispan.Cache;
import org.infinispan.cdi.Input;
import org.infinispan.cdi.test.DefaultTestEmbeddedCacheManagerProducer;
import org.infinispan.cdi.test.distexec.MultipleCacheManagersArquillianTest;
import org.infinispan.cdi.test.testutil.Deployments;
import org.infinispan.distexec.mapreduce.BaseWordCountMapReduceTest;
import org.infinispan.distexec.mapreduce.Collector;
import org.infinispan.distexec.mapreduce.MapReduceTask;
import org.infinispan.distexec.mapreduce.Mapper;
import org.infinispan.distexec.mapreduce.Reducer;
import org.infinispan.distexec.mapreduce.SimpleTwoNodesMapReduceTest;
import org.infinispan.test.MultipleCacheManagersTest;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="cdi.test.distexec.WordCountMapReduceCDITest")
public class WordCountMapReduceCDITest
extends MultipleCacheManagersArquillianTest {
    BaseWordCountMapReduceTest delegate = new SimpleTwoNodesMapReduceTest();

    @Override
    MultipleCacheManagersTest getDelegate() {
        return this.delegate;
    }

    @Deployment
    public static Archive<?> deployment() {
        return ((WebArchive)Deployments.baseDeployment().addClass(WordCountMapReduceCDITest.class)).addClass(DefaultTestEmbeddedCacheManagerProducer.class);
    }

    public void testinvokeMapReduceOnSubsetOfKeys() throws Exception {
        MapReduceTask task = this.delegate.invokeMapReduce(new String[]{"1", "2", "3"}, (Mapper)new WordCountMapper(), (Reducer)new WordCountReducer());
        Map mapReduce = task.execute();
        Integer count = (Integer)mapReduce.get("Infinispan");
        assert (count == 1);
        count = (Integer)mapReduce.get("Boston");
        assert (count == 1);
    }

    public void testinvokeMapReduceWithInputCacheOnSubsetOfKeys() throws Exception {
        MapReduceTask task = this.delegate.invokeMapReduce(new String[]{"1", "2", "3"}, (Mapper)new WordCountImpliedInputCacheMapper(), (Reducer)new WordCountReducer());
        Map mapReduce = task.execute();
        Integer count = (Integer)mapReduce.get("Infinispan");
        assert (count == 1);
        count = (Integer)mapReduce.get("Boston");
        assert (count == 1);
    }

    private static class WordCountReducer
    implements Reducer<String, Integer> {
        private static final long serialVersionUID = 1901016598354633256L;
        @Inject
        private Cache<String, String> cache;

        private WordCountReducer() {
        }

        public Integer reduce(String key, Iterator<Integer> iter) {
            Assert.assertNotNull(this.cache, (String)("Cache not injected into " + this));
            int sum = 0;
            while (iter.hasNext()) {
                Integer i = iter.next();
                sum += i.intValue();
            }
            return sum;
        }
    }

    private static class WordCountImpliedInputCacheMapper
    implements Mapper<String, String, String, Integer> {
        private static final long serialVersionUID = 7525403183805551028L;
        @Inject
        @Input
        private Cache<String, String> cache;

        private WordCountImpliedInputCacheMapper() {
        }

        public void map(String key, String value, Collector<String, Integer> collector) {
            Assert.assertNotNull(this.cache, (String)("Cache not injected into " + this));
            Assert.assertTrue((boolean)this.cache.getName().equals("mapreducecache"));
            StringTokenizer tokens = new StringTokenizer(value);
            while (tokens.hasMoreElements()) {
                String s = (String)tokens.nextElement();
                collector.emit((Object)s, (Object)1);
            }
        }
    }

    private static class WordCountMapper
    implements Mapper<String, String, String, Integer> {
        private static final long serialVersionUID = -5943370243108735560L;
        @Inject
        private Cache<String, String> cache;

        private WordCountMapper() {
        }

        public void map(String key, String value, Collector<String, Integer> collector) {
            Assert.assertNotNull(this.cache, (String)("Cache not injected into " + this));
            StringTokenizer tokens = new StringTokenizer(value);
            while (tokens.hasMoreElements()) {
                String s = (String)tokens.nextElement();
                collector.emit((Object)s, (Object)1);
            }
        }
    }
}

