/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.cdi.embedded.test.cache.specific;

import javax.enterprise.inject.spi.BeanManager;
import javax.inject.Inject;
import org.infinispan.Cache;
import org.infinispan.cdi.embedded.InfinispanExtensionEmbedded;
import org.infinispan.cdi.embedded.test.DefaultTestEmbeddedCacheManagerProducer;
import org.infinispan.cdi.embedded.test.cache.specific.Large;
import org.infinispan.cdi.embedded.test.cache.specific.Small;
import org.infinispan.cdi.embedded.test.testutil.Deployments;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.testng.Arquillian;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.testng.Assert;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="cdi.test.cache.embedded.specific.SpecificCacheManagerTest")
public class SpecificCacheManagerTest
extends Arquillian {
    @Inject
    private Cache<?, ?> cache;
    @Inject
    @Large
    private Cache<?, ?> largeCache;
    @Inject
    @Small
    private Cache<?, ?> smallCache;
    @Inject
    private InfinispanExtensionEmbedded infinispanExtension;
    @Inject
    private BeanManager beanManager;

    @Deployment
    public static Archive<?> deployment() {
        return ((WebArchive)Deployments.baseDeployment().addPackage(SpecificCacheManagerTest.class.getPackage())).addClass(DefaultTestEmbeddedCacheManagerProducer.class);
    }

    public void testCorrectCacheManagersRegistered() {
        Assert.assertEquals((int)this.infinispanExtension.getInstalledEmbeddedCacheManagers(this.beanManager).size(), (int)2);
    }

    public void testSpecificCacheManager() throws Exception {
        Assert.assertEquals((long)this.largeCache.getCacheConfiguration().memory().size(), (long)2000L);
        Assert.assertEquals((long)this.largeCache.getCacheManager().getDefaultCacheConfiguration().memory().size(), (long)4000L);
        Assert.assertEquals((long)this.smallCache.getCacheConfiguration().memory().size(), (long)20L);
        Assert.assertEquals((long)this.smallCache.getCacheManager().getDefaultCacheConfiguration().memory().size(), (long)4000L);
        AssertJUnit.assertTrue((boolean)this.smallCache.getCacheManager().equals(this.largeCache.getCacheManager()));
        AssertJUnit.assertFalse((boolean)this.smallCache.getCacheManager().equals(this.cache.getCacheManager()));
        Assert.assertEquals((long)this.cache.getCacheConfiguration().memory().size(), (long)-1L);
    }
}

