/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.integrationtests.cdijcache.interceptor.service;

import javax.cache.annotation.CacheKey;
import javax.cache.annotation.CacheResult;
import org.infinispan.integrationtests.cdijcache.interceptor.service.CustomCacheKeyGenerator;

public class CacheResultService {
    private int nbCall = 0;

    @CacheResult
    public String cacheResult(String user) {
        ++this.nbCall;
        return "Morning " + user;
    }

    @CacheResult(cacheName="custom")
    public String cacheResultWithCacheName(String user) {
        ++this.nbCall;
        return "Hi " + user;
    }

    @CacheResult(cacheName="custom")
    public String cacheResultWithCacheKeyParam(@CacheKey String user, String unused) {
        ++this.nbCall;
        return "Hola " + user;
    }

    @CacheResult(cacheName="custom", cacheKeyGenerator=CustomCacheKeyGenerator.class)
    public String cacheResultWithCacheKeyGenerator(String user) {
        ++this.nbCall;
        return "Hello " + user;
    }

    @CacheResult(cacheName="custom", skipGet=true)
    public String cacheResultSkipGet(String user) {
        ++this.nbCall;
        return "Hey " + user;
    }

    @CacheResult(cacheName="small")
    public String cacheResultWithSpecificCacheManager(String user) {
        ++this.nbCall;
        return "Bonjour " + user;
    }

    @CacheResult
    public String defaultCacheResult1(String name) {
        return this.getDefaultCacheResult(name);
    }

    @CacheResult
    public String defaultCacheResult2(String name) {
        return this.getDefaultCacheResult(name);
    }

    private String getDefaultCacheResult(String name) {
        ++this.nbCall;
        return "Hi" + name + "!";
    }

    public int getNbCall() {
        return this.nbCall;
    }
}

