/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.integrationtests.cdijcache.interceptor;

import java.lang.invoke.MethodHandles;
import javax.cache.CacheException;
import javax.inject.Inject;
import org.infinispan.Cache;
import org.infinispan.cdi.embedded.test.DefaultTestEmbeddedCacheManagerProducer;
import org.infinispan.commons.test.TestResourceTrackingListener;
import org.infinispan.integrationtests.cdijcache.Deployments;
import org.infinispan.integrationtests.cdijcache.interceptor.config.Config;
import org.infinispan.integrationtests.cdijcache.interceptor.config.Custom;
import org.infinispan.integrationtests.cdijcache.interceptor.service.CacheRemoveAllService;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.testng.Arquillian;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Listeners;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="cdi.test.interceptor.CacheRemoveAllInterceptorTest")
@Listeners(value={TestResourceTrackingListener.class})
public class CacheRemoveAllInterceptorTest
extends Arquillian {
    @Inject
    private CacheRemoveAllService service;
    @Inject
    @Custom
    private Cache<String, String> customCache;

    @Deployment
    public static Archive<?> deployment() {
        return ((WebArchive)((WebArchive)((WebArchive)((WebArchive)Deployments.baseDeployment().addClass(CacheRemoveAllInterceptorTest.class)).addClass(CacheRemoveAllService.class)).addPackage(Config.class.getPackage())).addClass(DefaultTestEmbeddedCacheManagerProducer.class)).addAsWebInfResource(MethodHandles.lookup().lookupClass().getResource("/beans.xml"), "beans.xml");
    }

    @BeforeMethod
    public void beforeMethod() {
        this.customCache.clear();
        Assert.assertTrue((boolean)this.customCache.isEmpty());
    }

    @Test(expectedExceptions={CacheException.class})
    public void testCacheRemoveAll() {
        this.customCache.put((Object)"Kevin", (Object)"Hi Kevin");
        this.customCache.put((Object)"Pete", (Object)"Hi Pete");
        Assert.assertEquals((int)this.customCache.size(), (int)2);
        this.service.removeAll();
        Assert.assertEquals((int)this.customCache.size(), (int)0);
    }

    public void testCacheRemoveAllWithCacheName() {
        this.customCache.put((Object)"Kevin", (Object)"Hi Kevin");
        this.customCache.put((Object)"Pete", (Object)"Hi Pete");
        Assert.assertEquals((int)this.customCache.size(), (int)2);
        this.service.removeAllWithCacheName();
        Assert.assertEquals((int)this.customCache.size(), (int)0);
    }

    public void testCacheRemoveAllAfterInvocationWithException() {
        this.customCache.put((Object)"Kevin", (Object)"Hi Kevin");
        this.customCache.put((Object)"Pete", (Object)"Hi Pete");
        Assert.assertEquals((int)this.customCache.size(), (int)2);
        try {
            this.service.removeAllAfterInvocationWithException();
        }
        catch (RuntimeException e) {
            Assert.assertEquals((int)this.customCache.size(), (int)2);
        }
    }

    public void testCacheRemoveAllBeforeInvocationWithException() {
        this.customCache.put((Object)"Kevin", (Object)"Hi Kevin");
        this.customCache.put((Object)"Pete", (Object)"Hi Pete");
        Assert.assertEquals((int)this.customCache.size(), (int)2);
        try {
            this.service.removeAllBeforeInvocationWithException();
        }
        catch (RuntimeException e) {
            Assert.assertEquals((int)this.customCache.size(), (int)0);
        }
    }
}

