/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.integrationtests.cdijcache.interceptor;

import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;
import javax.cache.annotation.CacheKey;
import javax.inject.Inject;
import org.infinispan.Cache;
import org.infinispan.cdi.test.DefaultTestEmbeddedCacheManagerProducer;
import org.infinispan.integrationtests.cdijcache.Deployments;
import org.infinispan.integrationtests.cdijcache.interceptor.config.Config;
import org.infinispan.integrationtests.cdijcache.interceptor.config.Custom;
import org.infinispan.integrationtests.cdijcache.interceptor.config.Small;
import org.infinispan.integrationtests.cdijcache.interceptor.service.CacheResultService;
import org.infinispan.integrationtests.cdijcache.interceptor.service.CustomCacheKey;
import org.infinispan.manager.CacheContainer;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.testng.Arquillian;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="cdi.test.interceptor.CacheResultInterceptorTest", description="https://issues.jboss.org/browse/ISPN-3316")
public class CacheResultInterceptorTest
extends Arquillian {
    @Inject
    private CacheContainer cacheContainer;
    @Inject
    private CacheResultService service;
    @Inject
    @Custom
    private Cache<CacheKey, String> customCache;
    @Inject
    @Small
    private Cache<CacheKey, String> smallCache;

    @Deployment
    public static Archive<?> deployment() {
        return ((WebArchive)((WebArchive)((WebArchive)((WebArchive)Deployments.baseDeployment().addClass(CacheResultInterceptorTest.class)).addClass(CacheResultService.class)).addPackage(Config.class.getPackage())).addClass(DefaultTestEmbeddedCacheManagerProducer.class)).addAsWebInfResource(MethodHandles.lookup().lookupClass().getResource("/beans.xml"), "beans.xml");
    }

    @BeforeMethod
    public void beforeMethod() {
        this.customCache.clear();
        Assert.assertTrue((boolean)this.customCache.isEmpty());
    }

    public void testCacheResult() throws NoSuchMethodException {
        StringBuilder cacheName = new StringBuilder().append(CacheResultService.class.getName()).append(".cacheResult(java.lang.String)");
        Cache cache = this.cacheContainer.getCache(cacheName.toString());
        String message = this.service.cacheResult("Foo");
        Assert.assertEquals((String)"Morning Foo", (String)message);
        Assert.assertEquals((int)cache.size(), (int)1);
        message = this.service.cacheResult("Foo");
        Assert.assertEquals((String)"Morning Foo", (String)message);
        Assert.assertEquals((int)cache.size(), (int)1);
        Assert.assertEquals((int)this.service.getNbCall(), (int)1);
    }

    public void testCacheResultWithCacheName() {
        String message = this.service.cacheResultWithCacheName("Pete");
        Assert.assertNotNull((Object)message);
        Assert.assertEquals((String)"Hi Pete", (String)message);
        Assert.assertEquals((int)this.customCache.size(), (int)1);
        message = this.service.cacheResultWithCacheName("Pete");
        Assert.assertNotNull((Object)message);
        Assert.assertEquals((String)"Hi Pete", (String)message);
        Assert.assertEquals((int)this.customCache.size(), (int)1);
        Assert.assertEquals((int)this.service.getNbCall(), (int)1);
    }

    public void testCacheResultWithCacheKeyParam() {
        String message = this.service.cacheResultWithCacheKeyParam("Pete", "foo");
        Assert.assertNotNull((Object)message);
        Assert.assertEquals((String)"Hola Pete", (String)message);
        Assert.assertEquals((int)this.customCache.size(), (int)1);
        message = this.service.cacheResultWithCacheKeyParam("Pete", "foo2");
        Assert.assertNotNull((Object)message);
        Assert.assertEquals((String)"Hola Pete", (String)message);
        Assert.assertEquals((int)this.customCache.size(), (int)1);
        Assert.assertEquals((int)this.service.getNbCall(), (int)1);
    }

    public void testCacheResultWithCustomCacheKeyGenerator() throws NoSuchMethodException {
        Method method = CacheResultService.class.getMethod("cacheResultWithCacheKeyGenerator", String.class);
        String message = this.service.cacheResultWithCacheKeyGenerator("Kevin");
        Assert.assertEquals((String)"Hello Kevin", (String)message);
        Assert.assertEquals((int)this.customCache.size(), (int)1);
        Assert.assertTrue((boolean)this.customCache.containsKey((Object)new CustomCacheKey(method, "Kevin")));
        message = this.service.cacheResultWithCacheKeyGenerator("Kevin");
        Assert.assertEquals((String)"Hello Kevin", (String)message);
        Assert.assertEquals((int)this.customCache.size(), (int)1);
        Assert.assertEquals((int)this.service.getNbCall(), (int)1);
    }

    public void testCacheResultWithSkipGet() throws NoSuchMethodException {
        String message = this.service.cacheResultSkipGet("Manik");
        Assert.assertNotNull((Object)message);
        Assert.assertEquals((String)"Hey Manik", (String)message);
        Assert.assertEquals((int)this.customCache.size(), (int)1);
        message = this.service.cacheResultSkipGet("Manik");
        Assert.assertNotNull((Object)message);
        Assert.assertEquals((String)"Hey Manik", (String)message);
        Assert.assertEquals((int)this.customCache.size(), (int)1);
        Assert.assertEquals((int)this.service.getNbCall(), (int)2);
    }

    public void testCacheResultWithSpecificCacheManager() {
        String message = this.service.cacheResultWithSpecificCacheManager("Pete");
        Assert.assertNotNull((Object)message);
        Assert.assertEquals((String)"Bonjour Pete", (String)message);
        Assert.assertEquals((int)this.smallCache.size(), (int)1);
        message = this.service.cacheResultWithSpecificCacheManager("Pete");
        Assert.assertNotNull((Object)message);
        Assert.assertEquals((String)"Bonjour Pete", (String)message);
        Assert.assertEquals((int)this.smallCache.size(), (int)1);
        Assert.assertEquals((int)this.service.getNbCall(), (int)1);
        Assert.assertEquals((int)this.smallCache.size(), (int)1);
        Assert.assertEquals((long)this.smallCache.getCacheConfiguration().eviction().maxEntries(), (long)4L);
    }

    @Test
    public void testCallingDifferentCachedMethodsWithinTheSameInterceptorChain() throws Exception {
        this.service.defaultCacheResult1("ISPN-5195");
        this.service.defaultCacheResult2("ISPN-5195");
        Assert.assertEquals((int)this.service.getNbCall(), (int)2);
    }
}

