/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.integrationtests.cdijcache.interceptor;

import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;
import javax.cache.CacheException;
import javax.cache.annotation.GeneratedCacheKey;
import javax.inject.Inject;
import org.infinispan.Cache;
import org.infinispan.cdi.test.DefaultTestEmbeddedCacheManagerProducer;
import org.infinispan.integrationtests.cdijcache.Deployments;
import org.infinispan.integrationtests.cdijcache.interceptor.config.Config;
import org.infinispan.integrationtests.cdijcache.interceptor.config.Custom;
import org.infinispan.integrationtests.cdijcache.interceptor.service.CacheRemoveEntryService;
import org.infinispan.integrationtests.cdijcache.interceptor.service.CustomCacheKey;
import org.infinispan.jcache.annotation.DefaultCacheKey;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.testng.Arquillian;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="cdi.test.interceptor.CacheRemoveEntryInterceptorTest")
public class CacheRemoveEntryInterceptorTest
extends Arquillian {
    @Inject
    private CacheRemoveEntryService service;
    @Inject
    @Custom
    private Cache<GeneratedCacheKey, String> customCache;

    @Deployment
    public static Archive<?> deployment() {
        return ((WebArchive)((WebArchive)((WebArchive)((WebArchive)Deployments.baseDeployment().addClass(CacheRemoveEntryInterceptorTest.class)).addClass(CacheRemoveEntryService.class)).addPackage(Config.class.getPackage())).addClass(DefaultTestEmbeddedCacheManagerProducer.class)).addAsWebInfResource(MethodHandles.lookup().lookupClass().getResource("/beans.xml"), "beans.xml");
    }

    @BeforeMethod
    public void beforeMethod() {
        this.customCache.clear();
        Assert.assertTrue((boolean)this.customCache.isEmpty());
    }

    @Test(expectedExceptions={CacheException.class})
    public void testCacheRemoveEntry() {
        this.service.removeEntry("Kevin");
    }

    public void testCacheRemoveEntryWithCacheName() {
        DefaultCacheKey cacheKey = new DefaultCacheKey(new Object[]{"Kevin"});
        this.customCache.put((Object)cacheKey, (Object)"Hello Kevin");
        Assert.assertEquals((int)this.customCache.size(), (int)1);
        Assert.assertTrue((boolean)this.customCache.containsKey((Object)cacheKey));
        this.service.removeEntryWithCacheName("Kevin");
        Assert.assertEquals((int)this.customCache.size(), (int)0);
    }

    public void testCacheRemoveEntryWithCacheKeyParam() {
        DefaultCacheKey cacheKey = new DefaultCacheKey(new Object[]{"Kevin"});
        this.customCache.put((Object)cacheKey, (Object)"Hello Kevin");
        Assert.assertEquals((int)this.customCache.size(), (int)1);
        Assert.assertTrue((boolean)this.customCache.containsKey((Object)cacheKey));
        this.service.removeEntryWithCacheKeyParam("Kevin", "foo");
        Assert.assertEquals((int)this.customCache.size(), (int)0);
    }

    public void testCacheRemoveEntryAfterInvocationWithException() {
        DefaultCacheKey cacheKey = new DefaultCacheKey(new Object[]{"Kevin"});
        this.customCache.put((Object)cacheKey, (Object)"Hello Kevin");
        Assert.assertEquals((int)this.customCache.size(), (int)1);
        Assert.assertTrue((boolean)this.customCache.containsKey((Object)cacheKey));
        try {
            this.service.removeEntryWithCacheName(null);
        }
        catch (NullPointerException e) {
            Assert.assertEquals((int)this.customCache.size(), (int)1);
        }
    }

    public void testCacheRemoveEntryWithCacheKeyGenerator() throws NoSuchMethodException {
        Method method = CacheRemoveEntryService.class.getMethod("removeEntryWithCacheKeyGenerator", String.class);
        CustomCacheKey cacheKey = new CustomCacheKey(method, "Kevin");
        this.customCache.put((Object)cacheKey, (Object)"Hello Kevin");
        Assert.assertEquals((int)this.customCache.size(), (int)1);
        Assert.assertTrue((boolean)this.customCache.containsKey((Object)cacheKey));
        this.service.removeEntryWithCacheKeyGenerator("Kevin");
        Assert.assertEquals((int)this.customCache.size(), (int)0);
    }

    public void testCacheRemoveEntryBeforeInvocationWithException() {
        DefaultCacheKey cacheKey = new DefaultCacheKey(new Object[]{"Kevin"});
        this.customCache.put((Object)cacheKey, (Object)"Hello Kevin");
        Assert.assertEquals((int)this.customCache.size(), (int)1);
        Assert.assertTrue((boolean)this.customCache.containsKey((Object)cacheKey));
        try {
            this.service.removeEntryBeforeInvocationWithException("Kevin");
        }
        catch (NullPointerException e) {
            Assert.assertEquals((int)this.customCache.size(), (int)0);
        }
    }
}

