/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.integrationtests.cdijcache.interceptor.config;

import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Disposes;
import javax.enterprise.inject.Produces;
import org.infinispan.cdi.embedded.ConfigureCache;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.integrationtests.cdijcache.interceptor.config.Custom;
import org.infinispan.integrationtests.cdijcache.interceptor.config.Small;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class Config {
    private static final Log log = LogFactory.getLog(Config.class);
    @Custom
    @ConfigureCache(value="custom")
    @Produces
    public Configuration customConfiguration;
    @Small
    @ConfigureCache(value="small")
    @Produces
    public Configuration smallConfiguration;

    @Small
    @Produces
    @ApplicationScoped
    EmbeddedCacheManager smallCacheManager() {
        ConfigurationBuilder builder = new ConfigurationBuilder();
        builder.eviction().maxEntries(4);
        EmbeddedCacheManager cm = TestCacheManagerFactory.createCacheManager((ConfigurationBuilder)builder);
        log.tracef("Create small cache manager %s", (Object)cm);
        return cm;
    }

    public void killCacheManager(@Disposes @Small EmbeddedCacheManager cacheManager) {
        log.tracef("Kill cache manager via dispose: %s", (Object)cacheManager);
        TestingUtil.killCacheManagers((EmbeddedCacheManager[])new EmbeddedCacheManager[]{cacheManager});
        log.tracef("Killed, cache manager status: %s", (Object)cacheManager.getStatus());
    }
}

