/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.integrationtests.cdijcache.interceptor;

import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;
import javax.cache.annotation.GeneratedCacheKey;
import javax.inject.Inject;
import org.infinispan.Cache;
import org.infinispan.cdi.embedded.test.DefaultTestEmbeddedCacheManagerProducer;
import org.infinispan.integrationtests.cdijcache.Deployments;
import org.infinispan.integrationtests.cdijcache.interceptor.config.Config;
import org.infinispan.integrationtests.cdijcache.interceptor.config.Custom;
import org.infinispan.integrationtests.cdijcache.interceptor.service.CachePutService;
import org.infinispan.integrationtests.cdijcache.interceptor.service.CustomCacheKey;
import org.infinispan.jcache.annotation.DefaultCacheKey;
import org.infinispan.manager.CacheContainer;
import org.infinispan.test.fwk.TestResourceTrackingListener;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.testng.Arquillian;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Listeners;
import org.testng.annotations.Test;

@Listeners(value={TestResourceTrackingListener.class})
@Test(groups={"functional"}, testName="cdi.test.interceptor.CachePutInterceptorTest")
public class CachePutInterceptorTest
extends Arquillian {
    @Inject
    private CachePutService service;
    @Inject
    private CacheContainer cacheContainer;
    @Custom
    @Inject
    private Cache<GeneratedCacheKey, String> customCache;

    @Deployment
    public static Archive<?> deployment() {
        return ((WebArchive)((WebArchive)((WebArchive)((WebArchive)Deployments.baseDeployment().addClass(CachePutInterceptorTest.class)).addClass(CachePutService.class)).addPackage(Config.class.getPackage())).addClass(DefaultTestEmbeddedCacheManagerProducer.class)).addAsWebInfResource(MethodHandles.lookup().lookupClass().getResource("/beans.xml"), "beans.xml");
    }

    @BeforeMethod
    public void beforeMethod() {
        this.customCache.clear();
        Assert.assertTrue((boolean)this.customCache.isEmpty());
    }

    public void testCachePut() {
        StringBuilder cacheName = new StringBuilder().append(CachePutService.class.getName()).append(".put(long,java.lang.String)");
        Cache cache = this.cacheContainer.getCache(cacheName.toString());
        this.service.put(0L, "Manik");
        this.service.put(0L, "Kevin");
        this.service.put(1L, "Pete");
        Assert.assertEquals((int)cache.size(), (int)2);
        Assert.assertTrue((boolean)cache.containsKey((Object)new DefaultCacheKey(new Object[]{0L})));
        Assert.assertTrue((boolean)cache.containsKey((Object)new DefaultCacheKey(new Object[]{1L})));
    }

    public void testCachePutWithCacheName() {
        this.service.putWithCacheName(0L, "Manik");
        this.service.putWithCacheName(0L, "Kevin");
        this.service.putWithCacheName(1L, "Pete");
        Assert.assertEquals((int)this.customCache.size(), (int)2);
        Assert.assertTrue((boolean)this.customCache.containsKey((Object)new DefaultCacheKey(new Object[]{0L})));
        Assert.assertTrue((boolean)this.customCache.containsKey((Object)new DefaultCacheKey(new Object[]{1L})));
    }

    public void testCachePutCacheKeyParam() {
        this.service.putWithCacheKeyParam(0L, 1L, "Manik");
        this.service.putWithCacheKeyParam(0L, 1L, "Kevin");
        this.service.putWithCacheKeyParam(1L, 2L, "Pete");
        Assert.assertEquals((int)this.customCache.size(), (int)2);
        Assert.assertTrue((boolean)this.customCache.containsKey((Object)new DefaultCacheKey(new Object[]{0L})));
        Assert.assertTrue((boolean)this.customCache.containsKey((Object)new DefaultCacheKey(new Object[]{1L})));
    }

    public void testCachePutBeforeInvocation() {
        try {
            this.service.putBeforeInvocation(0L, "Manik");
        }
        catch (RuntimeException e) {
            Assert.assertEquals((int)this.customCache.size(), (int)1);
        }
    }

    public void putWithCacheKeyGenerator() throws Exception {
        Method method = CachePutService.class.getMethod("putWithCacheKeyGenerator", Long.TYPE, String.class);
        this.service.putWithCacheKeyGenerator(0L, "Manik");
        this.service.putWithCacheKeyGenerator(0L, "Kevin");
        this.service.putWithCacheKeyGenerator(1L, "Pete");
        Assert.assertEquals((int)this.customCache.size(), (int)2);
        Assert.assertTrue((boolean)this.customCache.containsKey((Object)new CustomCacheKey(method, 0L)));
        Assert.assertTrue((boolean)this.customCache.containsKey((Object)new CustomCacheKey(method, 0L)));
    }
}

