/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.cli;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import org.infinispan.cli.util.JsonReaderIterator;
import org.junit.Assert;
import org.junit.Test;

public class ReaderIteratorTest {
    @Test
    public void testStructuredJSONIterator() throws IOException {
        String json = "[\n{\n   \"_type\": \"string\",\n   \"_value\": \"lukecage\"\n}\n,\n{\n   \"_type\": \"string\",\n   \"_value\": \"dannyrandy\"\n}\n]";
        StringReader r = new StringReader(json);
        JsonReaderIterator iterator = new JsonReaderIterator((Reader)r, s -> s == null || "_value".equals(s));
        Assert.assertTrue((boolean)iterator.hasNext());
        Assert.assertEquals((Object)"lukecage", (Object)iterator.next());
        Assert.assertTrue((boolean)iterator.hasNext());
        Assert.assertEquals((Object)"dannyrandy", (Object)iterator.next());
    }

    @Test
    public void testUnstructuredJSONIterator() throws IOException {
        String json = "[\"person2.proto\",\"person.proto\"]";
        StringReader r = new StringReader(json);
        JsonReaderIterator iterator = new JsonReaderIterator((Reader)r, s -> s == null || "_value".equals(s));
        Assert.assertTrue((boolean)iterator.hasNext());
        Assert.assertEquals((Object)"person2.proto", (Object)iterator.next());
        Assert.assertTrue((boolean)iterator.hasNext());
        Assert.assertEquals((Object)"person.proto", (Object)iterator.next());
    }
}

