/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.cli.connection.rest;

import java.security.NoSuchAlgorithmException;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import org.infinispan.cli.connection.rest.RestConnection;
import org.infinispan.cli.connection.rest.RestConnector;
import org.infinispan.cli.util.ZeroSecurityTrustManager;
import org.infinispan.client.rest.configuration.RestClientConfiguration;
import org.infinispan.client.rest.configuration.RestClientConfigurationBuilder;
import org.infinispan.client.rest.configuration.ServerConfiguration;
import org.junit.Assert;
import org.junit.Test;

public class RestConnectorTest {
    @Test
    public void testUrlWithCredentials() {
        RestConnector connector = new RestConnector();
        RestConnection connection = (RestConnection)connector.getConnection("http://user:password@localhost:11222", null);
        RestClientConfigurationBuilder builder = connection.getBuilder();
        RestClientConfiguration configuration = builder.build();
        Assert.assertEquals((long)11222L, (long)((ServerConfiguration)configuration.servers().get(0)).port());
        Assert.assertEquals((Object)"localhost", (Object)((ServerConfiguration)configuration.servers().get(0)).host());
        Assert.assertTrue((boolean)configuration.security().authentication().enabled());
        Assert.assertEquals((Object)"user", (Object)configuration.security().authentication().username());
        Assert.assertArrayEquals((char[])"password".toCharArray(), (char[])configuration.security().authentication().password());
    }

    @Test
    public void testUrlWithoutCredentials() {
        RestConnector connector = new RestConnector();
        RestConnection connection = (RestConnection)connector.getConnection("http://localhost:11222", null);
        RestClientConfigurationBuilder builder = connection.getBuilder();
        RestClientConfiguration configuration = builder.build();
        Assert.assertEquals((long)11222L, (long)((ServerConfiguration)configuration.servers().get(0)).port());
        Assert.assertEquals((Object)"localhost", (Object)((ServerConfiguration)configuration.servers().get(0)).host());
        Assert.assertFalse((boolean)configuration.security().authentication().enabled());
    }

    @Test
    public void testUrlWithoutPort() {
        RestConnector connector = new RestConnector();
        RestConnection connection = (RestConnection)connector.getConnection("http://localhost", null);
        RestClientConfigurationBuilder builder = connection.getBuilder();
        RestClientConfiguration configuration = builder.build();
        Assert.assertEquals((long)80L, (long)((ServerConfiguration)configuration.servers().get(0)).port());
        Assert.assertEquals((Object)"localhost", (Object)((ServerConfiguration)configuration.servers().get(0)).host());
        Assert.assertFalse((boolean)configuration.security().authentication().enabled());
    }

    @Test
    public void testUrlWithSSL() throws NoSuchAlgorithmException {
        RestConnector connector = new RestConnector();
        RestConnection connection = (RestConnection)connector.getConnection("https://localhost", null);
        RestClientConfigurationBuilder builder = connection.getBuilder();
        builder.security().ssl().sslContext(SSLContext.getDefault()).trustManagers(new TrustManager[]{new ZeroSecurityTrustManager()});
        RestClientConfiguration configuration = builder.build();
        Assert.assertEquals((long)443L, (long)((ServerConfiguration)configuration.servers().get(0)).port());
        Assert.assertEquals((Object)"localhost", (Object)((ServerConfiguration)configuration.servers().get(0)).host());
        Assert.assertFalse((boolean)configuration.security().authentication().enabled());
        Assert.assertTrue((boolean)configuration.security().ssl().enabled());
    }

    @Test
    public void testEmptyUrl() {
        RestConnector connector = new RestConnector();
        RestConnection connection = (RestConnection)connector.getConnection("", null);
        RestClientConfigurationBuilder builder = connection.getBuilder();
        RestClientConfiguration configuration = builder.build();
        Assert.assertEquals((long)11222L, (long)((ServerConfiguration)configuration.servers().get(0)).port());
        Assert.assertEquals((Object)"localhost", (Object)((ServerConfiguration)configuration.servers().get(0)).host());
    }

    @Test
    public void testPlainHostPort() {
        RestConnector connector = new RestConnector();
        RestConnection connection = (RestConnection)connector.getConnection("my.host.com:12345", null);
        RestClientConfigurationBuilder builder = connection.getBuilder();
        RestClientConfiguration configuration = builder.build();
        Assert.assertEquals((long)12345L, (long)((ServerConfiguration)configuration.servers().get(0)).port());
        Assert.assertEquals((Object)"my.host.com", (Object)((ServerConfiguration)configuration.servers().get(0)).host());
    }
}

