/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.cli.patching;

import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.URI;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.Properties;
import org.infinispan.cli.patching.PatchTool;
import org.infinispan.commons.test.CommonsTestingUtil;
import org.infinispan.commons.test.Exceptions;
import org.infinispan.commons.util.Util;
import org.junit.Assert;
import org.junit.Test;

public class PatchToolTest {
    @Test
    public void testPatchToolCreate() throws IOException {
        Path tmp = Paths.get(CommonsTestingUtil.tmpDirectory(PatchToolTest.class), new String[0]);
        Util.recursiveFileRemove((File)tmp.toFile());
        Files.createDirectories(tmp, new FileAttribute[0]);
        Util.recursiveDirectoryCopy((Path)new File("target/test-classes/patch").toPath(), (Path)tmp);
        Path v1 = tmp.resolve("v1");
        this.createFakeInfinispanCommons(v1, "Infinispan", "1.0.0.Final");
        Path v2 = tmp.resolve("v2");
        this.createFakeInfinispanCommons(v2, "Infinispan", "1.0.1.Final");
        Path v3 = tmp.resolve("v3");
        this.createFakeInfinispanCommons(v3, "Infinispan", "1.1.0.Final");
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ByteArrayOutputStream err = new ByteArrayOutputStream();
        PatchTool patchTool = new PatchTool(new PrintStream(out), new PrintStream(err));
        patchTool.listPatches(v1, false);
        this.assertContains(out, "No patches installed");
        this.assertEmpty(err);
        out.reset();
        Path patch = Paths.get("target/patch.zip", new String[0]);
        patch.toFile().delete();
        patchTool.createPatch("", patch, v3, new Path[]{v1, v2});
        this.assertContains(out, "Adding ");
        this.assertEmpty(err);
        out.reset();
        Exceptions.expectException(FileAlreadyExistsException.class, () -> patchTool.createPatch("", patch, v3, new Path[]{v1, v2}));
        try (FileSystem zipfs = FileSystems.newFileSystem(URI.create("jar:" + patch.toUri().toString()), Collections.emptyMap());){
            Path root = zipfs.getRootDirectories().iterator().next();
            Files.walkFileTree(root, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                    Assert.assertNotEquals((Object)"/.patches", (Object)dir.toString());
                    return super.preVisitDirectory(dir, attrs);
                }

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                    Assert.assertNotEquals((Object)"IGNOREME.txt", (Object)file.getFileName().toString());
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        patchTool.describePatch(patch, false);
        this.assertContains(out, "Infinispan patch target=1.1.0.Final source=1.0.1.Final");
        this.assertContains(out, "Infinispan patch target=1.1.0.Final source=1.0.0.Final");
        this.assertEmpty(err);
        out.reset();
        patchTool.installPatch(patch, v1, false);
        this.assertContains(out, "Infinispan patch target=1.1.0.Final source=1.0.0.Final");
        this.assertEmpty(err);
        out.reset();
        patchTool.listPatches(v1, false);
        this.assertContains(out, "Infinispan patch target=1.1.0.Final source=1.0.0.Final");
        this.assertEmpty(err);
        out.reset();
        patchTool.installPatch(patch, v2, false);
        this.assertContains(out, "Infinispan patch target=1.1.0.Final source=1.0.1.Final");
        this.assertEmpty(err);
        out.reset();
        patchTool.listPatches(v2, false);
        this.assertContains(out, "Infinispan patch target=1.1.0.Final source=1.0.1.Final");
        this.assertEmpty(err);
        out.reset();
        patchTool.rollbackPatch(v1, false);
        this.assertContains(out, "Rolled back patch Infinispan patch target=1.1.0.Final source=1.0.0.Final");
        this.assertEmpty(err);
        out.reset();
        patchTool.listPatches(v1, false);
        this.assertContains(out, "No patches installed");
        this.assertEmpty(err);
        out.reset();
        Path v1config = v1.resolve("server").resolve("conf").resolve("infinispan.xml");
        try (BufferedWriter w = new BufferedWriter(new FileWriter(v1config.toFile(), true));){
            w.newLine();
            w.write("<!-- Some modification -->");
        }
        String v1sha256 = PatchTool.sha256((Path)v1config);
        patchTool.installPatch(patch, v1, false);
        this.assertContains(out, "Infinispan patch target=1.1.0.Final source=1.0.0.Final");
        this.assertEmpty(err);
        out.reset();
        Assert.assertEquals((String)("Expecting SHA-256 of " + v1config + " to stay the same"), (Object)v1sha256, (Object)PatchTool.sha256((Path)v1config));
        Assert.assertTrue((boolean)v1.resolve("server").resolve("conf").resolve("infinispan.xml-1.1.0.Final").toFile().exists());
    }

    private void assertContains(ByteArrayOutputStream out, String contains) {
        String s = out.toString();
        Assert.assertTrue((boolean)s.contains(contains));
    }

    private void assertEmpty(ByteArrayOutputStream out) {
        Assert.assertEquals((Object)"", (Object)out.toString());
    }

    private void createFakeInfinispanCommons(Path base, String brandName, String version) throws IOException {
        Path jar = base.resolve("lib").resolve("infinispan-commons-" + version + ".jar");
        Files.createDirectories(jar.getParent(), new FileAttribute[0]);
        URI jarUri = URI.create("jar:" + jar.toUri().toString());
        try (FileSystem zipfs = FileSystems.newFileSystem(jarUri, Collections.singletonMap("create", "true"));){
            Path propsPath = zipfs.getPath("META-INF", "infinispan-version.properties");
            Files.createDirectories(propsPath.getParent(), new FileAttribute[0]);
            OutputStream os = Files.newOutputStream(propsPath, StandardOpenOption.CREATE);
            Properties properties = new Properties();
            properties.put("infinispan.version", version);
            properties.put("infinispan.brand.name", brandName);
            properties.store(os, null);
            os.close();
        }
    }
}

