/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.cli.commands;

import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import org.aesh.command.CommandDefinition;
import org.aesh.command.CommandException;
import org.aesh.command.CommandResult;
import org.aesh.command.GroupCommandDefinition;
import org.aesh.command.impl.completer.FileOptionCompleter;
import org.aesh.command.option.Argument;
import org.aesh.command.option.Arguments;
import org.aesh.command.option.Option;
import org.aesh.io.Resource;
import org.infinispan.cli.commands.CliCommand;
import org.infinispan.cli.impl.ContextAwareCommandInvocation;
import org.infinispan.cli.logging.Messages;
import org.infinispan.cli.patching.PatchTool;

@GroupCommandDefinition(name="patch", description="Patch operations", groupCommands={Create.class, Describe.class, Install.class, Ls.class, Rollback.class})
public class Patch
extends CliCommand {
    public static final String CMD = "patch";

    @Override
    public CommandResult exec(ContextAwareCommandInvocation invocation) {
        invocation.println(invocation.getHelpInfo());
        return CommandResult.SUCCESS;
    }

    public static Path getServerHome(Resource server) {
        if (server != null) {
            return Paths.get(server.getAbsolutePath(), new String[0]);
        }
        String serverHome = System.getProperty("infinispan.server.home.path");
        if (serverHome != null) {
            return Paths.get(serverHome, new String[0]);
        }
        return Paths.get(System.getProperty("user.dir"), new String[0]);
    }

    @CommandDefinition(name="rollback", description="Rolls back the latest patch installed on this server.")
    public static class Rollback
    extends CliCommand {
        public static final String CMD = "rollback";
        @Option(completer=FileOptionCompleter.class, description="The path to the server installation.")
        Resource server;
        @Option(hasValue=false, name="dry-run", description="Only list the actions that will be performed without executing them.")
        boolean dryRun;

        @Override
        public CommandResult exec(ContextAwareCommandInvocation invocation) throws CommandException {
            PatchTool patchTool = new PatchTool(invocation.getShellOutput(), invocation.getShellError());
            try {
                patchTool.rollbackPatch(Patch.getServerHome(this.server), this.dryRun);
                return CommandResult.SUCCESS;
            }
            catch (IOException e) {
                throw new CommandException((Throwable)e);
            }
        }
    }

    @CommandDefinition(name="ls", description="Lists the patches installed on this server", aliases={"list"})
    public static class Ls
    extends CliCommand {
        public static final String CMD = "ls";
        @Option(completer=FileOptionCompleter.class, description="The path to the server installation.")
        Resource server;
        @Option(shortName=118, hasValue=false, description="List the contents of all installed patches.")
        boolean verbose;

        @Override
        public CommandResult exec(ContextAwareCommandInvocation invocation) {
            PatchTool patchTool = new PatchTool(invocation.getShellOutput(), invocation.getShellError());
            patchTool.listPatches(Patch.getServerHome(this.server), this.verbose);
            return CommandResult.SUCCESS;
        }
    }

    @CommandDefinition(name="install", description="Installs a patch archive")
    public static class Install
    extends CliCommand {
        public static final String CMD = "install";
        @Argument(completer=FileOptionCompleter.class, description="The path to a patch archive")
        Resource patch;
        @Option(completer=FileOptionCompleter.class, description="The path to the server on which the patch will be installed.")
        Resource server;
        @Option(hasValue=false, name="dry-run", description="Only list the actions that will be performed without executing them.")
        boolean dryRun;

        @Override
        public CommandResult exec(ContextAwareCommandInvocation invocation) throws CommandException {
            if (this.patch == null) {
                throw Messages.MSG.patchArchiveArgumentRequired();
            }
            PatchTool patchTool = new PatchTool(invocation.getShellOutput(), invocation.getShellError());
            try {
                patchTool.installPatch(Paths.get(this.patch.getAbsolutePath(), new String[0]), Patch.getServerHome(this.server), this.dryRun);
                return CommandResult.SUCCESS;
            }
            catch (IOException e) {
                throw new CommandException((Throwable)e);
            }
        }
    }

    @CommandDefinition(name="describe", description="Describes the contents of a patch archive")
    public static class Describe
    extends CliCommand {
        public static final String CMD = "describe";
        @Argument(completer=FileOptionCompleter.class, description="The path to a patch archive")
        Resource patch;
        @Option(shortName=118, hasValue=false, description="List the contents of the patch including all the actions that will be performed")
        boolean verbose;

        @Override
        public CommandResult exec(ContextAwareCommandInvocation invocation) throws CommandException {
            if (this.patch == null) {
                throw Messages.MSG.patchArchiveArgumentRequired();
            }
            PatchTool patchTool = new PatchTool(invocation.getShellOutput(), invocation.getShellError());
            try {
                patchTool.describePatch(Paths.get(this.patch.getAbsolutePath(), new String[0]), this.verbose);
                return CommandResult.SUCCESS;
            }
            catch (IOException e) {
                throw new CommandException((Throwable)e);
            }
        }
    }

    @CommandDefinition(name="create", description="Creates a patch archive")
    public static class Create
    extends CliCommand {
        public static final String CMD = "create";
        @Option(defaultValue={""}, shortName=113, description="A qualifier for this patch (e.g. `one-off`)")
        String qualifier;
        @Arguments(completer=FileOptionCompleter.class, description="The path to the patch archive, the path to the target server and one or more paths to the source servers")
        List<Resource> paths;

        @Override
        public CommandResult exec(ContextAwareCommandInvocation invocation) throws CommandException {
            if (this.paths == null || this.paths.size() < 3) {
                throw Messages.MSG.patchCreateArgumentsRequired();
            }
            PatchTool patchTool = new PatchTool(invocation.getShellOutput(), invocation.getShellError());
            try {
                Path patch = Paths.get(this.paths.get(0).getAbsolutePath(), new String[0]);
                Path target = Paths.get(this.paths.get(1).getAbsolutePath(), new String[0]);
                Path[] sources = new Path[this.paths.size() - 2];
                for (int i = 2; i < this.paths.size(); ++i) {
                    sources[i - 2] = Paths.get(this.paths.get(i).getAbsolutePath(), new String[0]);
                }
                patchTool.createPatch(this.qualifier, patch, target, sources);
                return CommandResult.SUCCESS;
            }
            catch (IOException e) {
                throw new CommandException((Throwable)e);
            }
        }
    }
}

