/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.cli;

import org.infinispan.cli.connection.jmx.rmi.JMXRMIUrl;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="cli.JMXRMIUrlTest")
public class JMXRMIUrlTest {
    public void testValidJMXUrl() {
        JMXRMIUrl jmxUrl = new JMXRMIUrl("jmx://localhost:12345");
        assert ("service:jmx:rmi:///jndi/rmi://localhost:12345/jmxrmi".equals(jmxUrl.getJMXServiceURL()));
    }

    public void testValidJMXUrlWithContainer() {
        JMXRMIUrl jmxUrl = new JMXRMIUrl("jmx://localhost:12345/container");
        assert ("service:jmx:rmi:///jndi/rmi://localhost:12345/jmxrmi".equals(jmxUrl.getJMXServiceURL()));
        assert ("container".equals(jmxUrl.getContainer()));
    }

    public void testValidJMXUrlWithContainerAndCache() {
        JMXRMIUrl jmxUrl = new JMXRMIUrl("jmx://localhost:12345/container/cache");
        assert ("service:jmx:rmi:///jndi/rmi://localhost:12345/jmxrmi".equals(jmxUrl.getJMXServiceURL()));
        assert ("container".equals(jmxUrl.getContainer()));
        assert ("cache".equals(jmxUrl.getCache()));
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testInvalidJMXUrl() {
        new JMXRMIUrl("hotrod://localhost:12345");
    }
}

