/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.cli;

import org.infinispan.cli.connection.jmx.remoting.JMXRemotingUrl;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="cli.JMXRemotingUrlTest")
public class JMXRemotingUrlTest {
    public void testValidJMXUrl() {
        JMXRemotingUrl jmxUrl = new JMXRemotingUrl("remoting://localhost:12345");
        assert ("service:jmx:remoting-jmx://localhost:12345".equals(jmxUrl.getJMXServiceURL()));
    }

    public void testValidJMXUrlWithContainer() {
        JMXRemotingUrl jmxUrl = new JMXRemotingUrl("remoting://localhost:12345/container");
        assert ("service:jmx:remoting-jmx://localhost:12345".equals(jmxUrl.getJMXServiceURL()));
        assert ("container".equals(jmxUrl.getContainer()));
    }

    public void testValidJMXUrlWithContainerAndCache() {
        JMXRemotingUrl jmxUrl = new JMXRemotingUrl("remoting://localhost:12345/container/cache");
        assert ("service:jmx:remoting-jmx://localhost:12345".equals(jmxUrl.getJMXServiceURL()));
        assert ("container".equals(jmxUrl.getContainer()));
        assert ("cache".equals(jmxUrl.getCache()));
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testInvalidJMXUrl() {
        new JMXRemotingUrl("hotrod://localhost:12345");
    }
}

