/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.cli;

import org.infinispan.cli.connection.jmx.rmi.JMXRMIUrl;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="cli.JMXRMIUrlTest")
public class JMXRMIUrlTest {
    public void testValidJMXUrl() {
        JMXRMIUrl jmxUrl = new JMXRMIUrl("jmx://localhost:12345");
        AssertJUnit.assertEquals((String)"service:jmx:rmi:///jndi/rmi://localhost:12345/jmxrmi", (String)jmxUrl.getJMXServiceURL());
    }

    public void testValidJMXUrlWithContainer() {
        JMXRMIUrl jmxUrl = new JMXRMIUrl("jmx://localhost:12345/container");
        AssertJUnit.assertEquals((String)"service:jmx:rmi:///jndi/rmi://localhost:12345/jmxrmi", (String)jmxUrl.getJMXServiceURL());
        AssertJUnit.assertEquals((String)"container", (String)jmxUrl.getContainer());
    }

    public void testValidJMXUrlWithContainerAndCache() {
        JMXRMIUrl jmxUrl = new JMXRMIUrl("jmx://localhost:12345/container/cache");
        AssertJUnit.assertEquals((String)"service:jmx:rmi:///jndi/rmi://localhost:12345/jmxrmi", (String)jmxUrl.getJMXServiceURL());
        AssertJUnit.assertEquals((String)"container", (String)jmxUrl.getContainer());
        AssertJUnit.assertEquals((String)"cache", (String)jmxUrl.getCache());
    }

    public void testValidIPV6JMXUrl() {
        JMXRMIUrl jmxUrl = new JMXRMIUrl("jmx://[FEDC:BA98:7654:3210:FEDC:BA98:7654:3210]:12345");
        AssertJUnit.assertEquals((String)"service:jmx:rmi:///jndi/rmi://[FEDC:BA98:7654:3210:FEDC:BA98:7654:3210]:12345/jmxrmi", (String)jmxUrl.getJMXServiceURL());
    }

    public void testValidIPV6JMXUrlWithContainerAndCache() {
        JMXRMIUrl jmxUrl = new JMXRMIUrl("jmx://[FEDC:BA98:7654:3210:FEDC:BA98:7654:3210]:12345/container/cache");
        AssertJUnit.assertEquals((String)"service:jmx:rmi:///jndi/rmi://[FEDC:BA98:7654:3210:FEDC:BA98:7654:3210]:12345/jmxrmi", (String)jmxUrl.getJMXServiceURL());
        AssertJUnit.assertEquals((String)"container", (String)jmxUrl.getContainer());
        AssertJUnit.assertEquals((String)"cache", (String)jmxUrl.getCache());
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testInvalidJMXUrl() {
        new JMXRMIUrl("hotrod://localhost:12345");
    }
}

