/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.cli;

import org.infinispan.cli.connection.jmx.remoting.JMXRemotingUrl;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="cli.JMXRemotingUrlTest")
public class JMXRemotingUrlTest {
    public void testValidJMXUrl() {
        JMXRemotingUrl jmxUrl = new JMXRemotingUrl("remoting://localhost:12345");
        AssertJUnit.assertEquals((String)"service:jmx:remoting-jmx://localhost:12345", (String)jmxUrl.getJMXServiceURL());
    }

    public void testValidJMXUrlWithContainer() {
        JMXRemotingUrl jmxUrl = new JMXRemotingUrl("remoting://localhost:12345/container");
        AssertJUnit.assertEquals((String)"service:jmx:remoting-jmx://localhost:12345", (String)jmxUrl.getJMXServiceURL());
        AssertJUnit.assertEquals((String)"container", (String)jmxUrl.getContainer());
    }

    public void testValidJMXUrlWithContainerAndCache() {
        JMXRemotingUrl jmxUrl = new JMXRemotingUrl("remoting://localhost:12345/container/cache");
        AssertJUnit.assertEquals((String)"service:jmx:remoting-jmx://localhost:12345", (String)jmxUrl.getJMXServiceURL());
        AssertJUnit.assertEquals((String)"container", (String)jmxUrl.getContainer());
        AssertJUnit.assertEquals((String)"cache", (String)jmxUrl.getCache());
    }

    public void testValidIPV6JMXUrl() {
        JMXRemotingUrl jmxUrl = new JMXRemotingUrl("remoting://[FEDC:BA98:7654:3210:FEDC:BA98:7654:3210]:12345");
        AssertJUnit.assertEquals((String)"service:jmx:remoting-jmx://[FEDC:BA98:7654:3210:FEDC:BA98:7654:3210]:12345", (String)jmxUrl.getJMXServiceURL());
    }

    public void testValidIPV6JMXUrlWithContainerAndCache() {
        JMXRemotingUrl jmxUrl = new JMXRemotingUrl("remoting://[FEDC:BA98:7654:3210:FEDC:BA98:7654:3210]:12345/container/cache");
        AssertJUnit.assertEquals((String)"service:jmx:remoting-jmx://[FEDC:BA98:7654:3210:FEDC:BA98:7654:3210]:12345", (String)jmxUrl.getJMXServiceURL());
        AssertJUnit.assertEquals((String)"container", (String)jmxUrl.getContainer());
        AssertJUnit.assertEquals((String)"cache", (String)jmxUrl.getCache());
    }

    public void testEmptyJMXUrl() {
        JMXRemotingUrl jmxUrl = new JMXRemotingUrl("");
        AssertJUnit.assertEquals((String)"service:jmx:remoting-jmx://localhost:9999", (String)jmxUrl.getJMXServiceURL());
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testInvalidJMXUrl() {
        new JMXRemotingUrl("hotrod://localhost:12345");
    }
}

