/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.cli.shell;

import gnu.getopt.Getopt;
import gnu.getopt.LongOpt;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.fusesource.jansi.Ansi;
import org.infinispan.cli.Config;
import org.infinispan.cli.Context;
import org.infinispan.cli.commands.Command;
import org.infinispan.cli.commands.ProcessedCommand;
import org.infinispan.cli.commands.server.Ping;
import org.infinispan.cli.commands.server.Version;
import org.infinispan.cli.connection.Connection;
import org.infinispan.cli.connection.ConnectionFactory;
import org.infinispan.cli.impl.CommandBufferImpl;
import org.infinispan.cli.impl.ContextImpl;
import org.infinispan.cli.io.ConsoleIOAdapter;
import org.infinispan.cli.io.StreamIOAdapter;
import org.infinispan.cli.shell.CLIConsoleCallback;
import org.infinispan.cli.shell.Color;
import org.infinispan.cli.shell.Completer;
import org.infinispan.cli.shell.ConfigImpl;
import org.infinispan.cli.shell.Prompt;
import org.infinispan.cli.shell.Shell;
import org.infinispan.cli.shell.ShellMode;
import org.infinispan.cli.util.SystemUtils;
import org.jboss.aesh.complete.Completion;
import org.jboss.aesh.console.Console;
import org.jboss.aesh.console.ConsoleCallback;
import org.jboss.aesh.console.settings.SettingsBuilder;

public class ShellImpl
implements Shell {
    private static final int SESSION_PING_TIMEOUT = 30;
    private Config config;
    private Console console;
    private Context context;
    private ShellMode mode = ShellMode.INTERACTIVE;
    private String inputFile;
    private ScheduledFuture<?> sessionPingTask;

    @Override
    public void init(String[] args) throws Exception {
        int c;
        this.context = new ContextImpl(new StreamIOAdapter(), new CommandBufferImpl());
        String sopts = "c:f:hv";
        LongOpt[] lopts = new LongOpt[]{new LongOpt("connect", 1, null, 99), new LongOpt("file", 1, null, 102), new LongOpt("help", 0, null, 104), new LongOpt("version", 0, null, 118)};
        Getopt g = new Getopt("ispn-cli", args, sopts, lopts);
        while ((c = g.getopt()) != -1) {
            switch (c) {
                case 99: {
                    Connection connection = ConnectionFactory.getConnection(g.getOptarg());
                    String password = null;
                    if (connection.needsCredentials()) {
                        java.io.Console sysConsole = System.console();
                        if (sysConsole != null) {
                            password = new String(sysConsole.readPassword("Password: ", new Object[0]));
                        } else {
                            this.exitWithError("Cannot read password non-interactively", new Object[0]);
                        }
                    }
                    connection.connect(password);
                    this.context.setConnection(connection);
                    break;
                }
                case 102: {
                    this.inputFile = g.getOptarg();
                    if ("-".equals(this.inputFile) || new File(this.inputFile).isFile()) {
                        this.mode = ShellMode.BATCH;
                        break;
                    }
                    this.exitWithError("File '%s' doesn't exist or is not a file", g.getOptarg());
                    break;
                }
                case 104: {
                    this.help();
                    break;
                }
                case 118: {
                    this.version();
                }
            }
        }
    }

    private void exitWithError(String format, Object ... args) {
        System.err.printf(format, args);
        System.err.println();
        System.exit(1);
    }

    @Override
    public void run() throws IOException {
        switch (this.mode) {
            case BATCH: {
                this.batchRun();
                break;
            }
            case INTERACTIVE: {
                this.interactiveRun();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void batchRun() throws IOException {
        InputStreamReader r = "-".equals(this.inputFile) ? new InputStreamReader(System.in) : new FileReader(this.inputFile);
        try (BufferedReader br = new BufferedReader(r);){
            String line = br.readLine();
            while (line != null) {
                this.execute(line);
                line = br.readLine();
            }
        }
    }

    private void interactiveRun() throws IOException {
        this.config = new ConfigImpl(SystemUtils.getAppConfigFolder("InfinispanShell"));
        this.config.load();
        SettingsBuilder settings = new SettingsBuilder();
        settings.enableAlias(false).outputStream(System.out).outputStreamError(System.err).inputStream(System.in);
        this.console = new Console(settings.create());
        this.context.setOutputAdapter(new ConsoleIOAdapter(this.console));
        this.console.addCompletion((Completion)new Completer(this.context));
        this.console.setConsoleCallback((ConsoleCallback)new CLIConsoleCallback());
        this.console.start();
        ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor();
        this.sessionPingTask = executor.scheduleWithFixedDelay(new PingTask(), 30L, 30L, TimeUnit.SECONDS);
        while (!this.context.isQuitting()) {
            try {
                this.context.refreshProperties();
                String line = this.context.getOutputAdapter().readln(this.getPrompt());
                if (line == null || "".equals(line.trim())) continue;
                this.execute(line);
            }
            catch (Exception e) {
                this.context.error(e);
            }
        }
        try {
            this.sessionPingTask.cancel(true);
            executor.shutdownNow();
            this.config.save();
            this.console.stop();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void execute(String line) {
        ProcessedCommand parsed = new ProcessedCommand(line);
        Command command = this.context.getCommandRegistry().getCommand(parsed.getCommand());
        if (command != null) {
            command.execute(this.context, parsed);
        } else {
            this.context.error("Command " + parsed.getCommand() + " unknown or not available");
        }
    }

    private String getPrompt() {
        return Prompt.echo(this, Prompt.promptExpressionParser(this, this.config.getPrompt()));
    }

    @Override
    public String renderColor(Color color, String output) {
        if (!this.config.isColorEnabled()) {
            return output;
        }
        Ansi ansi = new Ansi();
        switch (color) {
            case BLACK: {
                ansi.fg(Ansi.Color.BLACK);
                break;
            }
            case BLUE: {
                ansi.fg(Ansi.Color.BLUE);
                break;
            }
            case CYAN: {
                ansi.fg(Ansi.Color.CYAN);
                break;
            }
            case GREEN: {
                ansi.fg(Ansi.Color.GREEN);
                break;
            }
            case MAGENTA: {
                ansi.fg(Ansi.Color.MAGENTA);
                break;
            }
            case RED: {
                ansi.fg(Ansi.Color.RED);
                break;
            }
            case WHITE: {
                ansi.fg(Ansi.Color.WHITE);
                break;
            }
            case YELLOW: {
                ansi.fg(Ansi.Color.YELLOW);
                break;
            }
            case BOLD: {
                ansi.a(Ansi.Attribute.INTENSITY_BOLD);
                break;
            }
            case ITALIC: {
                ansi.a(Ansi.Attribute.ITALIC);
                ansi.a(Ansi.Attribute.INTENSITY_FAINT);
                break;
            }
            default: {
                return output;
            }
        }
        return ansi.render(output).reset().toString();
    }

    @Override
    public String getCWD() {
        File directory = new File(".");
        return directory.getAbsolutePath();
    }

    @Override
    public Context getContext() {
        return this.context;
    }

    private void help() {
        System.out.println("Usage: ispn-cli [OPTION]...");
        System.out.printf("%s command-line interface\n", Version.class.getPackage().getImplementationTitle());
        System.out.println();
        System.out.println("Options:");
        System.out.println("  -c, --connect=URL       connects to a running instance of Infinispan. ");
        System.out.println("                          JMX over RMI jmx://[username[:password]]@host:port[/container[/cache]]");
        System.out.println("                          JMX over JBoss remoting remoting://[username[:password]]@host:port[/container[/cache]]");
        System.out.println("  -f, --file=FILE         reads input from the specified file instead of using ");
        System.out.println("                          interactive mode. If FILE is '-', then commands will be read");
        System.out.println("                          from stdin");
        System.out.println("  -h, --help              shows this help page");
        System.out.println("  -v, --version           shows version information");
        System.exit(0);
    }

    private void version() {
        System.out.println("ispn-cli " + Version.class.getPackage().getImplementationVersion());
        System.out.println("Copyright (C) Red Hat Inc. and/or its affiliates and other contributors");
        System.out.println("License Apache License, v. 2.0. http://www.apache.org/licenses/LICENSE-2.0");
        System.exit(0);
    }

    class PingTask
    implements Runnable {
        Ping ping = new Ping();

        PingTask() {
        }

        @Override
        public void run() {
            if (ShellImpl.this.context.isConnected()) {
                this.ping.execute(ShellImpl.this.context, null);
            }
        }
    }
}

