/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.cli.interpreter;

import java.util.Properties;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.infinispan.cli.interpreter.Interpreter;
import org.infinispan.cli.interpreter.logging.Log;
import org.infinispan.commons.jmx.JmxUtil;
import org.infinispan.commons.jmx.MBeanServerLookup;
import org.infinispan.configuration.global.GlobalJmxStatisticsConfiguration;
import org.infinispan.factories.GlobalComponentRegistry;
import org.infinispan.factories.components.ManageableComponentMetadata;
import org.infinispan.jmx.ComponentsJmxRegistration;
import org.infinispan.jmx.ResourceDMBean;
import org.infinispan.lifecycle.ModuleLifecycle;
import org.infinispan.util.logging.LogFactory;

public class LifecycleCallbacks
implements ModuleLifecycle {
    private static final Log log = (Log)LogFactory.getLog(LifecycleCallbacks.class, Log.class);
    private ObjectName interpreterObjName;

    public void cacheManagerStarted(GlobalComponentRegistry gcr) {
        GlobalJmxStatisticsConfiguration globalCfg = gcr.getGlobalConfiguration().globalJmxStatistics();
        if (globalCfg.enabled()) {
            MBeanServer mbeanServer = JmxUtil.lookupMBeanServer((MBeanServerLookup)globalCfg.mbeanServerLookup(), (Properties)globalCfg.properties());
            String groupName = this.getGroupName(globalCfg.cacheManagerName());
            Interpreter interpreter = new Interpreter();
            gcr.registerComponent((Object)interpreter, Interpreter.class);
            ManageableComponentMetadata meta = gcr.getComponentMetadataRepo().findComponentMetadata(Interpreter.class).toManageableComponentMetadata();
            try {
                ResourceDMBean mbean = new ResourceDMBean((Object)interpreter, meta);
                this.interpreterObjName = new ObjectName(String.format("%s:%s,component=Interpreter", globalCfg.domain(), groupName));
                JmxUtil.registerMBean((Object)mbean, (ObjectName)this.interpreterObjName, (MBeanServer)mbeanServer);
            }
            catch (Exception e) {
                this.interpreterObjName = null;
                log.jmxRegistrationFailed();
            }
        }
    }

    private String getGroupName(String name) {
        return "type=CacheManager," + ComponentsJmxRegistration.NAME_KEY + "=" + ObjectName.quote(name);
    }

    public void cacheManagerStopping(GlobalComponentRegistry gcr) {
        if (this.interpreterObjName != null) {
            GlobalJmxStatisticsConfiguration jmxConfig = gcr.getGlobalConfiguration().globalJmxStatistics();
            MBeanServer mbeanServer = JmxUtil.lookupMBeanServer((MBeanServerLookup)jmxConfig.mbeanServerLookup(), (Properties)jmxConfig.properties());
            try {
                JmxUtil.unregisterMBean((ObjectName)this.interpreterObjName, (MBeanServer)mbeanServer);
            }
            catch (Exception e) {
                log.jmxUnregistrationFailed();
            }
        }
    }
}

