package org.infinispan.cli.interpreter.logging;

import java.util.Locale;
import java.lang.IllegalStateException;
import java.io.Serializable;
import javax.annotation.Generated;
import org.infinispan.cli.interpreter.result.StatementException;
import org.infinispan.commons.CacheException;
import org.jboss.logging.DelegatingBasicLogger;
import java.util.ServiceConfigurationError;
import java.lang.String;
import org.jboss.logging.Logger;
import java.lang.Exception;
import javax.transaction.SystemException;
import org.jboss.logging.BasicLogger;
import java.lang.Throwable;
import org.infinispan.cli.interpreter.codec.CodecException;
import java.util.Arrays;
import java.lang.IllegalArgumentException;


import static org.jboss.logging.Logger.Level.ERROR;
import static org.jboss.logging.Logger.Level.WARN;

/**
 * Warning this class consists of generated code.
 */
@Generated(value = "org.jboss.logging.processor.generator.model.MessageLoggerImplementor", date = "2019-03-22T15:58:23+0000")
public class Log_$logger extends DelegatingBasicLogger implements Log, BasicLogger, Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = Log_$logger.class.getName();
    public Log_$logger(final Logger log) {
        super(log);
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    @Override
    public final void jmxRegistrationFailed() {
        super.log.logf(FQCN, ERROR, null, jmxRegistrationFailed$str());
    }
    private static final String jmxRegistrationFailed = "ISPN019001: Could not register interpreter MBean";
    protected String jmxRegistrationFailed$str() {
        return jmxRegistrationFailed;
    }
    @Override
    public final void jmxUnregistrationFailed() {
        super.log.logf(FQCN, ERROR, null, jmxUnregistrationFailed$str());
    }
    private static final String jmxUnregistrationFailed = "ISPN019002: Could not unregister interpreter MBean";
    protected String jmxUnregistrationFailed$str() {
        return jmxUnregistrationFailed;
    }
    @Override
    public final void interpreterError(final Throwable t) {
        super.log.logf(FQCN, ERROR, t, interpreterError$str());
    }
    private static final String interpreterError = "ISPN019003: Interpreter error";
    protected String interpreterError$str() {
        return interpreterError;
    }
    private static final String missingUpgradeAction = "ISPN019004: No action has been specified for the upgrade command";
    protected String missingUpgradeAction$str() {
        return missingUpgradeAction;
    }
    @Override
    public final StatementException missingUpgradeAction() {
        final StatementException result = new StatementException(String.format(getLoggingLocale(), missingUpgradeAction$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String missingMigrator = "ISPN019005: No migrator has been specified";
    protected String missingMigrator$str() {
        return missingMigrator;
    }
    @Override
    public final StatementException missingMigrator() {
        final StatementException result = new StatementException(String.format(getLoggingLocale(), missingMigrator$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unknownOption = "ISPN019006: Unknown option '%s'";
    protected String unknownOption$str() {
        return unknownOption;
    }
    @Override
    public final StatementException unknownOption(final String name) {
        final StatementException result = new StatementException(String.format(getLoggingLocale(), unknownOption$str(), name));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String missingOptionParameter = "ISPN019007: The option %s requires a parameter";
    protected String missingOptionParameter$str() {
        return missingOptionParameter;
    }
    @Override
    public final StatementException missingOptionParameter(final String name) {
        final StatementException result = new StatementException(String.format(getLoggingLocale(), missingOptionParameter$str(), name));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String keyEncodingFailed = "ISPN019008: Failure while encoding key using codec '%s'";
    protected String keyEncodingFailed$str() {
        return keyEncodingFailed;
    }
    @Override
    public final CodecException keyEncodingFailed(final Exception e, final String codec) {
        final CodecException result = new CodecException(String.format(getLoggingLocale(), keyEncodingFailed$str(), codec), e);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String keyDecodingFailed = "ISPN019009: Failure while decoding key using codec '%s'";
    protected String keyDecodingFailed$str() {
        return keyDecodingFailed;
    }
    @Override
    public final CodecException keyDecodingFailed(final Exception e, final String codec) {
        final CodecException result = new CodecException(String.format(getLoggingLocale(), keyDecodingFailed$str(), codec), e);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String valueEncodingFailed1 = "ISPN019010: Failure while encoding value using codec '%s'";
    protected String valueEncodingFailed1$str() {
        return valueEncodingFailed1;
    }
    @Override
    public final CodecException valueEncodingFailed(final Exception e, final String codec) {
        final CodecException result = new CodecException(String.format(getLoggingLocale(), valueEncodingFailed1$str(), codec), e);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String valueDecodingFailed = "ISPN019011: Failure while decoding value using codec '%s'";
    protected String valueDecodingFailed$str() {
        return valueDecodingFailed;
    }
    @Override
    public final CodecException valueDecodingFailed(final Exception e, final String codec) {
        final CodecException result = new CodecException(String.format(getLoggingLocale(), valueDecodingFailed$str(), codec), e);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String noSuchCodec = "ISPN019012: No such codec named '%s'";
    protected String noSuchCodec$str() {
        return noSuchCodec;
    }
    @Override
    public final CodecException noSuchCodec(final String codec) {
        final CodecException result = new CodecException(String.format(getLoggingLocale(), noSuchCodec$str(), codec));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void loadingCodecFailed(final ServiceConfigurationError e) {
        super.log.logf(FQCN, WARN, e, loadingCodecFailed$str());
    }
    private static final String loadingCodecFailed = "ISPN019013: There was an error loading a codec";
    protected String loadingCodecFailed$str() {
        return loadingCodecFailed;
    }
    @Override
    public final void duplicateCodec(final String codec1, final String codec2) {
        super.log.logf(FQCN, ERROR, null, duplicateCodec$str(), codec1, codec2);
    }
    private static final String duplicateCodec = "ISPN019014: Codec '%s' attempts to override codec '%s'";
    protected String duplicateCodec$str() {
        return duplicateCodec;
    }
    private static final String invalidSession = "ISPN019015: Invalid session id '%s'";
    protected String invalidSession$str() {
        return invalidSession;
    }
    @Override
    public final IllegalArgumentException invalidSession(final String sessionId) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), invalidSession$str(), sessionId));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String nonExistentCache = "ISPN019016: No such cache: '%s'";
    protected String nonExistentCache$str() {
        return nonExistentCache;
    }
    @Override
    public final IllegalArgumentException nonExistentCache(final String cacheName) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), nonExistentCache$str(), cacheName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cacheAlreadyExists = "ISPN019017: A cache named '%s' already exists";
    protected String cacheAlreadyExists$str() {
        return cacheAlreadyExists;
    }
    @Override
    public final IllegalArgumentException cacheAlreadyExists(final String cacheName) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), cacheAlreadyExists$str(), cacheName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cannotCreateClusteredCaches = "ISPN019018: Could not create cache named '%s' on all cluster nodes";
    protected String cannotCreateClusteredCaches$str() {
        return cannotCreateClusteredCaches;
    }
    @Override
    public final CacheException cannotCreateClusteredCaches(final Throwable e, final String cacheName) {
        final CacheException result = new CacheException(String.format(getLoggingLocale(), cannotCreateClusteredCaches$str(), cacheName), e);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String statisticsNotEnabled = "ISPN019019: Statistics not enabled on cache '%s'";
    protected String statisticsNotEnabled$str() {
        return statisticsNotEnabled;
    }
    @Override
    public final StatementException statisticsNotEnabled(final String cacheName) {
        final StatementException result = new StatementException(String.format(getLoggingLocale(), statisticsNotEnabled$str(), cacheName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String noTransactionManager = "ISPN019020: Cannot retrieve a transaction manager";
    protected String noTransactionManager$str() {
        return noTransactionManager;
    }
    @Override
    public final StatementException noTransactionManager() {
        final StatementException result = new StatementException(String.format(getLoggingLocale(), noTransactionManager$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String noNestedTransactions = "ISPN019021: The TransactionManager does not support nested transactions";
    protected String noNestedTransactions$str() {
        return noNestedTransactions;
    }
    @Override
    public final StatementException noNestedTransactions() {
        final StatementException result = new StatementException(String.format(getLoggingLocale(), noNestedTransactions$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unexpectedTransactionError = "ISPN019022: Unexpected error while starting transaction";
    protected String unexpectedTransactionError$str() {
        return unexpectedTransactionError;
    }
    @Override
    public final StatementException unexpectedTransactionError(final SystemException e) {
        final StatementException result = new StatementException(String.format(getLoggingLocale(), unexpectedTransactionError$str()), e);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cannotCommitTransaction = "ISPN019023: Cannot commit transaction";
    protected String cannotCommitTransaction$str() {
        return cannotCommitTransaction;
    }
    @Override
    public final StatementException cannotCommitTransaction(final Exception e) {
        final StatementException result = new StatementException(String.format(getLoggingLocale(), cannotCommitTransaction$str()), e);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cacheNotDistributed = "ISPN019024: Cache is not distributed";
    protected String cacheNotDistributed$str() {
        return cacheNotDistributed;
    }
    @Override
    public final StatementException cacheNotDistributed() {
        final StatementException result = new StatementException(String.format(getLoggingLocale(), cacheNotDistributed$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cannotRollbackTransaction = "ISPN019025: Cannot rollback transaction";
    protected String cannotRollbackTransaction$str() {
        return cannotRollbackTransaction;
    }
    @Override
    public final StatementException cannotRollbackTransaction(final Exception e) {
        final StatementException result = new StatementException(String.format(getLoggingLocale(), cannotRollbackTransaction$str()), e);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String dataSynchronizationError = "ISPN019026: An error occurred while synchronizing data for cache '%s' using migrator '%s' from the source server";
    protected String dataSynchronizationError$str() {
        return dataSynchronizationError;
    }
    @Override
    public final StatementException dataSynchronizationError(final Exception e, final String name, final String migratorName) {
        final StatementException result = new StatementException(String.format(getLoggingLocale(), dataSynchronizationError$str(), name, migratorName), e);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String sourceDisconnectionError = "ISPN019027: An error occurred while disconnecting the source server for cache '%s' using migrator '%s'";
    protected String sourceDisconnectionError$str() {
        return sourceDisconnectionError;
    }
    @Override
    public final StatementException sourceDisconnectionError(final Exception e, final String name, final String migratorName) {
        final StatementException result = new StatementException(String.format(getLoggingLocale(), sourceDisconnectionError$str(), name, migratorName), e);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String siteNameNotSpecified = "ISPN019028: A site name needs to be specified";
    protected String siteNameNotSpecified$str() {
        return siteNameNotSpecified;
    }
    @Override
    public final StatementException siteNameNotSpecified() {
        final StatementException result = new StatementException(String.format(getLoggingLocale(), siteNameNotSpecified$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String noCacheSelectedYet = "ISPN019029: No cache selected yet";
    protected String noCacheSelectedYet$str() {
        return noCacheSelectedYet;
    }
    @Override
    public final StatementException noCacheSelectedYet() {
        final StatementException result = new StatementException(String.format(getLoggingLocale(), noCacheSelectedYet$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String valueEncodingFailed2 = "ISPN019030: Failure while encoding value of type '%s' using codec '%s'";
    protected String valueEncodingFailed2$str() {
        return valueEncodingFailed2;
    }
    @Override
    public final CodecException valueEncodingFailed(final String type, final String codec) {
        final CodecException result = new CodecException(String.format(getLoggingLocale(), valueEncodingFailed2$str(), type, codec));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String authorizationNotEnabledOnContainer = "ISPN019031: The container does not have authorization enabled";
    protected String authorizationNotEnabledOnContainer$str() {
        return authorizationNotEnabledOnContainer;
    }
    @Override
    public final StatementException authorizationNotEnabledOnContainer() {
        final StatementException result = new StatementException(String.format(getLoggingLocale(), authorizationNotEnabledOnContainer$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String noClusterPrincipalMapper = "ISPN019032: The %s statement requires the ClusterPrincipalMapper";
    protected String noClusterPrincipalMapper$str() {
        return noClusterPrincipalMapper;
    }
    @Override
    public final StatementException noClusterPrincipalMapper(final String stmt) {
        final StatementException result = new StatementException(String.format(getLoggingLocale(), noClusterPrincipalMapper$str(), stmt));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String noBackupsForCache = "ISPN019033: The cache '%s' has no backups configured.";
    protected String noBackupsForCache$str() {
        return noBackupsForCache;
    }
    @Override
    public final StatementException noBackupsForCache(final String cacheName) {
        final StatementException result = new StatementException(String.format(getLoggingLocale(), noBackupsForCache$str(), cacheName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String whiteListNotFound = "ISPN019034: Cannot create marshaller, white list not found";
    protected String whiteListNotFound$str() {
        return whiteListNotFound;
    }
    @Override
    public final IllegalStateException whiteListNotFound() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), whiteListNotFound$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
}
