/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.cli.interpreter;

import java.util.Properties;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.infinispan.cli.interpreter.Interpreter;
import org.infinispan.cli.interpreter.logging.Log;
import org.infinispan.commons.jmx.JmxUtil;
import org.infinispan.commons.jmx.MBeanServerLookup;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.configuration.global.GlobalJmxStatisticsConfiguration;
import org.infinispan.factories.GlobalComponentRegistry;
import org.infinispan.factories.annotations.InfinispanModule;
import org.infinispan.jmx.CacheManagerJmxRegistration;
import org.infinispan.jmx.ComponentsJmxRegistration;
import org.infinispan.lifecycle.ModuleLifecycle;
import org.infinispan.util.logging.LogFactory;

@InfinispanModule(name="cli-interpreter", requiredModules={"core"})
public class LifecycleCallbacks
implements ModuleLifecycle {
    private static final Log log = (Log)LogFactory.getLog(LifecycleCallbacks.class, Log.class);
    private ObjectName interpreterObjName;

    public void cacheManagerStarted(GlobalComponentRegistry gcr) {
        GlobalConfiguration globalConfig = gcr.getGlobalConfiguration();
        GlobalJmxStatisticsConfiguration jmxConfig = globalConfig.globalJmxStatistics();
        if (jmxConfig.enabled()) {
            String groupName = this.getGroupName(globalConfig.cacheManagerName());
            Interpreter interpreter = new Interpreter();
            gcr.registerComponent((Object)interpreter, Interpreter.class);
            try {
                CacheManagerJmxRegistration jmxRegistration = (CacheManagerJmxRegistration)gcr.getComponent(CacheManagerJmxRegistration.class);
                jmxRegistration.registerExternalMBean((Object)interpreter, jmxConfig.domain(), groupName, "Interpreter");
            }
            catch (Exception e) {
                this.interpreterObjName = null;
                log.jmxRegistrationFailed();
            }
        }
    }

    private String getGroupName(String name) {
        return "type=CacheManager," + ComponentsJmxRegistration.NAME_KEY + "=" + ObjectName.quote(name);
    }

    public void cacheManagerStopping(GlobalComponentRegistry gcr) {
        if (this.interpreterObjName != null) {
            GlobalJmxStatisticsConfiguration jmxConfig = gcr.getGlobalConfiguration().globalJmxStatistics();
            MBeanServer mbeanServer = JmxUtil.lookupMBeanServer((MBeanServerLookup)jmxConfig.mbeanServerLookup(), (Properties)jmxConfig.properties());
            try {
                JmxUtil.unregisterMBean((ObjectName)this.interpreterObjName, (MBeanServer)mbeanServer);
            }
            catch (Exception e) {
                log.jmxUnregistrationFailed();
            }
        }
    }
}

