/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.cli.interpreter.codec;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.ServiceConfigurationError;
import org.infinispan.cli.interpreter.codec.Codec;
import org.infinispan.cli.interpreter.logging.Log;
import org.infinispan.commons.configuration.ClassWhiteList;
import org.infinispan.commons.util.ServiceFinder;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.util.logging.LogFactory;

public class CodecRegistry {
    public static final Log log = (Log)LogFactory.getLog(CodecRegistry.class, Log.class);
    private Map<String, Codec> codecs;

    public CodecRegistry(EmbeddedCacheManager cacheManager) {
        GlobalConfiguration globalConfiguration = cacheManager.getCacheManagerConfiguration();
        ClassLoader cl = globalConfiguration.classLoader();
        ClassWhiteList classWhiteList = cacheManager.getClassWhiteList();
        this.codecs = new HashMap<String, Codec>();
        Iterator it = ServiceFinder.load(Codec.class, (ClassLoader[])new ClassLoader[]{cl}).iterator();
        while (true) {
            try {
                while (true) {
                    Codec codec = (Codec)it.next();
                    codec.setWhiteList(classWhiteList);
                    String name = codec.getName();
                    if (this.codecs.containsKey(name)) {
                        log.duplicateCodec(codec.getClass().getName(), this.codecs.get(name).getClass().getName());
                        continue;
                    }
                    this.codecs.put(name, codec);
                }
            }
            catch (ServiceConfigurationError e) {
                log.loadingCodecFailed(e);
                continue;
            }
            catch (NoSuchElementException e) {
                return;
            }
            break;
        }
    }

    public Collection<Codec> getCodecs() {
        return this.codecs.values();
    }

    public Codec getCodec(String name) {
        return this.codecs.get(name);
    }
}

