/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.cli.interpreter;

import java.util.Map;
import javax.security.auth.Subject;
import org.infinispan.cli.interpreter.Interpreter;
import org.infinispan.cli.interpreter.result.ResultKeys;
import org.infinispan.commons.jmx.MBeanServerLookup;
import org.infinispan.commons.jmx.TestMBeanServerLookup;
import org.infinispan.configuration.cache.AuthorizationConfigurationBuilder;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.global.GlobalAuthorizationConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.factories.GlobalComponentRegistry;
import org.infinispan.manager.CacheContainer;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.security.AuthorizationPermission;
import org.infinispan.security.PrincipalRoleMapper;
import org.infinispan.security.Security;
import org.infinispan.security.impl.ClusterRoleMapper;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="cli.interpreter.GrantDenyTest")
public class GrantDenyTest
extends SingleCacheManagerTest {
    static final Subject ADMIN = TestingUtil.makeSubject((String[])new String[]{"admin"});
    private MBeanServerLookup mBeanServerLookup = TestMBeanServerLookup.create();
    private ClusterRoleMapper cpm;

    protected EmbeddedCacheManager createCacheManager() {
        GlobalConfigurationBuilder global = new GlobalConfigurationBuilder();
        TestCacheManagerFactory.configureGlobalJmx((GlobalConfigurationBuilder)global, (String)((Object)((Object)this)).getClass().getSimpleName(), (MBeanServerLookup)this.mBeanServerLookup);
        GlobalAuthorizationConfigurationBuilder globalRoles = global.security().authorization().enable().principalRoleMapper((PrincipalRoleMapper)new ClusterRoleMapper());
        ConfigurationBuilder config = TestCacheManagerFactory.getDefaultCacheConfiguration((boolean)true);
        AuthorizationConfigurationBuilder authConfig = config.security().authorization().enable();
        globalRoles.role("reader").permission(AuthorizationPermission.ALL_READ).role("writer").permission(AuthorizationPermission.ALL_WRITE).role("admin").permission(AuthorizationPermission.ALL);
        authConfig.role("reader").role("writer").role("admin").jmxStatistics().enable();
        return TestCacheManagerFactory.createCacheManager((GlobalConfigurationBuilder)global, (ConfigurationBuilder)config);
    }

    protected void setup() throws Exception {
        this.cpm = (ClusterRoleMapper)Security.doAs((Subject)ADMIN, () -> {
            this.cacheManager = this.createCacheManager();
            this.cpm = (ClusterRoleMapper)this.cacheManager.getCacheManagerConfiguration().security().authorization().principalRoleMapper();
            this.cpm.grant("admin", "admin");
            this.cache = this.cacheManager.getCache();
            return this.cpm;
        });
    }

    protected void teardown() {
        Security.doAs((Subject)ADMIN, () -> {
            GrantDenyTest.super.teardown();
            return null;
        });
    }

    protected void clearContent() {
        Security.doAs((Subject)ADMIN, () -> {
            this.cacheManager.getCache().clear();
            return null;
        });
    }

    private Interpreter getInterpreter() {
        GlobalComponentRegistry gcr = TestingUtil.extractGlobalComponentRegistry((CacheContainer)this.cacheManager);
        return (Interpreter)gcr.getComponent(Interpreter.class);
    }

    private Map<String, String> execute(Interpreter interpreter, String sessionId, String commands) throws Exception {
        Map result = interpreter.execute(sessionId, commands);
        if (result.containsKey(ResultKeys.ERROR.toString())) {
            AssertJUnit.fail((String)String.format("%s\n%s", result.get(ResultKeys.ERROR.toString()), result.get(ResultKeys.STACKTRACE.toString())));
        }
        return result;
    }

    public void testGrantDeny() throws Exception {
        Interpreter interpreter = this.getInterpreter();
        String sessionId = interpreter.createSessionId((String)TestingUtil.extractGlobalConfiguration((EmbeddedCacheManager)this.cacheManager).defaultCacheName().get());
        this.execute(interpreter, sessionId, "grant reader to jack;");
        AssertJUnit.assertTrue((boolean)this.cpm.list("jack").contains("reader"));
        this.execute(interpreter, sessionId, "grant reader to jill;");
        AssertJUnit.assertTrue((boolean)this.cpm.list("jill").contains("reader"));
        this.execute(interpreter, sessionId, "deny reader to jack;");
        AssertJUnit.assertFalse((boolean)this.cpm.list("jack").contains("reader"));
        Map<String, String> response = this.execute(interpreter, sessionId, "roles jill;");
        AssertJUnit.assertEquals((String)"[reader]", (String)response.get(ResultKeys.OUTPUT.toString()));
    }
}

