/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.cli.interpreter.statement;

import java.util.List;
import org.infinispan.Cache;
import org.infinispan.cli.interpreter.codec.Codec;
import org.infinispan.cli.interpreter.result.EmptyResult;
import org.infinispan.cli.interpreter.result.Result;
import org.infinispan.cli.interpreter.result.StatementException;
import org.infinispan.cli.interpreter.session.Session;
import org.infinispan.cli.interpreter.statement.CodecAwareStatement;
import org.infinispan.cli.interpreter.statement.KeyData;
import org.infinispan.cli.interpreter.statement.Option;

public class RemoveStatement
extends CodecAwareStatement {
    final KeyData keyData;
    final Object value;

    public RemoveStatement(List<Option> options, KeyData key, Object value) {
        super(options);
        this.keyData = key;
        this.value = value;
    }

    @Override
    public Result execute(Session session) throws StatementException {
        Cache cache = session.getCache(this.keyData.getCacheName());
        Codec codec = this.getCodec(session);
        if (this.value == null) {
            cache.remove(codec.encodeKey(this.keyData.getKey()));
        } else {
            cache.remove(codec.encodeKey(this.keyData.getKey()), codec.encodeValue(this.value));
        }
        return EmptyResult.RESULT;
    }
}

