/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.cli.interpreter;

import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.infinispan.Cache;
import org.infinispan.cli.interpreter.Interpreter;
import org.infinispan.cli.interpreter.result.ResultKeys;
import org.infinispan.commons.jmx.MBeanServerLookup;
import org.infinispan.commons.jmx.TestMBeanServerLookup;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.context.Flag;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.statetransfer.CommitManager;
import org.infinispan.test.AbstractCacheTest;
import org.infinispan.test.CacheManagerCallable;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.xsite.AbstractTwoSitesTest;
import org.infinispan.xsite.statetransfer.XSiteStateProvider;
import org.infinispan.xsite.statetransfer.XSiteStateTransferManager;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"xsite"}, testName="cli.interpreter.SiteStatementTest")
public class SiteStatementTest
extends AbstractTwoSitesTest {
    private final MBeanServerLookup mBeanServerLookup = TestMBeanServerLookup.create();

    public SiteStatementTest() {
        this.implicitBackupCache = true;
    }

    protected GlobalConfigurationBuilder globalConfigurationBuilderForSite(String siteName) {
        GlobalConfigurationBuilder builder = super.globalConfigurationBuilderForSite(siteName);
        TestCacheManagerFactory.configureJmx((GlobalConfigurationBuilder)builder, (String)(((Object)((Object)this)).getClass().getSimpleName() + "-" + siteName), (MBeanServerLookup)this.mBeanServerLookup);
        return builder;
    }

    protected ConfigurationBuilder getNycActiveConfig() {
        return SiteStatementTest.getDefaultClusteredCacheConfig((CacheMode)CacheMode.DIST_SYNC, (boolean)true);
    }

    protected ConfigurationBuilder getLonActiveConfig() {
        return SiteStatementTest.getDefaultClusteredCacheConfig((CacheMode)CacheMode.DIST_SYNC, (boolean)true);
    }

    public void testSiteStatus() throws Exception {
        Interpreter lonInterpreter = this.interpreter("LON-1", 0);
        String lonCache = this.cache("LON-1", 0).getName();
        String lonSessionId = lonInterpreter.createSessionId(lonCache);
        Interpreter nycInterpreter = this.interpreter("NYC-2", 0);
        String nycCache = this.cache("NYC-2", 0).getName();
        String nycSessionId = nycInterpreter.createSessionId(nycCache);
        this.assertInterpreterOutput(lonInterpreter, lonSessionId, String.format("site --status \"%s\";", "NYC-2"), "online");
        this.assertInterpreterOutput(nycInterpreter, nycSessionId, String.format("site --status %s.%s;", lonCache, "LON-1"), "online");
        this.assertInterpreterOutput(lonInterpreter, lonSessionId, String.format("site --offline %s;", "NYC-2"), "ok");
        this.assertInterpreterOutput(lonInterpreter, lonSessionId, String.format("site --online %s;", "NYC-2"), "ok");
    }

    @Test(groups={"unstable"}, description="ISPN-8202")
    public void testSiteStateTransfer() throws Exception {
        Interpreter lonInterpreter = this.interpreter("LON-1", 0);
        String lonCache = this.cache("LON-1", 0).getName();
        String lonSessionId = lonInterpreter.createSessionId(lonCache);
        Interpreter nycInterpreter = this.interpreter("NYC-2", 0);
        String nycCache = this.cache("NYC-2", 0).getName();
        String nycSessionId = nycInterpreter.createSessionId(nycCache);
        this.assertInterpreterOutput(lonInterpreter, lonSessionId, String.format("site --offline %s;", "NYC-2"), "ok");
        this.assertInterpreterOutput(lonInterpreter, lonSessionId, String.format("site --status %s;", "NYC-2"), "offline");
        this.assertInterpreterOutput(lonInterpreter, lonSessionId, String.format("site --push %s;", "NYC-2"), "ok");
        this.assertEventuallyNoStateTransferInReceivingSite("NYC-2", nycCache, 10L, TimeUnit.SECONDS);
        this.assertEventuallyNoStateTransferInSendingSite("LON-1", lonCache, 10L, TimeUnit.SECONDS);
        this.assertInterpreterOutput(nycInterpreter, nycSessionId, "site --sendingsite;", "null");
        this.assertInterpreterOutput(lonInterpreter, lonSessionId, "site --pushstatus;", String.format("%s=OK", "NYC-2"));
        this.assertInterpreterOutput(lonInterpreter, lonSessionId, "site --clearpushstatus;", "ok");
        this.assertInterpreterOutput(lonInterpreter, lonSessionId, "site --pushstatus;", (String)null);
        this.assertInterpreterOutput(lonInterpreter, lonSessionId, String.format("site --cancelpush %s;", "NYC-2"), "ok");
        this.assertInterpreterOutput(nycInterpreter, nycSessionId, String.format("site --cancelreceive %s;", "LON-1"), "ok");
    }

    public void testSiteWithoutBackups() {
        String cacheName = "no-backups";
        GlobalConfigurationBuilder global = new GlobalConfigurationBuilder();
        TestCacheManagerFactory.configureJmx((GlobalConfigurationBuilder)global, (String)((Object)((Object)this)).getClass().getSimpleName(), (MBeanServerLookup)this.mBeanServerLookup);
        TestingUtil.withCacheManager((CacheManagerCallable)new CacheManagerCallable(TestCacheManagerFactory.createCacheManager((GlobalConfigurationBuilder)global, (ConfigurationBuilder)new ConfigurationBuilder())){

            public void call() {
                ConfigurationBuilder builder = AbstractCacheTest.getDefaultClusteredCacheConfig((CacheMode)CacheMode.LOCAL);
                builder.sites().disableBackups(true);
                this.cm.defineConfiguration("no-backups", builder.build());
                Cache cache = this.cm.getCache("no-backups");
                Interpreter interpreter = (Interpreter)TestingUtil.extractComponent((Cache)cache, Interpreter.class);
                String sessionId = interpreter.createSessionId("no-backups");
                try {
                    SiteStatementTest.this.assertInterpreterError(interpreter, sessionId, "site --status;", "ISPN019033: The cache 'no-backups' has no backups configured.");
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        });
    }

    public void testContainerOperations() throws Exception {
        Arrays.asList("LON-1", "NYC-2").forEach(s -> {
            this.site((String)s).cacheManagers().forEach(cacheManager -> cacheManager.defineConfiguration("another-cache", this.lonConfigurationBuilder().build()));
            this.site((String)s).cacheManagers().forEach(cacheManager -> cacheManager.defineConfiguration("another-cache-2", SiteStatementTest.getDefaultClusteredCacheConfig((CacheMode)CacheMode.DIST_SYNC).build()));
            this.site((String)s).waitForClusterToForm("another-cache");
            this.site((String)s).waitForClusterToForm("another-cache-2");
        });
        Interpreter lonInterpreter = this.interpreter("LON-1", 0);
        String lonCache = this.cache("LON-1", 0).getName();
        String lonSessionId = lonInterpreter.createSessionId(lonCache);
        String defaultCacheName = (String)((EmbeddedCacheManager)this.site(0).cacheManagers().get(0)).getCacheManagerConfiguration().defaultCacheName().get();
        this.assertInterpreterOutput(lonInterpreter, lonSessionId, String.format("site --offlineall %s;", "NYC-2"), (String output, String error) -> {
            AssertJUnit.assertEquals(null, (String)error);
            String outFormat = "%s: %s";
            if (!output.contains(String.format(outFormat, defaultCacheName, "ok"))) {
                AssertJUnit.fail((String)String.format("Cache '%s' should be present in the output: %s", defaultCacheName, output));
            }
            if (!output.contains(String.format(outFormat, "another-cache", "ok"))) {
                AssertJUnit.fail((String)String.format("Cache '%s' should be present in the output: %s", "another-cache", output));
            }
            if (output.contains("another-cache-2")) {
                AssertJUnit.fail((String)String.format("Cache '%s' should not be present in the output: %s", "another-cache-2", output));
            }
        });
        this.assertInterpreterOutput(lonInterpreter, lonSessionId, String.format("site --status %s;", "NYC-2"), "offline");
        this.assertInterpreterOutput(lonInterpreter, lonSessionId, String.format("site --status \"another-cache\".%s;", "NYC-2"), "offline");
        this.assertInterpreterOutput(lonInterpreter, lonSessionId, String.format("site --onlineall %s;", "NYC-2"), (String output, String error) -> {
            AssertJUnit.assertEquals(null, (String)error);
            String outFormat = "%s: %s";
            if (!output.contains(String.format(outFormat, defaultCacheName, "ok"))) {
                AssertJUnit.fail((String)String.format("Cache '%s' should be present in the output: %s", defaultCacheName, output));
            }
            if (!output.contains(String.format(outFormat, "another-cache", "ok"))) {
                AssertJUnit.fail((String)String.format("Cache '%s' should be present in the output: %s", "another-cache", output));
            }
            if (output.contains("another-cache-2")) {
                AssertJUnit.fail((String)String.format("Cache '%s' should not be present in the output: %s", "another-cache-2", output));
            }
        });
        this.assertInterpreterOutput(lonInterpreter, lonSessionId, String.format("site --status %s;", "NYC-2"), "online");
        this.assertInterpreterOutput(lonInterpreter, lonSessionId, String.format("site --status \"another-cache\".%s;", "NYC-2"), "online");
        this.assertInterpreterOutput(lonInterpreter, lonSessionId, String.format("site --pushall %s;", "NYC-2"), (String output, String error) -> {
            AssertJUnit.assertEquals(null, (String)error);
            String outFormat = "%s: %s";
            if (!output.contains(String.format(outFormat, defaultCacheName, "ok"))) {
                AssertJUnit.fail((String)String.format("Cache '%s' should be present in the output: %s", defaultCacheName, output));
            }
            if (!output.contains(String.format(outFormat, "another-cache", "ok"))) {
                AssertJUnit.fail((String)String.format("Cache '%s' should be present in the output: %s", "another-cache", output));
            }
            if (output.contains("another-cache-2")) {
                AssertJUnit.fail((String)String.format("Cache '%s' should not be present in the output: %s", "another-cache-2", output));
            }
        });
        this.assertInterpreterOutput(lonInterpreter, lonSessionId, String.format("site --cancelpushall %s;", "NYC-2"), (String output, String error) -> {
            AssertJUnit.assertEquals(null, (String)error);
            String outFormat = "%s: %s";
            if (!output.contains(String.format(outFormat, defaultCacheName, "ok"))) {
                AssertJUnit.fail((String)String.format("Cache '%s' should be present in the output: %s", defaultCacheName, output));
            }
            if (!output.contains(String.format(outFormat, "another-cache", "ok"))) {
                AssertJUnit.fail((String)String.format("Cache '%s' should be present in the output: %s", "another-cache", output));
            }
            if (output.contains("another-cache-2")) {
                AssertJUnit.fail((String)String.format("Cache '%s' should not be present in the output: %s", "another-cache-2", output));
            }
        });
    }

    private void assertInterpreterOutput(Interpreter interpreter, String sessionId, String command, String expected) throws Exception {
        this.assertInterpreterOutput(interpreter, sessionId, command, (String output, String error) -> {
            AssertJUnit.assertEquals(null, (String)error);
            AssertJUnit.assertEquals((String)expected, (String)output);
        });
    }

    private void assertInterpreterOutput(Interpreter interpreter, String sessionId, String command, OutputValidator validator) throws Exception {
        Objects.requireNonNull(validator);
        Map result = interpreter.execute(sessionId, command);
        validator.validate((String)result.get(ResultKeys.OUTPUT.toString()), (String)result.get(ResultKeys.ERROR.toString()));
    }

    private void assertInterpreterError(Interpreter interpreter, String sessionId, String command, String expected) throws Exception {
        this.assertInterpreterOutput(interpreter, sessionId, command, (String output, String error) -> {
            AssertJUnit.assertEquals(null, (String)output);
            AssertJUnit.assertEquals((String)expected, (String)error);
        });
    }

    private Interpreter interpreter(String site, int cache) {
        return (Interpreter)TestingUtil.extractComponent((Cache)this.cache(site, cache), Interpreter.class);
    }

    private void assertEventuallyNoStateTransferInReceivingSite(String siteName, String cacheName, long timeout, TimeUnit unit) {
        this.assertEventuallyInSite(siteName, cacheName, cache -> {
            CommitManager commitManager = (CommitManager)TestingUtil.extractComponent((Cache)cache, CommitManager.class);
            return !commitManager.isTracking(Flag.PUT_FOR_STATE_TRANSFER) && !commitManager.isTracking(Flag.PUT_FOR_X_SITE_STATE_TRANSFER) && commitManager.isEmpty();
        }, timeout, unit);
    }

    private void assertEventuallyNoStateTransferInSendingSite(String siteName, String cacheName, long timeout, TimeUnit unit) {
        this.assertEventuallyInSite(siteName, cacheName, cache -> ((XSiteStateProvider)TestingUtil.extractComponent((Cache)cache, XSiteStateProvider.class)).getCurrentStateSending().isEmpty() && ((XSiteStateTransferManager)TestingUtil.extractComponent((Cache)cache, XSiteStateTransferManager.class)).getRunningStateTransfers().isEmpty(), timeout, unit);
    }

    private static interface OutputValidator {
        public void validate(String var1, String var2);
    }
}

