/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.cli.interpreter;

import java.util.Map;
import org.infinispan.cli.interpreter.Interpreter;
import org.infinispan.cli.interpreter.result.ResultKeys;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.test.HotRodClientTestingUtil;
import org.infinispan.commons.jmx.MBeanServerLookup;
import org.infinispan.commons.jmx.TestMBeanServerLookup;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.factories.GlobalComponentRegistry;
import org.infinispan.manager.CacheContainer;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.server.hotrod.test.HotRodTestingUtil;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(testName="cli.interpreter.HotRodEncodingTest", groups={"functional"})
public class HotRodEncodingTest
extends SingleCacheManagerTest {
    private static final String REGULAR_CACHE = "default";
    private static final String OBJECT_CACHE = "object";
    private final MBeanServerLookup mBeanServerLookup = TestMBeanServerLookup.create();
    private HotRodServer hotrodServer;
    private int port;
    private Interpreter interpreter;
    private RemoteCacheManager remoteCacheManager;

    protected EmbeddedCacheManager createCacheManager() {
        org.infinispan.configuration.cache.ConfigurationBuilder c = HotRodTestingUtil.hotRodCacheConfiguration((org.infinispan.configuration.cache.ConfigurationBuilder)this.getDefaultStandaloneCacheConfig(false));
        c.statistics().enable();
        GlobalConfigurationBuilder global = new GlobalConfigurationBuilder().nonClusteredDefault();
        TestCacheManagerFactory.configureJmx((GlobalConfigurationBuilder)global, (String)((Object)((Object)this)).getClass().getSimpleName(), (MBeanServerLookup)this.mBeanServerLookup);
        EmbeddedCacheManager cacheManager = TestCacheManagerFactory.createCacheManager((GlobalConfigurationBuilder)global, (org.infinispan.configuration.cache.ConfigurationBuilder)c);
        org.infinispan.configuration.cache.ConfigurationBuilder objectStorageBuilder = new org.infinispan.configuration.cache.ConfigurationBuilder();
        objectStorageBuilder.encoding().key().mediaType("application/x-java-object").encoding().value().mediaType("application/x-java-object");
        org.infinispan.configuration.cache.ConfigurationBuilder defaultBuilder = new org.infinispan.configuration.cache.ConfigurationBuilder();
        cacheManager.defineConfiguration(OBJECT_CACHE, objectStorageBuilder.build());
        cacheManager.defineConfiguration(REGULAR_CACHE, defaultBuilder.build());
        return cacheManager;
    }

    protected void setup() throws Exception {
        super.setup();
        this.hotrodServer = HotRodClientTestingUtil.startHotRodServer((EmbeddedCacheManager)this.cacheManager);
        this.port = this.hotrodServer.getPort();
        this.remoteCacheManager = new RemoteCacheManager(new ConfigurationBuilder().addServer().host("localhost").port(this.port).build());
        this.remoteCacheManager.start();
        GlobalComponentRegistry gcr = TestingUtil.extractGlobalComponentRegistry((CacheContainer)this.cacheManager);
        this.interpreter = (Interpreter)gcr.getComponent(Interpreter.class);
    }

    protected void teardown() {
        HotRodClientTestingUtil.killRemoteCacheManager((RemoteCacheManager)this.remoteCacheManager);
        HotRodClientTestingUtil.killServers((HotRodServer[])new HotRodServer[]{this.hotrodServer});
        super.teardown();
    }

    public void testHotRodCodec() throws Exception {
        this.testHotRodCodecWithCache(REGULAR_CACHE);
    }

    public void testHotRodCodecWithObjects() throws Exception {
        this.testHotRodCodecWithCache(OBJECT_CACHE);
    }

    public void testHotRodEncoding() throws Exception {
        this.testHotRodEncodingWithCache(REGULAR_CACHE);
    }

    public void testHotRodEncodingWithObjects() throws Exception {
        this.testHotRodEncodingWithCache(OBJECT_CACHE);
    }

    private void testHotRodCodecWithCache(String cacheName) throws Exception {
        RemoteCache remoteCache = this.remoteCacheManager.getCache(cacheName);
        remoteCache.put((Object)"k1", (Object)"v1");
        String sessionId = this.interpreter.createSessionId(cacheName);
        Map response = this.interpreter.execute(sessionId, "get --codec=hotrod k1;");
        AssertJUnit.assertEquals((String)"v1", (String)((String)response.get(ResultKeys.OUTPUT.toString())));
        this.assertInterpreter(this.interpreter.execute(sessionId, "remove --codec=hotrod k1;"));
        String v1 = (String)remoteCache.get((Object)"k1");
        AssertJUnit.assertNull((Object)v1);
        this.assertInterpreter(this.interpreter.execute(sessionId, "put --codec=hotrod k2 v2;"));
        String v2 = (String)remoteCache.get((Object)"k2");
        AssertJUnit.assertEquals((String)"v2", (String)v2);
        this.assertInterpreter(this.interpreter.execute(sessionId, "evict --codec=hotrod k2;"));
        v2 = (String)remoteCache.get((Object)"k2");
        AssertJUnit.assertNull((Object)v2);
    }

    private void testHotRodEncodingWithCache(String cacheName) throws Exception {
        RemoteCache remoteCache = this.remoteCacheManager.getCache(cacheName);
        remoteCache.put((Object)"k1", (Object)"v1");
        String sessionId = this.interpreter.createSessionId(cacheName);
        this.interpreter.execute(sessionId, "encoding hotrod;");
        Map response = this.interpreter.execute(sessionId, "get k1;");
        AssertJUnit.assertEquals((String)"v1", (String)((String)response.get(ResultKeys.OUTPUT.toString())));
        this.assertInterpreter(this.interpreter.execute(sessionId, "put k2 v2;"));
        String v2 = (String)remoteCache.get((Object)"k2");
        AssertJUnit.assertEquals((String)"v2", (String)v2);
    }

    private void assertInterpreter(Map<String, String> response) {
        AssertJUnit.assertNull((Object)response.get(ResultKeys.ERROR.toString()));
    }
}

