/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.cli.interpreter;

import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.infinispan.cli.interpreter.Interpreter;
import org.infinispan.cli.interpreter.result.ResultKeys;
import org.infinispan.commons.jmx.MBeanServerLookup;
import org.infinispan.commons.jmx.TestMBeanServerLookup;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.factories.GlobalComponentRegistry;
import org.infinispan.manager.CacheContainer;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.rest.RestServer;
import org.infinispan.rest.configuration.RestServerConfigurationBuilder;
import org.infinispan.server.core.configuration.ProtocolServerConfiguration;
import org.infinispan.server.core.test.ServerTestingUtil;
import org.infinispan.server.hotrod.test.HotRodTestingUtil;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterClass;
import org.testng.annotations.Test;

@Test(testName="cli.interpreter.RestEncodingTest", groups={"functional"})
public class RestEncodingTest
extends SingleCacheManagerTest {
    private static final String REGULAR_CACHE = "default";
    private static final String OBJ_CACHE = "object";
    private final MBeanServerLookup mBeanServerLookup = TestMBeanServerLookup.create();
    private CloseableHttpClient restClient = HttpClients.createMinimal();
    private RestServer restServer;
    private Interpreter interpreter;

    protected EmbeddedCacheManager createCacheManager() {
        ConfigurationBuilder c = HotRodTestingUtil.hotRodCacheConfiguration((ConfigurationBuilder)this.getDefaultStandaloneCacheConfig(false));
        GlobalConfigurationBuilder global = new GlobalConfigurationBuilder().nonClusteredDefault();
        TestCacheManagerFactory.configureJmx((GlobalConfigurationBuilder)global, (String)((Object)((Object)this)).getClass().getSimpleName(), (MBeanServerLookup)this.mBeanServerLookup);
        this.cacheManager = TestCacheManagerFactory.createCacheManager((GlobalConfigurationBuilder)global, (ConfigurationBuilder)c);
        ConfigurationBuilder cfgBuilder = new ConfigurationBuilder();
        cfgBuilder.encoding().key().mediaType("application/x-java-object").encoding().value().mediaType("application/x-java-object");
        ConfigurationBuilder defaultBuilder = new ConfigurationBuilder();
        this.cacheManager.defineConfiguration(OBJ_CACHE, cfgBuilder.build());
        this.cacheManager.defineConfiguration(REGULAR_CACHE, defaultBuilder.build());
        RestServerConfigurationBuilder builder = (RestServerConfigurationBuilder)new RestServerConfigurationBuilder().port(ServerTestingUtil.findFreePort());
        this.restServer = new RestServer();
        this.restServer.start((ProtocolServerConfiguration)builder.build(), this.cacheManager);
        GlobalComponentRegistry gcr = TestingUtil.extractGlobalComponentRegistry((CacheContainer)this.cacheManager);
        this.interpreter = (Interpreter)gcr.getComponent(Interpreter.class);
        return this.cacheManager;
    }

    public void testRestCodec() throws Exception {
        this.testRestCodecWithCache(REGULAR_CACHE);
    }

    public void testRestCodecWithObjects() throws Exception {
        this.testRestCodecWithCache(OBJ_CACHE);
    }

    public void testRestEncoding() throws Exception {
        this.testRestEncodingWithCache(REGULAR_CACHE);
    }

    public void testRestEncodingWithObjects() throws Exception {
        this.testRestEncodingWithCache(OBJ_CACHE);
    }

    private String getRestEndpoint(String cache, String key) {
        return String.format("http://localhost:%s/rest/v2/caches/%s/%s", this.restServer.getPort(), cache, key);
    }

    private void testRestCodecWithCache(String cacheName) throws Exception {
        this.writeViaRest(cacheName, "k1", "v1");
        String sessionId = this.interpreter.createSessionId(cacheName);
        Map response = this.interpreter.execute(sessionId, "get --codec=rest k1;");
        AssertJUnit.assertEquals((String)"v1", (String)((String)response.get(ResultKeys.OUTPUT.toString())));
        this.interpreter.execute(sessionId, "remove --codec=rest k1;");
        AssertJUnit.assertNull((Object)this.readViaRest(cacheName, "k1"));
        this.interpreter.execute(sessionId, "put --codec=rest k2 v2;");
        this.readViaRest(cacheName, "k2");
        AssertJUnit.assertEquals((String)"v2", (String)this.readViaRest(cacheName, "k2"));
        this.interpreter.execute(sessionId, "evict --codec=rest k2;");
        AssertJUnit.assertNull((Object)this.readViaRest(cacheName, "k2"));
    }

    private void testRestEncodingWithCache(String cacheName) throws Exception {
        this.writeViaRest(cacheName, "key", "value");
        String sessionId = this.interpreter.createSessionId(cacheName);
        this.interpreter.execute(sessionId, "encoding rest;");
        AssertJUnit.assertEquals((String)"value", (String)this.readViaRest(cacheName, "key"));
        AssertJUnit.assertEquals((String)"value", (String)this.readViaCLI(sessionId, "key"));
        this.writeViaCLI(sessionId, "key2", "value2");
        AssertJUnit.assertEquals((String)"value2", (String)this.readViaRest(cacheName, "key2"));
        AssertJUnit.assertEquals((String)"value2", (String)this.readViaCLI(sessionId, "key2"));
    }

    private String readViaRest(String cache, String key) throws Exception {
        HttpGet httpGet = new HttpGet(this.getRestEndpoint(cache, key));
        httpGet.addHeader("Accept", "text/plain");
        CloseableHttpResponse response = this.restClient.execute((HttpUriRequest)httpGet);
        int statusCode = response.getStatusLine().getStatusCode();
        if (statusCode == 404) {
            return null;
        }
        AssertJUnit.assertEquals((int)200, (int)statusCode);
        HttpEntity entity = response.getEntity();
        return EntityUtils.toString((HttpEntity)entity);
    }

    private void writeViaRest(String cache, String key, String value) throws Exception {
        HttpPost httpPost = new HttpPost(this.getRestEndpoint(cache, key));
        httpPost.setEntity((HttpEntity)new StringEntity(value));
        CloseableHttpResponse response = this.restClient.execute((HttpUriRequest)httpPost);
        AssertJUnit.assertEquals((int)204, (int)response.getStatusLine().getStatusCode());
        EntityUtils.consume((HttpEntity)response.getEntity());
    }

    private String readViaCLI(String sessionId, String key) throws Exception {
        Map response = this.interpreter.execute(sessionId, String.format("get %s;", key));
        AssertJUnit.assertNull(response.get(ResultKeys.ERROR.toString()));
        return (String)response.get(ResultKeys.OUTPUT.toString());
    }

    private void writeViaCLI(String sessionId, String key, String value) throws Exception {
        Map response = this.interpreter.execute(sessionId, String.format("put %s %s;", key, value));
        AssertJUnit.assertNull(response.get(ResultKeys.ERROR.toString()));
    }

    @AfterClass
    protected void teardown() {
        try {
            this.restClient.close();
            if (this.restServer != null) {
                this.restServer.stop();
            }
            TestingUtil.killCacheManagers((EmbeddedCacheManager[])new EmbeddedCacheManager[]{this.cacheManager});
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

