/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.cli.interpreter.session;

import java.util.Collection;
import javax.transaction.TransactionManager;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.cli.interpreter.codec.Codec;
import org.infinispan.cli.interpreter.codec.CodecException;
import org.infinispan.cli.interpreter.codec.CodecRegistry;
import org.infinispan.cli.interpreter.codec.NoneCodec;
import org.infinispan.cli.interpreter.logging.Log;
import org.infinispan.cli.interpreter.session.SecurityActions;
import org.infinispan.cli.interpreter.session.Session;
import org.infinispan.commands.CommandsFactory;
import org.infinispan.commands.CreateCacheCommand;
import org.infinispan.commands.ReplicableCommand;
import org.infinispan.commons.dataconversion.IdentityEncoder;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.commons.time.TimeService;
import org.infinispan.configuration.ConfigurationManager;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.remoting.rpc.RpcManager;
import org.infinispan.util.logging.LogFactory;

public class SessionImpl
implements Session {
    public static final Log log = (Log)LogFactory.getLog(SessionImpl.class, Log.class);
    private static final Codec NO_OP_CODEC = new NoneCodec();
    private final EmbeddedCacheManager cacheManager;
    private final CodecRegistry codecRegistry;
    private final String id;
    private final TimeService timeService;
    private ConfigurationManager configurationManager;
    private Cache<?, ?> cache = null;
    private String cacheName = null;
    private long timestamp;
    private Codec codec;

    public SessionImpl(CodecRegistry codecRegistry, EmbeddedCacheManager cacheManager, String id, TimeService timeService, ConfigurationManager configurationManager) {
        if (timeService == null) {
            throw new IllegalArgumentException("TimeService cannot be null");
        }
        this.codecRegistry = codecRegistry;
        this.cacheManager = cacheManager;
        this.timeService = timeService;
        this.configurationManager = configurationManager;
        this.id = id;
        this.timestamp = timeService.time();
        this.codec = this.codecRegistry.getCodec("none");
    }

    @Override
    public EmbeddedCacheManager getCacheManager() {
        return this.cacheManager;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public <K, V> Cache<K, V> getCurrentCache() {
        return this.cache;
    }

    @Override
    public String getCurrentCacheName() {
        return this.cacheName;
    }

    @Override
    public <K, V> Cache<K, V> getCache(String cacheName) {
        Cache c = cacheName != null ? this.cacheManager.getCache(cacheName, false) : this.getCurrentCache();
        if (c == null) {
            throw log.nonExistentCache(cacheName);
        }
        return c.getAdvancedCache().withEncoding(IdentityEncoder.class);
    }

    @Override
    public void setCurrentCache(String cacheName) {
        this.cache = this.getCache(cacheName);
        this.cacheName = cacheName;
    }

    @Override
    public void createCache(String cacheName, String baseCacheName) {
        Configuration configuration;
        if (baseCacheName != null) {
            configuration = this.configurationManager.getConfiguration(baseCacheName, true);
            if (configuration == null) {
                throw log.nonExistentCache(baseCacheName);
            }
        } else {
            configuration = this.cacheManager.getDefaultCacheConfiguration();
            baseCacheName = (String)this.cacheManager.getCacheManagerConfiguration().defaultCacheName().get();
        }
        if (this.cacheManager.cacheExists(cacheName)) {
            throw log.cacheAlreadyExists(cacheName);
        }
        if (configuration.clustering().cacheMode().isClustered()) {
            AdvancedCache clusteredCache = this.cacheManager.getCache(baseCacheName).getAdvancedCache();
            RpcManager rpc = clusteredCache.getRpcManager();
            ComponentRegistry componentRegistry = clusteredCache.getComponentRegistry();
            CommandsFactory factory = (CommandsFactory)componentRegistry.getComponent(CommandsFactory.class);
            CreateCacheCommand ccc = factory.buildCreateCacheCommand(cacheName, baseCacheName);
            try {
                rpc.invokeRemotely(null, (ReplicableCommand)ccc, rpc.getSyncRpcOptions());
                ccc.invokeAsync(componentRegistry);
            }
            catch (Throwable e) {
                throw log.cannotCreateClusteredCaches(e, cacheName);
            }
        } else {
            ConfigurationBuilder b = new ConfigurationBuilder();
            b.read(configuration);
            this.cacheManager.defineConfiguration(cacheName, b.build());
            this.cacheManager.getCache(cacheName);
        }
    }

    @Override
    public void reset() {
        if (this.configurationManager.getGlobalConfiguration().defaultCacheName().isPresent()) {
            this.resetCache((Cache<Object, Object>)this.cacheManager.getCache());
        }
        for (String cacheName : this.cacheManager.getCacheNames()) {
            this.resetCache((Cache<Object, Object>)this.cacheManager.getCache(cacheName));
        }
        this.timestamp = this.timeService.time();
    }

    private void resetCache(Cache<Object, Object> cache) {
        Configuration configuration = SecurityActions.getCacheConfiguration(cache.getAdvancedCache());
        if (configuration.invocationBatching().enabled()) {
            SecurityActions.endBatch(cache.getAdvancedCache());
        }
        TransactionManager tm = cache.getAdvancedCache().getTransactionManager();
        try {
            if (tm != null && tm.getTransaction() != null) {
                tm.rollback();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public long getTimestamp() {
        return this.timestamp;
    }

    @Override
    public void setCodec(String codec) throws CodecException {
        this.codec = this.getCodec(codec);
    }

    @Override
    public Collection<Codec> getCodecs() {
        return this.codecRegistry.getCodecs();
    }

    @Override
    public Codec getCodec() {
        if (this.isObjectStorage()) {
            return NO_OP_CODEC;
        }
        return this.codec;
    }

    boolean isObjectStorage() {
        MediaType storageMediaType = this.cache.getAdvancedCache().getValueDataConversion().getStorageMediaType();
        return MediaType.APPLICATION_OBJECT.match(storageMediaType);
    }

    @Override
    public Codec getCodec(String codec) throws CodecException {
        Codec c = this.codecRegistry.getCodec(codec);
        if (c == null) {
            throw log.noSuchCodec(codec);
        }
        if (this.isObjectStorage()) {
            return NO_OP_CODEC;
        }
        return c;
    }
}

