/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.cli.interpreter.statement;

import java.util.List;
import org.infinispan.Cache;
import org.infinispan.cli.interpreter.codec.Codec;
import org.infinispan.cli.interpreter.logging.Log;
import org.infinispan.cli.interpreter.result.JsonResult;
import org.infinispan.cli.interpreter.result.Result;
import org.infinispan.cli.interpreter.result.StatementException;
import org.infinispan.cli.interpreter.result.StringResult;
import org.infinispan.cli.interpreter.session.Session;
import org.infinispan.cli.interpreter.statement.KeyData;
import org.infinispan.cli.interpreter.statement.Option;
import org.infinispan.cli.interpreter.statement.Statement;
import org.infinispan.util.logging.LogFactory;

public class GetStatement
implements Statement {
    private static final Log log = (Log)LogFactory.getLog(GetStatement.class, Log.class);
    final KeyData keyData;
    private final List<Option> options;

    public GetStatement(List<Option> options, KeyData key) {
        this.options = options;
        this.keyData = key;
    }

    @Override
    public Result execute(Session session) throws StatementException {
        Object value;
        Cache cache = session.getCache(this.keyData.getCacheName());
        Object key = this.keyData.key;
        Codec codec = session.getCodec();
        if (this.options.size() > 0) {
            for (Option option : this.options) {
                switch (option.toEnum(Options.class)) {
                    case CODEC: {
                        if (option.getParameter() == null) {
                            throw log.missingOptionParameter(option.getName());
                        }
                        codec = session.getCodec(option.getParameter());
                    }
                }
            }
        }
        if ((value = cache.get(codec.encodeKey(key))) == null) {
            return new StringResult("null");
        }
        Object decoded = codec.decodeValue(value);
        if (decoded instanceof String) {
            return new StringResult((String)decoded);
        }
        if (decoded.getClass().isPrimitive()) {
            return new StringResult(decoded.toString());
        }
        return new JsonResult(decoded);
    }

    private static enum Options {
        CODEC;

    }
}

