/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.cli.interpreter.statement;

import org.infinispan.Cache;
import org.infinispan.cli.interpreter.logging.Log;
import org.infinispan.cli.interpreter.result.EmptyResult;
import org.infinispan.cli.interpreter.result.Result;
import org.infinispan.cli.interpreter.result.StatementException;
import org.infinispan.cli.interpreter.result.StringResult;
import org.infinispan.cli.interpreter.session.Session;
import org.infinispan.cli.interpreter.statement.Statement;
import org.infinispan.util.logging.LogFactory;

public class CacheStatement
implements Statement {
    private static final Log log = (Log)LogFactory.getLog(CacheStatement.class, Log.class);
    final String cacheName;

    public CacheStatement(String cacheName) {
        this.cacheName = cacheName;
    }

    @Override
    public Result execute(Session session) throws StatementException {
        if (this.cacheName != null) {
            session.setCurrentCache(this.cacheName);
            return EmptyResult.RESULT;
        }
        Cache currentCache = session.getCurrentCache();
        if (currentCache != null) {
            return new StringResult(currentCache.getName());
        }
        throw log.noCacheSelectedYet();
    }
}

