/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.cli.interpreter;

import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.infinispan.Cache;
import org.infinispan.cli.interpreter.Interpreter;
import org.infinispan.cli.interpreter.result.ResultKeys;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.context.Flag;
import org.infinispan.manager.DefaultCacheManager;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.statetransfer.CommitManager;
import org.infinispan.test.AbstractCacheTest;
import org.infinispan.test.CacheManagerCallable;
import org.infinispan.test.TestingUtil;
import org.infinispan.xsite.AbstractTwoSitesTest;
import org.infinispan.xsite.AbstractXSiteTest;
import org.infinispan.xsite.statetransfer.XSiteStateProvider;
import org.infinispan.xsite.statetransfer.XSiteStateTransferManager;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"xsite"}, testName="cli-server.SiteStatementTest")
public class SiteStatementTest
extends AbstractTwoSitesTest {
    protected ConfigurationBuilder getNycActiveConfig() {
        return SiteStatementTest.getDefaultClusteredCacheConfig((CacheMode)CacheMode.DIST_SYNC, (boolean)true);
    }

    protected ConfigurationBuilder getLonActiveConfig() {
        return SiteStatementTest.getDefaultClusteredCacheConfig((CacheMode)CacheMode.DIST_SYNC, (boolean)true);
    }

    public void testSiteStatus() throws Exception {
        Interpreter lonInterpreter = this.interpreter("LON", 0);
        String lonCache = this.cache("LON", 0).getName();
        String lonSessionId = lonInterpreter.createSessionId(lonCache);
        Interpreter nycInterpreter = this.interpreter("NYC", 0);
        String nycCache = this.cache("NYC", 0).getName();
        String nycSessionId = nycInterpreter.createSessionId(nycCache);
        this.assertInterpreterOutput(lonInterpreter, lonSessionId, "site --status NYC;", "online");
        this.assertInterpreterOutput(nycInterpreter, nycSessionId, String.format("site --status %s.LON;", lonCache), "online");
        this.assertInterpreterOutput(lonInterpreter, lonSessionId, "site --offline NYC;", "ok");
        this.assertInterpreterOutput(lonInterpreter, lonSessionId, "site --online NYC;", "ok");
    }

    public void testSiteStateTransfer() throws Exception {
        Interpreter lonInterpreter = this.interpreter("LON", 0);
        String lonCache = this.cache("LON", 0).getName();
        String lonSessionId = lonInterpreter.createSessionId(lonCache);
        Interpreter nycInterpreter = this.interpreter("NYC", 0);
        String nycCache = this.cache("NYC", 0).getName();
        String nycSessionId = nycInterpreter.createSessionId(nycCache);
        this.assertInterpreterOutput(lonInterpreter, lonSessionId, "site --offline NYC;", "ok");
        this.assertInterpreterOutput(lonInterpreter, lonSessionId, "site --status NYC;", "offline");
        this.assertInterpreterOutput(lonInterpreter, lonSessionId, "site --push NYC;", "ok");
        this.assertEventuallyNoStateTransferInReceivingSite("NYC", nycCache, 10L, TimeUnit.SECONDS);
        this.assertEventuallyNoStateTransferInSendingSite("LON", lonCache, 10L, TimeUnit.SECONDS);
        this.assertInterpreterOutput(nycInterpreter, nycSessionId, "site --sendingsite;", "null");
        this.assertInterpreterOutput(lonInterpreter, lonSessionId, "site --pushstatus;", "NYC=OK");
        this.assertInterpreterOutput(lonInterpreter, lonSessionId, "site --clearpushstatus;", "ok");
        this.assertInterpreterOutput(lonInterpreter, lonSessionId, "site --pushstatus;", null);
        this.assertInterpreterOutput(lonInterpreter, lonSessionId, "site --cancelpush NYC;", "ok");
        this.assertInterpreterOutput(nycInterpreter, nycSessionId, "site --cancelreceive LON;", "ok");
    }

    public void testSiteWithoutBackups() throws Exception {
        String cacheName = "no-backups";
        TestingUtil.withCacheManager((CacheManagerCallable)new CacheManagerCallable((EmbeddedCacheManager)new DefaultCacheManager()){

            public void call() {
                ConfigurationBuilder builder = AbstractCacheTest.getDefaultClusteredCacheConfig((CacheMode)CacheMode.LOCAL);
                builder.sites().disableBackups(true);
                this.cm.defineConfiguration("no-backups", builder.build());
                Cache cache = this.cm.getCache("no-backups");
                Interpreter interpreter = (Interpreter)cache.getAdvancedCache().getComponentRegistry().getComponent(Interpreter.class);
                String sessionId = interpreter.createSessionId("no-backups");
                try {
                    SiteStatementTest.this.assertInterpreterError(interpreter, sessionId, "site --status;", "ISPN019033: The cache 'no-backups' has no backups configured.");
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        });
    }

    private void assertInterpreterOutput(Interpreter interpreter, String sessionId, String command, String output) throws Exception {
        Map result = interpreter.execute(sessionId, command);
        AssertJUnit.assertEquals((String)output, (String)((String)result.get(ResultKeys.OUTPUT.toString())));
    }

    private void assertInterpreterError(Interpreter interpreter, String sessionId, String command, String output) throws Exception {
        Map result = interpreter.execute(sessionId, command);
        AssertJUnit.assertEquals((String)output, (String)((String)result.get(ResultKeys.ERROR.toString())));
    }

    private Interpreter interpreter(String site, int cache) {
        return (Interpreter)this.cache(site, cache).getAdvancedCache().getComponentRegistry().getComponent(Interpreter.class);
    }

    private void assertEventuallyNoStateTransferInReceivingSite(String siteName, String cacheName, long timeout, TimeUnit unit) {
        this.assertEventuallyInSite(siteName, cacheName, (AbstractXSiteTest.EventuallyAssertCondition)new AbstractXSiteTest.EventuallyAssertCondition<Object, Object>(){

            public boolean assertInCache(Cache<Object, Object> cache) {
                CommitManager commitManager = (CommitManager)TestingUtil.extractComponent(cache, CommitManager.class);
                return !commitManager.isTracking(Flag.PUT_FOR_STATE_TRANSFER) && !commitManager.isTracking(Flag.PUT_FOR_X_SITE_STATE_TRANSFER) && commitManager.isEmpty();
            }
        }, timeout, unit);
    }

    private void assertEventuallyNoStateTransferInSendingSite(String siteName, String cacheName, long timeout, TimeUnit unit) {
        this.assertEventuallyInSite(siteName, cacheName, (AbstractXSiteTest.EventuallyAssertCondition)new AbstractXSiteTest.EventuallyAssertCondition<Object, Object>(){

            public boolean assertInCache(Cache<Object, Object> cache) {
                return ((XSiteStateProvider)TestingUtil.extractComponent(cache, XSiteStateProvider.class)).getCurrentStateSending().isEmpty() && ((XSiteStateTransferManager)TestingUtil.extractComponent(cache, XSiteStateTransferManager.class)).getRunningStateTransfers().isEmpty();
            }
        }, timeout, unit);
    }
}

