/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.cli.interpreter.codec;

import org.infinispan.cli.interpreter.codec.AbstractCodec;
import org.infinispan.cli.interpreter.codec.CodecException;
import org.infinispan.cli.interpreter.logging.Log;
import org.infinispan.remoting.MIMECacheEntry;
import org.infinispan.util.logging.LogFactory;

public class RestCodec
extends AbstractCodec {
    public static final Log log = (Log)LogFactory.getLog(RestCodec.class, Log.class);

    @Override
    public String getName() {
        return "rest";
    }

    @Override
    public Object encodeKey(Object key) throws CodecException {
        return key;
    }

    @Override
    public Object encodeValue(Object value) throws CodecException {
        if (value != null) {
            if (value instanceof MIMECacheEntry) {
                return value;
            }
            if (value instanceof String) {
                return new MIMECacheEntry("text/plain", ((String)value).getBytes());
            }
            if (value instanceof byte[]) {
                return new MIMECacheEntry("application/binary", (byte[])value);
            }
            throw log.valueEncodingFailed(value.getClass().getName(), this.getName());
        }
        return null;
    }

    @Override
    public Object decodeKey(Object key) throws CodecException {
        return key;
    }

    @Override
    public Object decodeValue(Object value) throws CodecException {
        if (value != null) {
            MIMECacheEntry e = (MIMECacheEntry)value;
            if (e.contentType.startsWith("text/") || e.contentType.equals("application/xml") || e.contentType.equals("application/json")) {
                return new String(e.data);
            }
            return e.data;
        }
        return null;
    }
}

