/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.cli.interpreter;

import net.spy.memcached.MemcachedClient;
import org.infinispan.cli.interpreter.Interpreter;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.factories.GlobalComponentRegistry;
import org.infinispan.manager.CacheContainer;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.server.memcached.MemcachedServer;
import org.infinispan.server.memcached.test.MemcachedTestingUtil;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.CleanupAfterMethod;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.Test;

@Test(testName="cli-server.MemcachedEncodingTest", groups={"unstable"}, description="original group: functional")
@CleanupAfterMethod
public class MemcachedEncodingTest
extends SingleCacheManagerTest {
    private static final String MEMCACHED_CACHE = "memcachedCache";
    MemcachedServer memcachedServer;
    int port;
    Interpreter interpreter;
    MemcachedClient memcachedClient;

    protected EmbeddedCacheManager createCacheManager() throws Exception {
        ConfigurationBuilder c = this.getDefaultStandaloneCacheConfig(false);
        c.jmxStatistics().enable();
        this.cacheManager = TestCacheManagerFactory.createCacheManager((ConfigurationBuilder)c);
        this.memcachedServer = MemcachedTestingUtil.startMemcachedTextServer((EmbeddedCacheManager)this.cacheManager);
        this.port = this.memcachedServer.getPort();
        this.memcachedClient = MemcachedTestingUtil.createMemcachedClient((long)60000L, (int)this.port);
        GlobalComponentRegistry gcr = TestingUtil.extractGlobalComponentRegistry((CacheContainer)this.cacheManager);
        this.interpreter = (Interpreter)gcr.getComponent(Interpreter.class);
        return this.cacheManager;
    }

    @AfterMethod
    public void release() {
        MemcachedTestingUtil.killMemcachedServer((MemcachedServer)this.memcachedServer);
        TestingUtil.killCacheManagers((EmbeddedCacheManager[])new EmbeddedCacheManager[]{this.cacheManager});
        MemcachedTestingUtil.killMemcachedClient((MemcachedClient)this.memcachedClient);
    }
}

