/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.cli.interpreter;

import org.infinispan.cli.interpreter.Interpreter;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.factories.GlobalComponentRegistry;
import org.infinispan.manager.CacheContainer;
import org.infinispan.test.AbstractCacheTest;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestingUtil;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="cli.interpreter.ClusteredCLITest")
public class ClusteredCLITest
extends MultipleCacheManagersTest {
    public static String CACHE_NAME = "distCache";

    public ClusteredCLITest() {
        this.cleanup = AbstractCacheTest.CleanupPhase.AFTER_TEST;
    }

    protected void createCacheManagers() throws Throwable {
        ConfigurationBuilder builder = ClusteredCLITest.getDefaultClusteredCacheConfig((CacheMode)this.getCacheMode(), (boolean)true);
        this.createClusteredCaches(2, this.cacheName(), builder);
    }

    protected String cacheName() {
        return CACHE_NAME;
    }

    protected CacheMode getCacheMode() {
        return CacheMode.DIST_SYNC;
    }

    public void testCreateCluster() throws Exception {
        GlobalComponentRegistry gcr = TestingUtil.extractGlobalComponentRegistry((CacheContainer)this.manager(0));
        Interpreter interpreter = (Interpreter)gcr.getComponent(Interpreter.class);
        String sessionId = interpreter.createSessionId(null);
        interpreter.execute(sessionId, String.format("create anothercache like %s;", this.cacheName()));
        assert (this.manager(0).cacheExists("anothercache"));
        assert (this.manager(1).cacheExists("anothercache"));
    }
}

