// $ANTLR 3.4 org/infinispan/cli/interpreter/IspnCliQL.g 2015-11-09 18:27:01

package org.infinispan.cli.interpreter;

import java.io.IOException;
import java.util.Map;
import java.util.HashMap;
import java.util.Collections;
import java.util.List;
import java.util.ArrayList;
import java.util.UUID;
import java.util.concurrent.TimeUnit;

import org.codehaus.jackson.JsonProcessingException;
import org.codehaus.jackson.annotate.JsonTypeInfo;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.ObjectMapper.DefaultTyping;

import org.infinispan.cli.interpreter.session.*;
import org.infinispan.cli.interpreter.statement.*;
import static org.infinispan.cli.interpreter.utils.ParserSupport.*;



import org.antlr.runtime.*;
import java.util.Stack;
import java.util.List;
import java.util.ArrayList;

import org.antlr.runtime.tree.*;


@SuppressWarnings({"all", "warnings", "unchecked"})
public class IspnCliQLParser extends Parser {
    public static final String[] tokenNames = new String[] {
        "<invalid>", "<EOR>", "<DOWN>", "<UP>", "ABORT", "AlphaChar", "AlphaNumChar", "BEGIN", "CACHE", "CLEARCACHE", "COMMIT", "CREATE", "CharacterEscapeSequence", "Comment", "DENY", "DOUBLELITERAL", "DecimalDigit", "DoubleQuotedStringCharacter", "DoubleSuffix", "ENCODING", "END", "EOL", "EVICT", "EXPIRES", "EscapeCharacter", "EscapeSequence", "Exponent", "FALSE", "FLOATLITERAL", "FloatSuffix", "GET", "GRANT", "HexDigit", "HexEscapeSequence", "HexPrefix", "INFO", "INTLITERAL", "IntegerNumber", "LIKE", "LOCATE", "LONGLITERAL", "LineComment", "LongSuffix", "MAXIDLE", "NULL", "NonEscapeCharacter", "NonIntegerNumber", "PING", "PUT", "REMOVE", "REPLACE", "ROLES", "ROLLBACK", "SITE", "START", "STATS", "STRINGLITERAL", "SingleEscapeCharacter", "SingleQuotedStringCharacter", "TIMELITERAL", "TO", "TRUE", "TimeSuffix", "UPGRADE", "UUIDLITERAL", "UnicodeEscapeSequence", "UnquotedStringCharacter", "UnquotedStringStart", "VERSION", "WhiteSpace", "','", "'--'", "'.'", "':'", "';'", "'='", "'['", "']'", "'{'", "'}'"
    };

    public static final int EOF=-1;
    public static final int T__70=70;
    public static final int T__71=71;
    public static final int T__72=72;
    public static final int T__73=73;
    public static final int T__74=74;
    public static final int T__75=75;
    public static final int T__76=76;
    public static final int T__77=77;
    public static final int T__78=78;
    public static final int T__79=79;
    public static final int ABORT=4;
    public static final int AlphaChar=5;
    public static final int AlphaNumChar=6;
    public static final int BEGIN=7;
    public static final int CACHE=8;
    public static final int CLEARCACHE=9;
    public static final int COMMIT=10;
    public static final int CREATE=11;
    public static final int CharacterEscapeSequence=12;
    public static final int Comment=13;
    public static final int DENY=14;
    public static final int DOUBLELITERAL=15;
    public static final int DecimalDigit=16;
    public static final int DoubleQuotedStringCharacter=17;
    public static final int DoubleSuffix=18;
    public static final int ENCODING=19;
    public static final int END=20;
    public static final int EOL=21;
    public static final int EVICT=22;
    public static final int EXPIRES=23;
    public static final int EscapeCharacter=24;
    public static final int EscapeSequence=25;
    public static final int Exponent=26;
    public static final int FALSE=27;
    public static final int FLOATLITERAL=28;
    public static final int FloatSuffix=29;
    public static final int GET=30;
    public static final int GRANT=31;
    public static final int HexDigit=32;
    public static final int HexEscapeSequence=33;
    public static final int HexPrefix=34;
    public static final int INFO=35;
    public static final int INTLITERAL=36;
    public static final int IntegerNumber=37;
    public static final int LIKE=38;
    public static final int LOCATE=39;
    public static final int LONGLITERAL=40;
    public static final int LineComment=41;
    public static final int LongSuffix=42;
    public static final int MAXIDLE=43;
    public static final int NULL=44;
    public static final int NonEscapeCharacter=45;
    public static final int NonIntegerNumber=46;
    public static final int PING=47;
    public static final int PUT=48;
    public static final int REMOVE=49;
    public static final int REPLACE=50;
    public static final int ROLES=51;
    public static final int ROLLBACK=52;
    public static final int SITE=53;
    public static final int START=54;
    public static final int STATS=55;
    public static final int STRINGLITERAL=56;
    public static final int SingleEscapeCharacter=57;
    public static final int SingleQuotedStringCharacter=58;
    public static final int TIMELITERAL=59;
    public static final int TO=60;
    public static final int TRUE=61;
    public static final int TimeSuffix=62;
    public static final int UPGRADE=63;
    public static final int UUIDLITERAL=64;
    public static final int UnicodeEscapeSequence=65;
    public static final int UnquotedStringCharacter=66;
    public static final int UnquotedStringStart=67;
    public static final int VERSION=68;
    public static final int WhiteSpace=69;

    // delegates
    public Parser[] getDelegates() {
        return new Parser[] {};
    }

    // delegators


    public IspnCliQLParser(TokenStream input) {
        this(input, new RecognizerSharedState());
    }
    public IspnCliQLParser(TokenStream input, RecognizerSharedState state) {
        super(input, state);
    }

protected TreeAdaptor adaptor = new CommonTreeAdaptor();

public void setTreeAdaptor(TreeAdaptor adaptor) {
    this.adaptor = adaptor;
}
public TreeAdaptor getTreeAdaptor() {
    return adaptor;
}
    public String[] getTokenNames() { return IspnCliQLParser.tokenNames; }
    public String getGrammarFileName() { return "org/infinispan/cli/interpreter/IspnCliQL.g"; }


       private List<String> parserErrors = new ArrayList<String>();
       protected List<Statement> statements = new ArrayList<Statement>();
       private ObjectMapper jsonMapper = new ObjectMapper().enableDefaultTyping(DefaultTyping.NON_FINAL, JsonTypeInfo.As.WRAPPER_OBJECT);

       public void displayRecognitionError(String[] tokenNames, RecognitionException e) {
         parserErrors.add(getErrorHeader(e) + " " + getErrorMessage(e, tokenNames));
       }

       public List<String> getParserErrors() {
         return parserErrors;
       }

       public boolean hasParserErrors() {
         return parserErrors.size() > 0;
       }


    public static class statements_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "statements"
    // org/infinispan/cli/interpreter/IspnCliQL.g:56:1: statements : ( statement ( EOL )* )* EOF ;
    public final IspnCliQLParser.statements_return statements() throws RecognitionException {
        IspnCliQLParser.statements_return retval = new IspnCliQLParser.statements_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token EOL2=null;
        Token EOF3=null;
        IspnCliQLParser.statement_return statement1 =null;


        Object EOL2_tree=null;
        Object EOF3_tree=null;

        try {
            // org/infinispan/cli/interpreter/IspnCliQL.g:57:4: ( ( statement ( EOL )* )* EOF )
            // org/infinispan/cli/interpreter/IspnCliQL.g:57:6: ( statement ( EOL )* )* EOF
            {
            // org/infinispan/cli/interpreter/IspnCliQL.g:57:6: ( statement ( EOL )* )*
            loop2:
            do {
                int alt2=2;
                switch ( input.LA(1) ) {
                case ABORT:
                case BEGIN:
                case CACHE:
                case CLEARCACHE:
                case COMMIT:
                case CREATE:
                case DENY:
                case ENCODING:
                case END:
                case EVICT:
                case GET:
                case GRANT:
                case INFO:
                case LOCATE:
                case PING:
                case PUT:
                case REMOVE:
                case REPLACE:
                case ROLES:
                case ROLLBACK:
                case SITE:
                case START:
                case STATS:
                case UPGRADE:
                case VERSION:
                    {
                    alt2=1;
                    }
                    break;

                }

                switch (alt2) {
            	case 1 :
            	    // org/infinispan/cli/interpreter/IspnCliQL.g:57:7: statement ( EOL )*
            	    {
            	    pushFollow(FOLLOW_statement_in_statements70);
            	    statement1=statement();

            	    state._fsp--;

            	    adaptor.addChild(root_0, statement1.getTree());

            	     statements.add((statement1!=null?statement1.stmt:null)); 

            	    // org/infinispan/cli/interpreter/IspnCliQL.g:57:54: ( EOL )*
            	    loop1:
            	    do {
            	        int alt1=2;
            	        switch ( input.LA(1) ) {
            	        case EOL:
            	            {
            	            alt1=1;
            	            }
            	            break;

            	        }

            	        switch (alt1) {
            	    	case 1 :
            	    	    // org/infinispan/cli/interpreter/IspnCliQL.g:57:54: EOL
            	    	    {
            	    	    EOL2=(Token)match(input,EOL,FOLLOW_EOL_in_statements74); 
            	    	    EOL2_tree = 
            	    	    (Object)adaptor.create(EOL2)
            	    	    ;
            	    	    adaptor.addChild(root_0, EOL2_tree);


            	    	    }
            	    	    break;

            	    	default :
            	    	    break loop1;
            	        }
            	    } while (true);


            	    }
            	    break;

            	default :
            	    break loop2;
                }
            } while (true);


            EOF3=(Token)match(input,EOF,FOLLOW_EOF_in_statements79); 
            EOF3_tree = 
            (Object)adaptor.create(EOF3)
            ;
            adaptor.addChild(root_0, EOF3_tree);


            }

            retval.stop = input.LT(-1);


            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "statements"


    public static class statement_return extends ParserRuleReturnScope {
        public Statement stmt;
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "statement"
    // org/infinispan/cli/interpreter/IspnCliQL.g:60:1: statement returns [Statement stmt] : ( abortBatchStatement | beginTransactionStatement | cacheStatement | clearCacheStatement | commitTransactionStatement | createStatement | denyStatement | encodingStatement | endBatchStatement | evictStatement | getStatement | grantStatement | infoStatement | locateStatement | pingStatement | putStatement | removeStatement | replaceStatement | rolesStatement | rollbackTransactionStatement | siteStatement | startBatchStatement | statsStatement | upgradeStatement | versionStatement );
    public final IspnCliQLParser.statement_return statement() throws RecognitionException {
        IspnCliQLParser.statement_return retval = new IspnCliQLParser.statement_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        IspnCliQLParser.abortBatchStatement_return abortBatchStatement4 =null;

        IspnCliQLParser.beginTransactionStatement_return beginTransactionStatement5 =null;

        IspnCliQLParser.cacheStatement_return cacheStatement6 =null;

        IspnCliQLParser.clearCacheStatement_return clearCacheStatement7 =null;

        IspnCliQLParser.commitTransactionStatement_return commitTransactionStatement8 =null;

        IspnCliQLParser.createStatement_return createStatement9 =null;

        IspnCliQLParser.denyStatement_return denyStatement10 =null;

        IspnCliQLParser.encodingStatement_return encodingStatement11 =null;

        IspnCliQLParser.endBatchStatement_return endBatchStatement12 =null;

        IspnCliQLParser.evictStatement_return evictStatement13 =null;

        IspnCliQLParser.getStatement_return getStatement14 =null;

        IspnCliQLParser.grantStatement_return grantStatement15 =null;

        IspnCliQLParser.infoStatement_return infoStatement16 =null;

        IspnCliQLParser.locateStatement_return locateStatement17 =null;

        IspnCliQLParser.pingStatement_return pingStatement18 =null;

        IspnCliQLParser.putStatement_return putStatement19 =null;

        IspnCliQLParser.removeStatement_return removeStatement20 =null;

        IspnCliQLParser.replaceStatement_return replaceStatement21 =null;

        IspnCliQLParser.rolesStatement_return rolesStatement22 =null;

        IspnCliQLParser.rollbackTransactionStatement_return rollbackTransactionStatement23 =null;

        IspnCliQLParser.siteStatement_return siteStatement24 =null;

        IspnCliQLParser.startBatchStatement_return startBatchStatement25 =null;

        IspnCliQLParser.statsStatement_return statsStatement26 =null;

        IspnCliQLParser.upgradeStatement_return upgradeStatement27 =null;

        IspnCliQLParser.versionStatement_return versionStatement28 =null;



        try {
            // org/infinispan/cli/interpreter/IspnCliQL.g:61:4: ( abortBatchStatement | beginTransactionStatement | cacheStatement | clearCacheStatement | commitTransactionStatement | createStatement | denyStatement | encodingStatement | endBatchStatement | evictStatement | getStatement | grantStatement | infoStatement | locateStatement | pingStatement | putStatement | removeStatement | replaceStatement | rolesStatement | rollbackTransactionStatement | siteStatement | startBatchStatement | statsStatement | upgradeStatement | versionStatement )
            int alt3=25;
            switch ( input.LA(1) ) {
            case ABORT:
                {
                alt3=1;
                }
                break;
            case BEGIN:
                {
                alt3=2;
                }
                break;
            case CACHE:
                {
                alt3=3;
                }
                break;
            case CLEARCACHE:
                {
                alt3=4;
                }
                break;
            case COMMIT:
                {
                alt3=5;
                }
                break;
            case CREATE:
                {
                alt3=6;
                }
                break;
            case DENY:
                {
                alt3=7;
                }
                break;
            case ENCODING:
                {
                alt3=8;
                }
                break;
            case END:
                {
                alt3=9;
                }
                break;
            case EVICT:
                {
                alt3=10;
                }
                break;
            case GET:
                {
                alt3=11;
                }
                break;
            case GRANT:
                {
                alt3=12;
                }
                break;
            case INFO:
                {
                alt3=13;
                }
                break;
            case LOCATE:
                {
                alt3=14;
                }
                break;
            case PING:
                {
                alt3=15;
                }
                break;
            case PUT:
                {
                alt3=16;
                }
                break;
            case REMOVE:
                {
                alt3=17;
                }
                break;
            case REPLACE:
                {
                alt3=18;
                }
                break;
            case ROLES:
                {
                alt3=19;
                }
                break;
            case ROLLBACK:
                {
                alt3=20;
                }
                break;
            case SITE:
                {
                alt3=21;
                }
                break;
            case START:
                {
                alt3=22;
                }
                break;
            case STATS:
                {
                alt3=23;
                }
                break;
            case UPGRADE:
                {
                alt3=24;
                }
                break;
            case VERSION:
                {
                alt3=25;
                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 3, 0, input);

                throw nvae;

            }

            switch (alt3) {
                case 1 :
                    // org/infinispan/cli/interpreter/IspnCliQL.g:61:6: abortBatchStatement
                    {
                    pushFollow(FOLLOW_abortBatchStatement_in_statement98);
                    abortBatchStatement4=abortBatchStatement();

                    state._fsp--;

                    adaptor.addChild(root_0, abortBatchStatement4.getTree());

                     retval.stmt = (abortBatchStatement4!=null?abortBatchStatement4.stmt:null); 

                    }
                    break;
                case 2 :
                    // org/infinispan/cli/interpreter/IspnCliQL.g:62:6: beginTransactionStatement
                    {
                    pushFollow(FOLLOW_beginTransactionStatement_in_statement107);
                    beginTransactionStatement5=beginTransactionStatement();

                    state._fsp--;

                    adaptor.addChild(root_0, beginTransactionStatement5.getTree());

                     retval.stmt = (beginTransactionStatement5!=null?beginTransactionStatement5.stmt:null); 

                    }
                    break;
                case 3 :
                    // org/infinispan/cli/interpreter/IspnCliQL.g:63:6: cacheStatement
                    {
                    pushFollow(FOLLOW_cacheStatement_in_statement116);
                    cacheStatement6=cacheStatement();

                    state._fsp--;

                    adaptor.addChild(root_0, cacheStatement6.getTree());

                     retval.stmt = (cacheStatement6!=null?cacheStatement6.stmt:null); 

                    }
                    break;
                case 4 :
                    // org/infinispan/cli/interpreter/IspnCliQL.g:64:6: clearCacheStatement
                    {
                    pushFollow(FOLLOW_clearCacheStatement_in_statement125);
                    clearCacheStatement7=clearCacheStatement();

                    state._fsp--;

                    adaptor.addChild(root_0, clearCacheStatement7.getTree());

                     retval.stmt = (clearCacheStatement7!=null?clearCacheStatement7.stmt:null); 

                    }
                    break;
                case 5 :
                    // org/infinispan/cli/interpreter/IspnCliQL.g:65:6: commitTransactionStatement
                    {
                    pushFollow(FOLLOW_commitTransactionStatement_in_statement134);
                    commitTransactionStatement8=commitTransactionStatement();

                    state._fsp--;

                    adaptor.addChild(root_0, commitTransactionStatement8.getTree());

                     retval.stmt = (commitTransactionStatement8!=null?commitTransactionStatement8.stmt:null); 

                    }
                    break;
                case 6 :
                    // org/infinispan/cli/interpreter/IspnCliQL.g:66:6: createStatement
                    {
                    pushFollow(FOLLOW_createStatement_in_statement143);
                    createStatement9=createStatement();

                    state._fsp--;

                    adaptor.addChild(root_0, createStatement9.getTree());

                     retval.stmt = (createStatement9!=null?createStatement9.stmt:null); 

                    }
                    break;
                case 7 :
                    // org/infinispan/cli/interpreter/IspnCliQL.g:67:6: denyStatement
                    {
                    pushFollow(FOLLOW_denyStatement_in_statement152);
                    denyStatement10=denyStatement();

                    state._fsp--;

                    adaptor.addChild(root_0, denyStatement10.getTree());

                     retval.stmt = (denyStatement10!=null?denyStatement10.stmt:null); 

                    }
                    break;
                case 8 :
                    // org/infinispan/cli/interpreter/IspnCliQL.g:68:6: encodingStatement
                    {
                    pushFollow(FOLLOW_encodingStatement_in_statement161);
                    encodingStatement11=encodingStatement();

                    state._fsp--;

                    adaptor.addChild(root_0, encodingStatement11.getTree());

                     retval.stmt = (encodingStatement11!=null?encodingStatement11.stmt:null); 

                    }
                    break;
                case 9 :
                    // org/infinispan/cli/interpreter/IspnCliQL.g:69:6: endBatchStatement
                    {
                    pushFollow(FOLLOW_endBatchStatement_in_statement170);
                    endBatchStatement12=endBatchStatement();

                    state._fsp--;

                    adaptor.addChild(root_0, endBatchStatement12.getTree());

                     retval.stmt = (endBatchStatement12!=null?endBatchStatement12.stmt:null); 

                    }
                    break;
                case 10 :
                    // org/infinispan/cli/interpreter/IspnCliQL.g:70:6: evictStatement
                    {
                    pushFollow(FOLLOW_evictStatement_in_statement179);
                    evictStatement13=evictStatement();

                    state._fsp--;

                    adaptor.addChild(root_0, evictStatement13.getTree());

                     retval.stmt = (evictStatement13!=null?evictStatement13.stmt:null); 

                    }
                    break;
                case 11 :
                    // org/infinispan/cli/interpreter/IspnCliQL.g:71:6: getStatement
                    {
                    pushFollow(FOLLOW_getStatement_in_statement188);
                    getStatement14=getStatement();

                    state._fsp--;

                    adaptor.addChild(root_0, getStatement14.getTree());

                     retval.stmt = (getStatement14!=null?getStatement14.stmt:null); 

                    }
                    break;
                case 12 :
                    // org/infinispan/cli/interpreter/IspnCliQL.g:72:6: grantStatement
                    {
                    pushFollow(FOLLOW_grantStatement_in_statement197);
                    grantStatement15=grantStatement();

                    state._fsp--;

                    adaptor.addChild(root_0, grantStatement15.getTree());

                     retval.stmt = (grantStatement15!=null?grantStatement15.stmt:null); 

                    }
                    break;
                case 13 :
                    // org/infinispan/cli/interpreter/IspnCliQL.g:73:6: infoStatement
                    {
                    pushFollow(FOLLOW_infoStatement_in_statement206);
                    infoStatement16=infoStatement();

                    state._fsp--;

                    adaptor.addChild(root_0, infoStatement16.getTree());

                     retval.stmt = (infoStatement16!=null?infoStatement16.stmt:null); 

                    }
                    break;
                case 14 :
                    // org/infinispan/cli/interpreter/IspnCliQL.g:74:6: locateStatement
                    {
                    pushFollow(FOLLOW_locateStatement_in_statement215);
                    locateStatement17=locateStatement();

                    state._fsp--;

                    adaptor.addChild(root_0, locateStatement17.getTree());

                     retval.stmt = (locateStatement17!=null?locateStatement17.stmt:null); 

                    }
                    break;
                case 15 :
                    // org/infinispan/cli/interpreter/IspnCliQL.g:75:6: pingStatement
                    {
                    pushFollow(FOLLOW_pingStatement_in_statement224);
                    pingStatement18=pingStatement();

                    state._fsp--;

                    adaptor.addChild(root_0, pingStatement18.getTree());

                     retval.stmt = (pingStatement18!=null?pingStatement18.stmt:null); 

                    }
                    break;
                case 16 :
                    // org/infinispan/cli/interpreter/IspnCliQL.g:76:6: putStatement
                    {
                    pushFollow(FOLLOW_putStatement_in_statement233);
                    putStatement19=putStatement();

                    state._fsp--;

                    adaptor.addChild(root_0, putStatement19.getTree());

                     retval.stmt = (putStatement19!=null?putStatement19.stmt:null); 

                    }
                    break;
                case 17 :
                    // org/infinispan/cli/interpreter/IspnCliQL.g:77:6: removeStatement
                    {
                    pushFollow(FOLLOW_removeStatement_in_statement242);
                    removeStatement20=removeStatement();

                    state._fsp--;

                    adaptor.addChild(root_0, removeStatement20.getTree());

                     retval.stmt = (removeStatement20!=null?removeStatement20.stmt:null); 

                    }
                    break;
                case 18 :
                    // org/infinispan/cli/interpreter/IspnCliQL.g:78:6: replaceStatement
                    {
                    pushFollow(FOLLOW_replaceStatement_in_statement251);
                    replaceStatement21=replaceStatement();

                    state._fsp--;

                    adaptor.addChild(root_0, replaceStatement21.getTree());

                     retval.stmt = (replaceStatement21!=null?replaceStatement21.stmt:null); 

                    }
                    break;
                case 19 :
                    // org/infinispan/cli/interpreter/IspnCliQL.g:79:6: rolesStatement
                    {
                    pushFollow(FOLLOW_rolesStatement_in_statement260);
                    rolesStatement22=rolesStatement();

                    state._fsp--;

                    adaptor.addChild(root_0, rolesStatement22.getTree());

                     retval.stmt = (rolesStatement22!=null?rolesStatement22.stmt:null); 

                    }
                    break;
                case 20 :
                    // org/infinispan/cli/interpreter/IspnCliQL.g:80:6: rollbackTransactionStatement
                    {
                    pushFollow(FOLLOW_rollbackTransactionStatement_in_statement269);
                    rollbackTransactionStatement23=rollbackTransactionStatement();

                    state._fsp--;

                    adaptor.addChild(root_0, rollbackTransactionStatement23.getTree());

                     retval.stmt = (rollbackTransactionStatement23!=null?rollbackTransactionStatement23.stmt:null); 

                    }
                    break;
                case 21 :
                    // org/infinispan/cli/interpreter/IspnCliQL.g:81:6: siteStatement
                    {
                    pushFollow(FOLLOW_siteStatement_in_statement278);
                    siteStatement24=siteStatement();

                    state._fsp--;

                    adaptor.addChild(root_0, siteStatement24.getTree());

                     retval.stmt = (siteStatement24!=null?siteStatement24.stmt:null); 

                    }
                    break;
                case 22 :
                    // org/infinispan/cli/interpreter/IspnCliQL.g:82:6: startBatchStatement
                    {
                    pushFollow(FOLLOW_startBatchStatement_in_statement287);
                    startBatchStatement25=startBatchStatement();

                    state._fsp--;

                    adaptor.addChild(root_0, startBatchStatement25.getTree());

                     retval.stmt = (startBatchStatement25!=null?startBatchStatement25.stmt:null); 

                    }
                    break;
                case 23 :
                    // org/infinispan/cli/interpreter/IspnCliQL.g:83:6: statsStatement
                    {
                    pushFollow(FOLLOW_statsStatement_in_statement296);
                    statsStatement26=statsStatement();

                    state._fsp--;

                    adaptor.addChild(root_0, statsStatement26.getTree());

                     retval.stmt = (statsStatement26!=null?statsStatement26.stmt:null); 

                    }
                    break;
                case 24 :
                    // org/infinispan/cli/interpreter/IspnCliQL.g:84:6: upgradeStatement
                    {
                    pushFollow(FOLLOW_upgradeStatement_in_statement305);
                    upgradeStatement27=upgradeStatement();

                    state._fsp--;

                    adaptor.addChild(root_0, upgradeStatement27.getTree());

                     retval.stmt = (upgradeStatement27!=null?upgradeStatement27.stmt:null); 

                    }
                    break;
                case 25 :
                    // org/infinispan/cli/interpreter/IspnCliQL.g:85:6: versionStatement
                    {
                    pushFollow(FOLLOW_versionStatement_in_statement314);
                    versionStatement28=versionStatement();

                    state._fsp--;

                    adaptor.addChild(root_0, versionStatement28.getTree());

                     retval.stmt = (versionStatement28!=null?versionStatement28.stmt:null); 

                    }
                    break;

            }
            retval.stop = input.LT(-1);


            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "statement"


    public static class abortBatchStatement_return extends ParserRuleReturnScope {
        public EndBatchStatement stmt;
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "abortBatchStatement"
    // org/infinispan/cli/interpreter/IspnCliQL.g:89:1: abortBatchStatement returns [EndBatchStatement stmt] : ABORT (cacheName= STRINGLITERAL )? ( EOL | ';' ) !;
    public final IspnCliQLParser.abortBatchStatement_return abortBatchStatement() throws RecognitionException {
        IspnCliQLParser.abortBatchStatement_return retval = new IspnCliQLParser.abortBatchStatement_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token cacheName=null;
        Token ABORT29=null;
        Token set30=null;

        Object cacheName_tree=null;
        Object ABORT29_tree=null;
        Object set30_tree=null;

        try {
            // org/infinispan/cli/interpreter/IspnCliQL.g:90:4: ( ABORT (cacheName= STRINGLITERAL )? ( EOL | ';' ) !)
            // org/infinispan/cli/interpreter/IspnCliQL.g:90:6: ABORT (cacheName= STRINGLITERAL )? ( EOL | ';' ) !
            {
            ABORT29=(Token)match(input,ABORT,FOLLOW_ABORT_in_abortBatchStatement336); 
            ABORT29_tree = 
            (Object)adaptor.create(ABORT29)
            ;
            adaptor.addChild(root_0, ABORT29_tree);


            // org/infinispan/cli/interpreter/IspnCliQL.g:90:12: (cacheName= STRINGLITERAL )?
            int alt4=2;
            switch ( input.LA(1) ) {
                case STRINGLITERAL:
                    {
                    alt4=1;
                    }
                    break;
            }

            switch (alt4) {
                case 1 :
                    // org/infinispan/cli/interpreter/IspnCliQL.g:90:13: cacheName= STRINGLITERAL
                    {
                    cacheName=(Token)match(input,STRINGLITERAL,FOLLOW_STRINGLITERAL_in_abortBatchStatement343); 
                    cacheName_tree = 
                    (Object)adaptor.create(cacheName)
                    ;
                    adaptor.addChild(root_0, cacheName_tree);


                    }
                    break;

            }


            set30=(Token)input.LT(1);

            if ( input.LA(1)==EOL||input.LA(1)==74 ) {
                input.consume();
                state.errorRecovery=false;
            }
            else {
                MismatchedSetException mse = new MismatchedSetException(null,input);
                throw mse;
            }


             retval.stmt = new EndBatchStatement(unquote((cacheName!=null?cacheName.getText():null)), false); 

            }

            retval.stop = input.LT(-1);


            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "abortBatchStatement"


    public static class beginTransactionStatement_return extends ParserRuleReturnScope {
        public BeginTransactionStatement stmt;
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "beginTransactionStatement"
    // org/infinispan/cli/interpreter/IspnCliQL.g:93:1: beginTransactionStatement returns [BeginTransactionStatement stmt] : BEGIN (cacheName= STRINGLITERAL )? ( EOL | ';' ) !;
    public final IspnCliQLParser.beginTransactionStatement_return beginTransactionStatement() throws RecognitionException {
        IspnCliQLParser.beginTransactionStatement_return retval = new IspnCliQLParser.beginTransactionStatement_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token cacheName=null;
        Token BEGIN31=null;
        Token set32=null;

        Object cacheName_tree=null;
        Object BEGIN31_tree=null;
        Object set32_tree=null;

        try {
            // org/infinispan/cli/interpreter/IspnCliQL.g:94:4: ( BEGIN (cacheName= STRINGLITERAL )? ( EOL | ';' ) !)
            // org/infinispan/cli/interpreter/IspnCliQL.g:94:6: BEGIN (cacheName= STRINGLITERAL )? ( EOL | ';' ) !
            {
            BEGIN31=(Token)match(input,BEGIN,FOLLOW_BEGIN_in_beginTransactionStatement375); 
            BEGIN31_tree = 
            (Object)adaptor.create(BEGIN31)
            ;
            adaptor.addChild(root_0, BEGIN31_tree);


            // org/infinispan/cli/interpreter/IspnCliQL.g:94:12: (cacheName= STRINGLITERAL )?
            int alt5=2;
            switch ( input.LA(1) ) {
                case STRINGLITERAL:
                    {
                    alt5=1;
                    }
                    break;
            }

            switch (alt5) {
                case 1 :
                    // org/infinispan/cli/interpreter/IspnCliQL.g:94:13: cacheName= STRINGLITERAL
                    {
                    cacheName=(Token)match(input,STRINGLITERAL,FOLLOW_STRINGLITERAL_in_beginTransactionStatement382); 
                    cacheName_tree = 
                    (Object)adaptor.create(cacheName)
                    ;
                    adaptor.addChild(root_0, cacheName_tree);


                    }
                    break;

            }


            set32=(Token)input.LT(1);

            if ( input.LA(1)==EOL||input.LA(1)==74 ) {
                input.consume();
                state.errorRecovery=false;
            }
            else {
                MismatchedSetException mse = new MismatchedSetException(null,input);
                throw mse;
            }


             retval.stmt = new BeginTransactionStatement(unquote((cacheName!=null?cacheName.getText():null))); 

            }

            retval.stop = input.LT(-1);


            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "beginTransactionStatement"


    public static class cacheStatement_return extends ParserRuleReturnScope {
        public CacheStatement stmt;
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "cacheStatement"
    // org/infinispan/cli/interpreter/IspnCliQL.g:97:1: cacheStatement returns [CacheStatement stmt] : CACHE (cacheName= STRINGLITERAL )? ( EOL | ';' ) !;
    public final IspnCliQLParser.cacheStatement_return cacheStatement() throws RecognitionException {
        IspnCliQLParser.cacheStatement_return retval = new IspnCliQLParser.cacheStatement_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token cacheName=null;
        Token CACHE33=null;
        Token set34=null;

        Object cacheName_tree=null;
        Object CACHE33_tree=null;
        Object set34_tree=null;

        try {
            // org/infinispan/cli/interpreter/IspnCliQL.g:98:4: ( CACHE (cacheName= STRINGLITERAL )? ( EOL | ';' ) !)
            // org/infinispan/cli/interpreter/IspnCliQL.g:98:6: CACHE (cacheName= STRINGLITERAL )? ( EOL | ';' ) !
            {
            CACHE33=(Token)match(input,CACHE,FOLLOW_CACHE_in_cacheStatement414); 
            CACHE33_tree = 
            (Object)adaptor.create(CACHE33)
            ;
            adaptor.addChild(root_0, CACHE33_tree);


            // org/infinispan/cli/interpreter/IspnCliQL.g:98:12: (cacheName= STRINGLITERAL )?
            int alt6=2;
            switch ( input.LA(1) ) {
                case STRINGLITERAL:
                    {
                    alt6=1;
                    }
                    break;
            }

            switch (alt6) {
                case 1 :
                    // org/infinispan/cli/interpreter/IspnCliQL.g:98:13: cacheName= STRINGLITERAL
                    {
                    cacheName=(Token)match(input,STRINGLITERAL,FOLLOW_STRINGLITERAL_in_cacheStatement421); 
                    cacheName_tree = 
                    (Object)adaptor.create(cacheName)
                    ;
                    adaptor.addChild(root_0, cacheName_tree);


                    }
                    break;

            }


            set34=(Token)input.LT(1);

            if ( input.LA(1)==EOL||input.LA(1)==74 ) {
                input.consume();
                state.errorRecovery=false;
            }
            else {
                MismatchedSetException mse = new MismatchedSetException(null,input);
                throw mse;
            }


             retval.stmt = new CacheStatement(unquote((cacheName!=null?cacheName.getText():null))); 

            }

            retval.stop = input.LT(-1);


            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "cacheStatement"


    public static class clearCacheStatement_return extends ParserRuleReturnScope {
        public ClearCacheStatement stmt;
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "clearCacheStatement"
    // org/infinispan/cli/interpreter/IspnCliQL.g:101:1: clearCacheStatement returns [ClearCacheStatement stmt] : CLEARCACHE (cacheName= STRINGLITERAL )? ( EOL | ';' ) !;
    public final IspnCliQLParser.clearCacheStatement_return clearCacheStatement() throws RecognitionException {
        IspnCliQLParser.clearCacheStatement_return retval = new IspnCliQLParser.clearCacheStatement_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token cacheName=null;
        Token CLEARCACHE35=null;
        Token set36=null;

        Object cacheName_tree=null;
        Object CLEARCACHE35_tree=null;
        Object set36_tree=null;

        try {
            // org/infinispan/cli/interpreter/IspnCliQL.g:102:4: ( CLEARCACHE (cacheName= STRINGLITERAL )? ( EOL | ';' ) !)
            // org/infinispan/cli/interpreter/IspnCliQL.g:102:6: CLEARCACHE (cacheName= STRINGLITERAL )? ( EOL | ';' ) !
            {
            CLEARCACHE35=(Token)match(input,CLEARCACHE,FOLLOW_CLEARCACHE_in_clearCacheStatement453); 
            CLEARCACHE35_tree = 
            (Object)adaptor.create(CLEARCACHE35)
            ;
            adaptor.addChild(root_0, CLEARCACHE35_tree);


            // org/infinispan/cli/interpreter/IspnCliQL.g:102:17: (cacheName= STRINGLITERAL )?
            int alt7=2;
            switch ( input.LA(1) ) {
                case STRINGLITERAL:
                    {
                    alt7=1;
                    }
                    break;
            }

            switch (alt7) {
                case 1 :
                    // org/infinispan/cli/interpreter/IspnCliQL.g:102:18: cacheName= STRINGLITERAL
                    {
                    cacheName=(Token)match(input,STRINGLITERAL,FOLLOW_STRINGLITERAL_in_clearCacheStatement460); 
                    cacheName_tree = 
                    (Object)adaptor.create(cacheName)
                    ;
                    adaptor.addChild(root_0, cacheName_tree);


                    }
                    break;

            }


            set36=(Token)input.LT(1);

            if ( input.LA(1)==EOL||input.LA(1)==74 ) {
                input.consume();
                state.errorRecovery=false;
            }
            else {
                MismatchedSetException mse = new MismatchedSetException(null,input);
                throw mse;
            }


             retval.stmt = new ClearCacheStatement(unquote((cacheName!=null?cacheName.getText():null))); 

            }

            retval.stop = input.LT(-1);


            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "clearCacheStatement"


    public static class commitTransactionStatement_return extends ParserRuleReturnScope {
        public CommitTransactionStatement stmt;
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "commitTransactionStatement"
    // org/infinispan/cli/interpreter/IspnCliQL.g:105:1: commitTransactionStatement returns [CommitTransactionStatement stmt] : COMMIT (cacheName= STRINGLITERAL )? ( EOL | ';' ) !;
    public final IspnCliQLParser.commitTransactionStatement_return commitTransactionStatement() throws RecognitionException {
        IspnCliQLParser.commitTransactionStatement_return retval = new IspnCliQLParser.commitTransactionStatement_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token cacheName=null;
        Token COMMIT37=null;
        Token set38=null;

        Object cacheName_tree=null;
        Object COMMIT37_tree=null;
        Object set38_tree=null;

        try {
            // org/infinispan/cli/interpreter/IspnCliQL.g:106:4: ( COMMIT (cacheName= STRINGLITERAL )? ( EOL | ';' ) !)
            // org/infinispan/cli/interpreter/IspnCliQL.g:106:6: COMMIT (cacheName= STRINGLITERAL )? ( EOL | ';' ) !
            {
            COMMIT37=(Token)match(input,COMMIT,FOLLOW_COMMIT_in_commitTransactionStatement492); 
            COMMIT37_tree = 
            (Object)adaptor.create(COMMIT37)
            ;
            adaptor.addChild(root_0, COMMIT37_tree);


            // org/infinispan/cli/interpreter/IspnCliQL.g:106:13: (cacheName= STRINGLITERAL )?
            int alt8=2;
            switch ( input.LA(1) ) {
                case STRINGLITERAL:
                    {
                    alt8=1;
                    }
                    break;
            }

            switch (alt8) {
                case 1 :
                    // org/infinispan/cli/interpreter/IspnCliQL.g:106:14: cacheName= STRINGLITERAL
                    {
                    cacheName=(Token)match(input,STRINGLITERAL,FOLLOW_STRINGLITERAL_in_commitTransactionStatement499); 
                    cacheName_tree = 
                    (Object)adaptor.create(cacheName)
                    ;
                    adaptor.addChild(root_0, cacheName_tree);


                    }
                    break;

            }


            set38=(Token)input.LT(1);

            if ( input.LA(1)==EOL||input.LA(1)==74 ) {
                input.consume();
                state.errorRecovery=false;
            }
            else {
                MismatchedSetException mse = new MismatchedSetException(null,input);
                throw mse;
            }


             retval.stmt = new CommitTransactionStatement(unquote((cacheName!=null?cacheName.getText():null))); 

            }

            retval.stop = input.LT(-1);


            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "commitTransactionStatement"


    public static class createStatement_return extends ParserRuleReturnScope {
        public CreateStatement stmt;
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "createStatement"
    // org/infinispan/cli/interpreter/IspnCliQL.g:109:1: createStatement returns [CreateStatement stmt] : CREATE cacheName= STRINGLITERAL ( LIKE baseCacheName= STRINGLITERAL )? ( EOL | ';' ) !;
    public final IspnCliQLParser.createStatement_return createStatement() throws RecognitionException {
        IspnCliQLParser.createStatement_return retval = new IspnCliQLParser.createStatement_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token cacheName=null;
        Token baseCacheName=null;
        Token CREATE39=null;
        Token LIKE40=null;
        Token set41=null;

        Object cacheName_tree=null;
        Object baseCacheName_tree=null;
        Object CREATE39_tree=null;
        Object LIKE40_tree=null;
        Object set41_tree=null;

        try {
            // org/infinispan/cli/interpreter/IspnCliQL.g:110:4: ( CREATE cacheName= STRINGLITERAL ( LIKE baseCacheName= STRINGLITERAL )? ( EOL | ';' ) !)
            // org/infinispan/cli/interpreter/IspnCliQL.g:110:6: CREATE cacheName= STRINGLITERAL ( LIKE baseCacheName= STRINGLITERAL )? ( EOL | ';' ) !
            {
            CREATE39=(Token)match(input,CREATE,FOLLOW_CREATE_in_createStatement531); 
            CREATE39_tree = 
            (Object)adaptor.create(CREATE39)
            ;
            adaptor.addChild(root_0, CREATE39_tree);


            cacheName=(Token)match(input,STRINGLITERAL,FOLLOW_STRINGLITERAL_in_createStatement537); 
            cacheName_tree = 
            (Object)adaptor.create(cacheName)
            ;
            adaptor.addChild(root_0, cacheName_tree);


            // org/infinispan/cli/interpreter/IspnCliQL.g:110:39: ( LIKE baseCacheName= STRINGLITERAL )?
            int alt9=2;
            switch ( input.LA(1) ) {
                case LIKE:
                    {
                    alt9=1;
                    }
                    break;
            }

            switch (alt9) {
                case 1 :
                    // org/infinispan/cli/interpreter/IspnCliQL.g:110:40: LIKE baseCacheName= STRINGLITERAL
                    {
                    LIKE40=(Token)match(input,LIKE,FOLLOW_LIKE_in_createStatement540); 
                    LIKE40_tree = 
                    (Object)adaptor.create(LIKE40)
                    ;
                    adaptor.addChild(root_0, LIKE40_tree);


                    baseCacheName=(Token)match(input,STRINGLITERAL,FOLLOW_STRINGLITERAL_in_createStatement546); 
                    baseCacheName_tree = 
                    (Object)adaptor.create(baseCacheName)
                    ;
                    adaptor.addChild(root_0, baseCacheName_tree);


                    }
                    break;

            }


            set41=(Token)input.LT(1);

            if ( input.LA(1)==EOL||input.LA(1)==74 ) {
                input.consume();
                state.errorRecovery=false;
            }
            else {
                MismatchedSetException mse = new MismatchedSetException(null,input);
                throw mse;
            }


             retval.stmt = new CreateStatement(unquote((cacheName!=null?cacheName.getText():null)), unquote((baseCacheName!=null?baseCacheName.getText():null))); 

            }

            retval.stop = input.LT(-1);


            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "createStatement"


    public static class denyStatement_return extends ParserRuleReturnScope {
        public DenyStatement stmt;
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "denyStatement"
    // org/infinispan/cli/interpreter/IspnCliQL.g:113:1: denyStatement returns [DenyStatement stmt] : DENY roleName= STRINGLITERAL TO principalName= STRINGLITERAL ( EOL | ';' ) !;
    public final IspnCliQLParser.denyStatement_return denyStatement() throws RecognitionException {
        IspnCliQLParser.denyStatement_return retval = new IspnCliQLParser.denyStatement_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token roleName=null;
        Token principalName=null;
        Token DENY42=null;
        Token TO43=null;
        Token set44=null;

        Object roleName_tree=null;
        Object principalName_tree=null;
        Object DENY42_tree=null;
        Object TO43_tree=null;
        Object set44_tree=null;

        try {
            // org/infinispan/cli/interpreter/IspnCliQL.g:114:4: ( DENY roleName= STRINGLITERAL TO principalName= STRINGLITERAL ( EOL | ';' ) !)
            // org/infinispan/cli/interpreter/IspnCliQL.g:114:6: DENY roleName= STRINGLITERAL TO principalName= STRINGLITERAL ( EOL | ';' ) !
            {
            DENY42=(Token)match(input,DENY,FOLLOW_DENY_in_denyStatement578); 
            DENY42_tree = 
            (Object)adaptor.create(DENY42)
            ;
            adaptor.addChild(root_0, DENY42_tree);


            roleName=(Token)match(input,STRINGLITERAL,FOLLOW_STRINGLITERAL_in_denyStatement584); 
            roleName_tree = 
            (Object)adaptor.create(roleName)
            ;
            adaptor.addChild(root_0, roleName_tree);


            TO43=(Token)match(input,TO,FOLLOW_TO_in_denyStatement586); 
            TO43_tree = 
            (Object)adaptor.create(TO43)
            ;
            adaptor.addChild(root_0, TO43_tree);


            principalName=(Token)match(input,STRINGLITERAL,FOLLOW_STRINGLITERAL_in_denyStatement592); 
            principalName_tree = 
            (Object)adaptor.create(principalName)
            ;
            adaptor.addChild(root_0, principalName_tree);


            set44=(Token)input.LT(1);

            if ( input.LA(1)==EOL||input.LA(1)==74 ) {
                input.consume();
                state.errorRecovery=false;
            }
            else {
                MismatchedSetException mse = new MismatchedSetException(null,input);
                throw mse;
            }


             retval.stmt = new DenyStatement((roleName!=null?roleName.getText():null), (principalName!=null?principalName.getText():null)); 

            }

            retval.stop = input.LT(-1);


            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "denyStatement"


    public static class encodingStatement_return extends ParserRuleReturnScope {
        public EncodingStatement stmt;
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "encodingStatement"
    // org/infinispan/cli/interpreter/IspnCliQL.g:118:1: encodingStatement returns [EncodingStatement stmt] : ENCODING opts= statementOptions (codecName= STRINGLITERAL )? ( EOL | ';' ) !;
    public final IspnCliQLParser.encodingStatement_return encodingStatement() throws RecognitionException {
        IspnCliQLParser.encodingStatement_return retval = new IspnCliQLParser.encodingStatement_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token codecName=null;
        Token ENCODING45=null;
        Token set46=null;
        IspnCliQLParser.statementOptions_return opts =null;


        Object codecName_tree=null;
        Object ENCODING45_tree=null;
        Object set46_tree=null;

        try {
            // org/infinispan/cli/interpreter/IspnCliQL.g:119:4: ( ENCODING opts= statementOptions (codecName= STRINGLITERAL )? ( EOL | ';' ) !)
            // org/infinispan/cli/interpreter/IspnCliQL.g:119:6: ENCODING opts= statementOptions (codecName= STRINGLITERAL )? ( EOL | ';' ) !
            {
            ENCODING45=(Token)match(input,ENCODING,FOLLOW_ENCODING_in_encodingStatement623); 
            ENCODING45_tree = 
            (Object)adaptor.create(ENCODING45)
            ;
            adaptor.addChild(root_0, ENCODING45_tree);


            pushFollow(FOLLOW_statementOptions_in_encodingStatement629);
            opts=statementOptions();

            state._fsp--;

            adaptor.addChild(root_0, opts.getTree());

            // org/infinispan/cli/interpreter/IspnCliQL.g:119:39: (codecName= STRINGLITERAL )?
            int alt10=2;
            switch ( input.LA(1) ) {
                case STRINGLITERAL:
                    {
                    alt10=1;
                    }
                    break;
            }

            switch (alt10) {
                case 1 :
                    // org/infinispan/cli/interpreter/IspnCliQL.g:119:40: codecName= STRINGLITERAL
                    {
                    codecName=(Token)match(input,STRINGLITERAL,FOLLOW_STRINGLITERAL_in_encodingStatement636); 
                    codecName_tree = 
                    (Object)adaptor.create(codecName)
                    ;
                    adaptor.addChild(root_0, codecName_tree);


                    }
                    break;

            }


            set46=(Token)input.LT(1);

            if ( input.LA(1)==EOL||input.LA(1)==74 ) {
                input.consume();
                state.errorRecovery=false;
            }
            else {
                MismatchedSetException mse = new MismatchedSetException(null,input);
                throw mse;
            }


             retval.stmt = new EncodingStatement((opts!=null?opts.options:null), unquote((codecName!=null?codecName.getText():null))); 

            }

            retval.stop = input.LT(-1);


            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "encodingStatement"


    public static class endBatchStatement_return extends ParserRuleReturnScope {
        public EndBatchStatement stmt;
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "endBatchStatement"
    // org/infinispan/cli/interpreter/IspnCliQL.g:122:1: endBatchStatement returns [EndBatchStatement stmt] : END (cacheName= STRINGLITERAL )? ( EOL | ';' ) !;
    public final IspnCliQLParser.endBatchStatement_return endBatchStatement() throws RecognitionException {
        IspnCliQLParser.endBatchStatement_return retval = new IspnCliQLParser.endBatchStatement_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token cacheName=null;
        Token END47=null;
        Token set48=null;

        Object cacheName_tree=null;
        Object END47_tree=null;
        Object set48_tree=null;

        try {
            // org/infinispan/cli/interpreter/IspnCliQL.g:123:4: ( END (cacheName= STRINGLITERAL )? ( EOL | ';' ) !)
            // org/infinispan/cli/interpreter/IspnCliQL.g:123:6: END (cacheName= STRINGLITERAL )? ( EOL | ';' ) !
            {
            END47=(Token)match(input,END,FOLLOW_END_in_endBatchStatement668); 
            END47_tree = 
            (Object)adaptor.create(END47)
            ;
            adaptor.addChild(root_0, END47_tree);


            // org/infinispan/cli/interpreter/IspnCliQL.g:123:10: (cacheName= STRINGLITERAL )?
            int alt11=2;
            switch ( input.LA(1) ) {
                case STRINGLITERAL:
                    {
                    alt11=1;
                    }
                    break;
            }

            switch (alt11) {
                case 1 :
                    // org/infinispan/cli/interpreter/IspnCliQL.g:123:11: cacheName= STRINGLITERAL
                    {
                    cacheName=(Token)match(input,STRINGLITERAL,FOLLOW_STRINGLITERAL_in_endBatchStatement675); 
                    cacheName_tree = 
                    (Object)adaptor.create(cacheName)
                    ;
                    adaptor.addChild(root_0, cacheName_tree);


                    }
                    break;

            }


            set48=(Token)input.LT(1);

            if ( input.LA(1)==EOL||input.LA(1)==74 ) {
                input.consume();
                state.errorRecovery=false;
            }
            else {
                MismatchedSetException mse = new MismatchedSetException(null,input);
                throw mse;
            }


             retval.stmt = new EndBatchStatement(unquote((cacheName!=null?cacheName.getText():null)), true); 

            }

            retval.stop = input.LT(-1);


            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "endBatchStatement"


    public static class evictStatement_return extends ParserRuleReturnScope {
        public EvictStatement stmt;
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "evictStatement"
    // org/infinispan/cli/interpreter/IspnCliQL.g:126:1: evictStatement returns [EvictStatement stmt] : EVICT opts= statementOptions key= keyIdentifier ( EOL | ';' ) !;
    public final IspnCliQLParser.evictStatement_return evictStatement() throws RecognitionException {
        IspnCliQLParser.evictStatement_return retval = new IspnCliQLParser.evictStatement_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token EVICT49=null;
        Token set50=null;
        IspnCliQLParser.statementOptions_return opts =null;

        IspnCliQLParser.keyIdentifier_return key =null;


        Object EVICT49_tree=null;
        Object set50_tree=null;

        try {
            // org/infinispan/cli/interpreter/IspnCliQL.g:127:4: ( EVICT opts= statementOptions key= keyIdentifier ( EOL | ';' ) !)
            // org/infinispan/cli/interpreter/IspnCliQL.g:127:6: EVICT opts= statementOptions key= keyIdentifier ( EOL | ';' ) !
            {
            EVICT49=(Token)match(input,EVICT,FOLLOW_EVICT_in_evictStatement707); 
            EVICT49_tree = 
            (Object)adaptor.create(EVICT49)
            ;
            adaptor.addChild(root_0, EVICT49_tree);


            pushFollow(FOLLOW_statementOptions_in_evictStatement713);
            opts=statementOptions();

            state._fsp--;

            adaptor.addChild(root_0, opts.getTree());

            pushFollow(FOLLOW_keyIdentifier_in_evictStatement719);
            key=keyIdentifier();

            state._fsp--;

            adaptor.addChild(root_0, key.getTree());

            set50=(Token)input.LT(1);

            if ( input.LA(1)==EOL||input.LA(1)==74 ) {
                input.consume();
                state.errorRecovery=false;
            }
            else {
                MismatchedSetException mse = new MismatchedSetException(null,input);
                throw mse;
            }


             retval.stmt = new EvictStatement((opts!=null?opts.options:null), (key!=null?key.key:null)); 

            }

            retval.stop = input.LT(-1);


            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "evictStatement"


    public static class getStatement_return extends ParserRuleReturnScope {
        public GetStatement stmt;
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "getStatement"
    // org/infinispan/cli/interpreter/IspnCliQL.g:130:1: getStatement returns [GetStatement stmt] : GET opts= statementOptions key= keyIdentifier ( EOL | ';' ) !;
    public final IspnCliQLParser.getStatement_return getStatement() throws RecognitionException {
        IspnCliQLParser.getStatement_return retval = new IspnCliQLParser.getStatement_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token GET51=null;
        Token set52=null;
        IspnCliQLParser.statementOptions_return opts =null;

        IspnCliQLParser.keyIdentifier_return key =null;


        Object GET51_tree=null;
        Object set52_tree=null;

        try {
            // org/infinispan/cli/interpreter/IspnCliQL.g:131:4: ( GET opts= statementOptions key= keyIdentifier ( EOL | ';' ) !)
            // org/infinispan/cli/interpreter/IspnCliQL.g:131:6: GET opts= statementOptions key= keyIdentifier ( EOL | ';' ) !
            {
            GET51=(Token)match(input,GET,FOLLOW_GET_in_getStatement749); 
            GET51_tree = 
            (Object)adaptor.create(GET51)
            ;
            adaptor.addChild(root_0, GET51_tree);


            pushFollow(FOLLOW_statementOptions_in_getStatement755);
            opts=statementOptions();

            state._fsp--;

            adaptor.addChild(root_0, opts.getTree());

            pushFollow(FOLLOW_keyIdentifier_in_getStatement761);
            key=keyIdentifier();

            state._fsp--;

            adaptor.addChild(root_0, key.getTree());

            set52=(Token)input.LT(1);

            if ( input.LA(1)==EOL||input.LA(1)==74 ) {
                input.consume();
                state.errorRecovery=false;
            }
            else {
                MismatchedSetException mse = new MismatchedSetException(null,input);
                throw mse;
            }


             retval.stmt = new GetStatement((opts!=null?opts.options:null), (key!=null?key.key:null)); 

            }

            retval.stop = input.LT(-1);


            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "getStatement"


    public static class grantStatement_return extends ParserRuleReturnScope {
        public GrantStatement stmt;
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "grantStatement"
    // org/infinispan/cli/interpreter/IspnCliQL.g:134:1: grantStatement returns [GrantStatement stmt] : GRANT roleName= STRINGLITERAL TO principalName= STRINGLITERAL ( EOL | ';' ) !;
    public final IspnCliQLParser.grantStatement_return grantStatement() throws RecognitionException {
        IspnCliQLParser.grantStatement_return retval = new IspnCliQLParser.grantStatement_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token roleName=null;
        Token principalName=null;
        Token GRANT53=null;
        Token TO54=null;
        Token set55=null;

        Object roleName_tree=null;
        Object principalName_tree=null;
        Object GRANT53_tree=null;
        Object TO54_tree=null;
        Object set55_tree=null;

        try {
            // org/infinispan/cli/interpreter/IspnCliQL.g:135:4: ( GRANT roleName= STRINGLITERAL TO principalName= STRINGLITERAL ( EOL | ';' ) !)
            // org/infinispan/cli/interpreter/IspnCliQL.g:135:6: GRANT roleName= STRINGLITERAL TO principalName= STRINGLITERAL ( EOL | ';' ) !
            {
            GRANT53=(Token)match(input,GRANT,FOLLOW_GRANT_in_grantStatement791); 
            GRANT53_tree = 
            (Object)adaptor.create(GRANT53)
            ;
            adaptor.addChild(root_0, GRANT53_tree);


            roleName=(Token)match(input,STRINGLITERAL,FOLLOW_STRINGLITERAL_in_grantStatement797); 
            roleName_tree = 
            (Object)adaptor.create(roleName)
            ;
            adaptor.addChild(root_0, roleName_tree);


            TO54=(Token)match(input,TO,FOLLOW_TO_in_grantStatement799); 
            TO54_tree = 
            (Object)adaptor.create(TO54)
            ;
            adaptor.addChild(root_0, TO54_tree);


            principalName=(Token)match(input,STRINGLITERAL,FOLLOW_STRINGLITERAL_in_grantStatement805); 
            principalName_tree = 
            (Object)adaptor.create(principalName)
            ;
            adaptor.addChild(root_0, principalName_tree);


            set55=(Token)input.LT(1);

            if ( input.LA(1)==EOL||input.LA(1)==74 ) {
                input.consume();
                state.errorRecovery=false;
            }
            else {
                MismatchedSetException mse = new MismatchedSetException(null,input);
                throw mse;
            }


             retval.stmt = new GrantStatement((roleName!=null?roleName.getText():null), (principalName!=null?principalName.getText():null)); 

            }

            retval.stop = input.LT(-1);


            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "grantStatement"


    public static class infoStatement_return extends ParserRuleReturnScope {
        public InfoStatement stmt;
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "infoStatement"
    // org/infinispan/cli/interpreter/IspnCliQL.g:138:1: infoStatement returns [InfoStatement stmt] : INFO (cacheName= STRINGLITERAL )? ( EOL | ';' ) !;
    public final IspnCliQLParser.infoStatement_return infoStatement() throws RecognitionException {
        IspnCliQLParser.infoStatement_return retval = new IspnCliQLParser.infoStatement_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token cacheName=null;
        Token INFO56=null;
        Token set57=null;

        Object cacheName_tree=null;
        Object INFO56_tree=null;
        Object set57_tree=null;

        try {
            // org/infinispan/cli/interpreter/IspnCliQL.g:139:4: ( INFO (cacheName= STRINGLITERAL )? ( EOL | ';' ) !)
            // org/infinispan/cli/interpreter/IspnCliQL.g:139:6: INFO (cacheName= STRINGLITERAL )? ( EOL | ';' ) !
            {
            INFO56=(Token)match(input,INFO,FOLLOW_INFO_in_infoStatement835); 
            INFO56_tree = 
            (Object)adaptor.create(INFO56)
            ;
            adaptor.addChild(root_0, INFO56_tree);


            // org/infinispan/cli/interpreter/IspnCliQL.g:139:11: (cacheName= STRINGLITERAL )?
            int alt12=2;
            switch ( input.LA(1) ) {
                case STRINGLITERAL:
                    {
                    alt12=1;
                    }
                    break;
            }

            switch (alt12) {
                case 1 :
                    // org/infinispan/cli/interpreter/IspnCliQL.g:139:12: cacheName= STRINGLITERAL
                    {
                    cacheName=(Token)match(input,STRINGLITERAL,FOLLOW_STRINGLITERAL_in_infoStatement842); 
                    cacheName_tree = 
                    (Object)adaptor.create(cacheName)
                    ;
                    adaptor.addChild(root_0, cacheName_tree);


                    }
                    break;

            }


            set57=(Token)input.LT(1);

            if ( input.LA(1)==EOL||input.LA(1)==74 ) {
                input.consume();
                state.errorRecovery=false;
            }
            else {
                MismatchedSetException mse = new MismatchedSetException(null,input);
                throw mse;
            }


             retval.stmt = new InfoStatement(unquote((cacheName!=null?cacheName.getText():null))); 

            }

            retval.stop = input.LT(-1);


            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "infoStatement"


    public static class locateStatement_return extends ParserRuleReturnScope {
        public LocateStatement stmt;
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "locateStatement"
    // org/infinispan/cli/interpreter/IspnCliQL.g:142:1: locateStatement returns [LocateStatement stmt] : LOCATE opts= statementOptions key= keyIdentifier ( EOL | ';' ) !;
    public final IspnCliQLParser.locateStatement_return locateStatement() throws RecognitionException {
        IspnCliQLParser.locateStatement_return retval = new IspnCliQLParser.locateStatement_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token LOCATE58=null;
        Token set59=null;
        IspnCliQLParser.statementOptions_return opts =null;

        IspnCliQLParser.keyIdentifier_return key =null;


        Object LOCATE58_tree=null;
        Object set59_tree=null;

        try {
            // org/infinispan/cli/interpreter/IspnCliQL.g:143:4: ( LOCATE opts= statementOptions key= keyIdentifier ( EOL | ';' ) !)
            // org/infinispan/cli/interpreter/IspnCliQL.g:143:6: LOCATE opts= statementOptions key= keyIdentifier ( EOL | ';' ) !
            {
            LOCATE58=(Token)match(input,LOCATE,FOLLOW_LOCATE_in_locateStatement874); 
            LOCATE58_tree = 
            (Object)adaptor.create(LOCATE58)
            ;
            adaptor.addChild(root_0, LOCATE58_tree);


            pushFollow(FOLLOW_statementOptions_in_locateStatement880);
            opts=statementOptions();

            state._fsp--;

            adaptor.addChild(root_0, opts.getTree());

            pushFollow(FOLLOW_keyIdentifier_in_locateStatement886);
            key=keyIdentifier();

            state._fsp--;

            adaptor.addChild(root_0, key.getTree());

            set59=(Token)input.LT(1);

            if ( input.LA(1)==EOL||input.LA(1)==74 ) {
                input.consume();
                state.errorRecovery=false;
            }
            else {
                MismatchedSetException mse = new MismatchedSetException(null,input);
                throw mse;
            }


             retval.stmt = new LocateStatement((opts!=null?opts.options:null), (key!=null?key.key:null)); 

            }

            retval.stop = input.LT(-1);


            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "locateStatement"


    public static class pingStatement_return extends ParserRuleReturnScope {
        public PingStatement stmt;
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "pingStatement"
    // org/infinispan/cli/interpreter/IspnCliQL.g:146:1: pingStatement returns [PingStatement stmt] : PING ( EOL | ';' ) !;
    public final IspnCliQLParser.pingStatement_return pingStatement() throws RecognitionException {
        IspnCliQLParser.pingStatement_return retval = new IspnCliQLParser.pingStatement_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token PING60=null;
        Token set61=null;

        Object PING60_tree=null;
        Object set61_tree=null;

        try {
            // org/infinispan/cli/interpreter/IspnCliQL.g:147:4: ( PING ( EOL | ';' ) !)
            // org/infinispan/cli/interpreter/IspnCliQL.g:147:6: PING ( EOL | ';' ) !
            {
            PING60=(Token)match(input,PING,FOLLOW_PING_in_pingStatement916); 
            PING60_tree = 
            (Object)adaptor.create(PING60)
            ;
            adaptor.addChild(root_0, PING60_tree);


            set61=(Token)input.LT(1);

            if ( input.LA(1)==EOL||input.LA(1)==74 ) {
                input.consume();
                state.errorRecovery=false;
            }
            else {
                MismatchedSetException mse = new MismatchedSetException(null,input);
                throw mse;
            }


             retval.stmt = new PingStatement(); 

            }

            retval.stop = input.LT(-1);


            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "pingStatement"


    public static class putStatement_return extends ParserRuleReturnScope {
        public PutStatement stmt;
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "putStatement"
    // org/infinispan/cli/interpreter/IspnCliQL.g:150:1: putStatement returns [PutStatement stmt] : PUT opts= statementOptions key= keyIdentifier value= literal (exp= expirationClause )? ( EOL | ';' ) !;
    public final IspnCliQLParser.putStatement_return putStatement() throws RecognitionException {
        IspnCliQLParser.putStatement_return retval = new IspnCliQLParser.putStatement_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token PUT62=null;
        Token set63=null;
        IspnCliQLParser.statementOptions_return opts =null;

        IspnCliQLParser.keyIdentifier_return key =null;

        IspnCliQLParser.literal_return value =null;

        IspnCliQLParser.expirationClause_return exp =null;


        Object PUT62_tree=null;
        Object set63_tree=null;

        try {
            // org/infinispan/cli/interpreter/IspnCliQL.g:151:4: ( PUT opts= statementOptions key= keyIdentifier value= literal (exp= expirationClause )? ( EOL | ';' ) !)
            // org/infinispan/cli/interpreter/IspnCliQL.g:151:6: PUT opts= statementOptions key= keyIdentifier value= literal (exp= expirationClause )? ( EOL | ';' ) !
            {
            PUT62=(Token)match(input,PUT,FOLLOW_PUT_in_putStatement946); 
            PUT62_tree = 
            (Object)adaptor.create(PUT62)
            ;
            adaptor.addChild(root_0, PUT62_tree);


            pushFollow(FOLLOW_statementOptions_in_putStatement952);
            opts=statementOptions();

            state._fsp--;

            adaptor.addChild(root_0, opts.getTree());

            pushFollow(FOLLOW_keyIdentifier_in_putStatement958);
            key=keyIdentifier();

            state._fsp--;

            adaptor.addChild(root_0, key.getTree());

            pushFollow(FOLLOW_literal_in_putStatement964);
            value=literal();

            state._fsp--;

            adaptor.addChild(root_0, value.getTree());

            // org/infinispan/cli/interpreter/IspnCliQL.g:151:70: (exp= expirationClause )?
            int alt13=2;
            switch ( input.LA(1) ) {
                case EXPIRES:
                    {
                    alt13=1;
                    }
                    break;
            }

            switch (alt13) {
                case 1 :
                    // org/infinispan/cli/interpreter/IspnCliQL.g:151:71: exp= expirationClause
                    {
                    pushFollow(FOLLOW_expirationClause_in_putStatement971);
                    exp=expirationClause();

                    state._fsp--;

                    adaptor.addChild(root_0, exp.getTree());

                    }
                    break;

            }


            set63=(Token)input.LT(1);

            if ( input.LA(1)==EOL||input.LA(1)==74 ) {
                input.consume();
                state.errorRecovery=false;
            }
            else {
                MismatchedSetException mse = new MismatchedSetException(null,input);
                throw mse;
            }


             retval.stmt = new PutStatement((opts!=null?opts.options:null), (key!=null?key.key:null), (value!=null?value.o:null), (exp!=null?exp.exp:null)); 

            }

            retval.stop = input.LT(-1);


            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "putStatement"


    public static class removeStatement_return extends ParserRuleReturnScope {
        public RemoveStatement stmt;
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "removeStatement"
    // org/infinispan/cli/interpreter/IspnCliQL.g:154:1: removeStatement returns [RemoveStatement stmt] : REMOVE opts= statementOptions key= keyIdentifier (value= literal )? ( EOL | ';' ) !;
    public final IspnCliQLParser.removeStatement_return removeStatement() throws RecognitionException {
        IspnCliQLParser.removeStatement_return retval = new IspnCliQLParser.removeStatement_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token REMOVE64=null;
        Token set65=null;
        IspnCliQLParser.statementOptions_return opts =null;

        IspnCliQLParser.keyIdentifier_return key =null;

        IspnCliQLParser.literal_return value =null;


        Object REMOVE64_tree=null;
        Object set65_tree=null;

        try {
            // org/infinispan/cli/interpreter/IspnCliQL.g:155:4: ( REMOVE opts= statementOptions key= keyIdentifier (value= literal )? ( EOL | ';' ) !)
            // org/infinispan/cli/interpreter/IspnCliQL.g:155:6: REMOVE opts= statementOptions key= keyIdentifier (value= literal )? ( EOL | ';' ) !
            {
            REMOVE64=(Token)match(input,REMOVE,FOLLOW_REMOVE_in_removeStatement1003); 
            REMOVE64_tree = 
            (Object)adaptor.create(REMOVE64)
            ;
            adaptor.addChild(root_0, REMOVE64_tree);


            pushFollow(FOLLOW_statementOptions_in_removeStatement1009);
            opts=statementOptions();

            state._fsp--;

            adaptor.addChild(root_0, opts.getTree());

            pushFollow(FOLLOW_keyIdentifier_in_removeStatement1015);
            key=keyIdentifier();

            state._fsp--;

            adaptor.addChild(root_0, key.getTree());

            // org/infinispan/cli/interpreter/IspnCliQL.g:155:57: (value= literal )?
            int alt14=2;
            switch ( input.LA(1) ) {
                case DOUBLELITERAL:
                case FALSE:
                case FLOATLITERAL:
                case INTLITERAL:
                case LONGLITERAL:
                case NULL:
                case STRINGLITERAL:
                case TRUE:
                case UUIDLITERAL:
                case 78:
                    {
                    alt14=1;
                    }
                    break;
            }

            switch (alt14) {
                case 1 :
                    // org/infinispan/cli/interpreter/IspnCliQL.g:155:58: value= literal
                    {
                    pushFollow(FOLLOW_literal_in_removeStatement1022);
                    value=literal();

                    state._fsp--;

                    adaptor.addChild(root_0, value.getTree());

                    }
                    break;

            }


            set65=(Token)input.LT(1);

            if ( input.LA(1)==EOL||input.LA(1)==74 ) {
                input.consume();
                state.errorRecovery=false;
            }
            else {
                MismatchedSetException mse = new MismatchedSetException(null,input);
                throw mse;
            }


             retval.stmt = new RemoveStatement((opts!=null?opts.options:null), (key!=null?key.key:null), (value!=null?value.o:null)); 

            }

            retval.stop = input.LT(-1);


            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "removeStatement"


    public static class replaceStatement_return extends ParserRuleReturnScope {
        public ReplaceStatement stmt;
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "replaceStatement"
    // org/infinispan/cli/interpreter/IspnCliQL.g:158:1: replaceStatement returns [ReplaceStatement stmt] : REPLACE opts= statementOptions key= keyIdentifier value1= literal (value2= literal )? (exp= expirationClause )? ( EOL | ';' ) !;
    public final IspnCliQLParser.replaceStatement_return replaceStatement() throws RecognitionException {
        IspnCliQLParser.replaceStatement_return retval = new IspnCliQLParser.replaceStatement_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token REPLACE66=null;
        Token set67=null;
        IspnCliQLParser.statementOptions_return opts =null;

        IspnCliQLParser.keyIdentifier_return key =null;

        IspnCliQLParser.literal_return value1 =null;

        IspnCliQLParser.literal_return value2 =null;

        IspnCliQLParser.expirationClause_return exp =null;


        Object REPLACE66_tree=null;
        Object set67_tree=null;

        try {
            // org/infinispan/cli/interpreter/IspnCliQL.g:159:4: ( REPLACE opts= statementOptions key= keyIdentifier value1= literal (value2= literal )? (exp= expirationClause )? ( EOL | ';' ) !)
            // org/infinispan/cli/interpreter/IspnCliQL.g:159:6: REPLACE opts= statementOptions key= keyIdentifier value1= literal (value2= literal )? (exp= expirationClause )? ( EOL | ';' ) !
            {
            REPLACE66=(Token)match(input,REPLACE,FOLLOW_REPLACE_in_replaceStatement1054); 
            REPLACE66_tree = 
            (Object)adaptor.create(REPLACE66)
            ;
            adaptor.addChild(root_0, REPLACE66_tree);


            pushFollow(FOLLOW_statementOptions_in_replaceStatement1060);
            opts=statementOptions();

            state._fsp--;

            adaptor.addChild(root_0, opts.getTree());

            pushFollow(FOLLOW_keyIdentifier_in_replaceStatement1066);
            key=keyIdentifier();

            state._fsp--;

            adaptor.addChild(root_0, key.getTree());

            pushFollow(FOLLOW_literal_in_replaceStatement1072);
            value1=literal();

            state._fsp--;

            adaptor.addChild(root_0, value1.getTree());

            // org/infinispan/cli/interpreter/IspnCliQL.g:159:75: (value2= literal )?
            int alt15=2;
            switch ( input.LA(1) ) {
                case DOUBLELITERAL:
                case FALSE:
                case FLOATLITERAL:
                case INTLITERAL:
                case LONGLITERAL:
                case NULL:
                case STRINGLITERAL:
                case TRUE:
                case UUIDLITERAL:
                case 78:
                    {
                    alt15=1;
                    }
                    break;
            }

            switch (alt15) {
                case 1 :
                    // org/infinispan/cli/interpreter/IspnCliQL.g:159:76: value2= literal
                    {
                    pushFollow(FOLLOW_literal_in_replaceStatement1079);
                    value2=literal();

                    state._fsp--;

                    adaptor.addChild(root_0, value2.getTree());

                    }
                    break;

            }


            // org/infinispan/cli/interpreter/IspnCliQL.g:159:95: (exp= expirationClause )?
            int alt16=2;
            switch ( input.LA(1) ) {
                case EXPIRES:
                    {
                    alt16=1;
                    }
                    break;
            }

            switch (alt16) {
                case 1 :
                    // org/infinispan/cli/interpreter/IspnCliQL.g:159:96: exp= expirationClause
                    {
                    pushFollow(FOLLOW_expirationClause_in_replaceStatement1088);
                    exp=expirationClause();

                    state._fsp--;

                    adaptor.addChild(root_0, exp.getTree());

                    }
                    break;

            }


            set67=(Token)input.LT(1);

            if ( input.LA(1)==EOL||input.LA(1)==74 ) {
                input.consume();
                state.errorRecovery=false;
            }
            else {
                MismatchedSetException mse = new MismatchedSetException(null,input);
                throw mse;
            }


             if ((value2!=null?value2.o:null)==null) retval.stmt = new ReplaceStatement((opts!=null?opts.options:null), (key!=null?key.key:null), (value1!=null?value1.o:null), (exp!=null?exp.exp:null)); else retval.stmt = new ReplaceStatement((opts!=null?opts.options:null), (key!=null?key.key:null), (value1!=null?value1.o:null), (value2!=null?value2.o:null), (exp!=null?exp.exp:null));

            }

            retval.stop = input.LT(-1);


            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "replaceStatement"


    public static class rolesStatement_return extends ParserRuleReturnScope {
        public RolesStatement stmt;
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "rolesStatement"
    // org/infinispan/cli/interpreter/IspnCliQL.g:162:1: rolesStatement returns [RolesStatement stmt] : ROLES (principalName= STRINGLITERAL )? ( EOL | ';' ) !;
    public final IspnCliQLParser.rolesStatement_return rolesStatement() throws RecognitionException {
        IspnCliQLParser.rolesStatement_return retval = new IspnCliQLParser.rolesStatement_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token principalName=null;
        Token ROLES68=null;
        Token set69=null;

        Object principalName_tree=null;
        Object ROLES68_tree=null;
        Object set69_tree=null;

        try {
            // org/infinispan/cli/interpreter/IspnCliQL.g:163:4: ( ROLES (principalName= STRINGLITERAL )? ( EOL | ';' ) !)
            // org/infinispan/cli/interpreter/IspnCliQL.g:163:6: ROLES (principalName= STRINGLITERAL )? ( EOL | ';' ) !
            {
            ROLES68=(Token)match(input,ROLES,FOLLOW_ROLES_in_rolesStatement1120); 
            ROLES68_tree = 
            (Object)adaptor.create(ROLES68)
            ;
            adaptor.addChild(root_0, ROLES68_tree);


            // org/infinispan/cli/interpreter/IspnCliQL.g:163:12: (principalName= STRINGLITERAL )?
            int alt17=2;
            switch ( input.LA(1) ) {
                case STRINGLITERAL:
                    {
                    alt17=1;
                    }
                    break;
            }

            switch (alt17) {
                case 1 :
                    // org/infinispan/cli/interpreter/IspnCliQL.g:163:13: principalName= STRINGLITERAL
                    {
                    principalName=(Token)match(input,STRINGLITERAL,FOLLOW_STRINGLITERAL_in_rolesStatement1127); 
                    principalName_tree = 
                    (Object)adaptor.create(principalName)
                    ;
                    adaptor.addChild(root_0, principalName_tree);


                    }
                    break;

            }


            set69=(Token)input.LT(1);

            if ( input.LA(1)==EOL||input.LA(1)==74 ) {
                input.consume();
                state.errorRecovery=false;
            }
            else {
                MismatchedSetException mse = new MismatchedSetException(null,input);
                throw mse;
            }


             retval.stmt = new RolesStatement((principalName!=null?principalName.getText():null)); 

            }

            retval.stop = input.LT(-1);


            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "rolesStatement"


    public static class rollbackTransactionStatement_return extends ParserRuleReturnScope {
        public RollbackTransactionStatement stmt;
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "rollbackTransactionStatement"
    // org/infinispan/cli/interpreter/IspnCliQL.g:166:1: rollbackTransactionStatement returns [RollbackTransactionStatement stmt] : ROLLBACK (cacheName= STRINGLITERAL )? ( EOL | ';' ) !;
    public final IspnCliQLParser.rollbackTransactionStatement_return rollbackTransactionStatement() throws RecognitionException {
        IspnCliQLParser.rollbackTransactionStatement_return retval = new IspnCliQLParser.rollbackTransactionStatement_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token cacheName=null;
        Token ROLLBACK70=null;
        Token set71=null;

        Object cacheName_tree=null;
        Object ROLLBACK70_tree=null;
        Object set71_tree=null;

        try {
            // org/infinispan/cli/interpreter/IspnCliQL.g:167:4: ( ROLLBACK (cacheName= STRINGLITERAL )? ( EOL | ';' ) !)
            // org/infinispan/cli/interpreter/IspnCliQL.g:167:6: ROLLBACK (cacheName= STRINGLITERAL )? ( EOL | ';' ) !
            {
            ROLLBACK70=(Token)match(input,ROLLBACK,FOLLOW_ROLLBACK_in_rollbackTransactionStatement1159); 
            ROLLBACK70_tree = 
            (Object)adaptor.create(ROLLBACK70)
            ;
            adaptor.addChild(root_0, ROLLBACK70_tree);


            // org/infinispan/cli/interpreter/IspnCliQL.g:167:15: (cacheName= STRINGLITERAL )?
            int alt18=2;
            switch ( input.LA(1) ) {
                case STRINGLITERAL:
                    {
                    alt18=1;
                    }
                    break;
            }

            switch (alt18) {
                case 1 :
                    // org/infinispan/cli/interpreter/IspnCliQL.g:167:16: cacheName= STRINGLITERAL
                    {
                    cacheName=(Token)match(input,STRINGLITERAL,FOLLOW_STRINGLITERAL_in_rollbackTransactionStatement1166); 
                    cacheName_tree = 
                    (Object)adaptor.create(cacheName)
                    ;
                    adaptor.addChild(root_0, cacheName_tree);


                    }
                    break;

            }


            set71=(Token)input.LT(1);

            if ( input.LA(1)==EOL||input.LA(1)==74 ) {
                input.consume();
                state.errorRecovery=false;
            }
            else {
                MismatchedSetException mse = new MismatchedSetException(null,input);
                throw mse;
            }


             retval.stmt = new RollbackTransactionStatement(unquote((cacheName!=null?cacheName.getText():null))); 

            }

            retval.stop = input.LT(-1);


            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "rollbackTransactionStatement"


    public static class siteStatement_return extends ParserRuleReturnScope {
        public SiteStatement stmt;
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "siteStatement"
    // org/infinispan/cli/interpreter/IspnCliQL.g:170:1: siteStatement returns [SiteStatement stmt] : SITE opts= statementOptions (site= siteIdentifier )? ( EOL | ';' ) !;
    public final IspnCliQLParser.siteStatement_return siteStatement() throws RecognitionException {
        IspnCliQLParser.siteStatement_return retval = new IspnCliQLParser.siteStatement_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token SITE72=null;
        Token set73=null;
        IspnCliQLParser.statementOptions_return opts =null;

        IspnCliQLParser.siteIdentifier_return site =null;


        Object SITE72_tree=null;
        Object set73_tree=null;

        try {
            // org/infinispan/cli/interpreter/IspnCliQL.g:171:4: ( SITE opts= statementOptions (site= siteIdentifier )? ( EOL | ';' ) !)
            // org/infinispan/cli/interpreter/IspnCliQL.g:171:6: SITE opts= statementOptions (site= siteIdentifier )? ( EOL | ';' ) !
            {
            SITE72=(Token)match(input,SITE,FOLLOW_SITE_in_siteStatement1201); 
            SITE72_tree = 
            (Object)adaptor.create(SITE72)
            ;
            adaptor.addChild(root_0, SITE72_tree);


            pushFollow(FOLLOW_statementOptions_in_siteStatement1207);
            opts=statementOptions();

            state._fsp--;

            adaptor.addChild(root_0, opts.getTree());

            // org/infinispan/cli/interpreter/IspnCliQL.g:171:35: (site= siteIdentifier )?
            int alt19=2;
            switch ( input.LA(1) ) {
                case STRINGLITERAL:
                    {
                    alt19=1;
                    }
                    break;
            }

            switch (alt19) {
                case 1 :
                    // org/infinispan/cli/interpreter/IspnCliQL.g:171:36: site= siteIdentifier
                    {
                    pushFollow(FOLLOW_siteIdentifier_in_siteStatement1214);
                    site=siteIdentifier();

                    state._fsp--;

                    adaptor.addChild(root_0, site.getTree());

                    }
                    break;

            }


            set73=(Token)input.LT(1);

            if ( input.LA(1)==EOL||input.LA(1)==74 ) {
                input.consume();
                state.errorRecovery=false;
            }
            else {
                MismatchedSetException mse = new MismatchedSetException(null,input);
                throw mse;
            }


             retval.stmt = new SiteStatement((opts!=null?opts.options:null), (site!=null?site.site:null)); 

            }

            retval.stop = input.LT(-1);


            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "siteStatement"


    public static class startBatchStatement_return extends ParserRuleReturnScope {
        public StartBatchStatement stmt;
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "startBatchStatement"
    // org/infinispan/cli/interpreter/IspnCliQL.g:174:1: startBatchStatement returns [StartBatchStatement stmt] : START (cacheName= STRINGLITERAL )? ( EOL | ';' ) !;
    public final IspnCliQLParser.startBatchStatement_return startBatchStatement() throws RecognitionException {
        IspnCliQLParser.startBatchStatement_return retval = new IspnCliQLParser.startBatchStatement_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token cacheName=null;
        Token START74=null;
        Token set75=null;

        Object cacheName_tree=null;
        Object START74_tree=null;
        Object set75_tree=null;

        try {
            // org/infinispan/cli/interpreter/IspnCliQL.g:175:4: ( START (cacheName= STRINGLITERAL )? ( EOL | ';' ) !)
            // org/infinispan/cli/interpreter/IspnCliQL.g:175:6: START (cacheName= STRINGLITERAL )? ( EOL | ';' ) !
            {
            START74=(Token)match(input,START,FOLLOW_START_in_startBatchStatement1246); 
            START74_tree = 
            (Object)adaptor.create(START74)
            ;
            adaptor.addChild(root_0, START74_tree);


            // org/infinispan/cli/interpreter/IspnCliQL.g:175:12: (cacheName= STRINGLITERAL )?
            int alt20=2;
            switch ( input.LA(1) ) {
                case STRINGLITERAL:
                    {
                    alt20=1;
                    }
                    break;
            }

            switch (alt20) {
                case 1 :
                    // org/infinispan/cli/interpreter/IspnCliQL.g:175:13: cacheName= STRINGLITERAL
                    {
                    cacheName=(Token)match(input,STRINGLITERAL,FOLLOW_STRINGLITERAL_in_startBatchStatement1253); 
                    cacheName_tree = 
                    (Object)adaptor.create(cacheName)
                    ;
                    adaptor.addChild(root_0, cacheName_tree);


                    }
                    break;

            }


            set75=(Token)input.LT(1);

            if ( input.LA(1)==EOL||input.LA(1)==74 ) {
                input.consume();
                state.errorRecovery=false;
            }
            else {
                MismatchedSetException mse = new MismatchedSetException(null,input);
                throw mse;
            }


             retval.stmt = new StartBatchStatement(unquote((cacheName!=null?cacheName.getText():null))); 

            }

            retval.stop = input.LT(-1);


            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "startBatchStatement"


    public static class statsStatement_return extends ParserRuleReturnScope {
        public StatsStatement stmt;
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "statsStatement"
    // org/infinispan/cli/interpreter/IspnCliQL.g:178:1: statsStatement returns [StatsStatement stmt] : STATS opts= statementOptions (cacheName= STRINGLITERAL )? ( EOL | ';' ) !;
    public final IspnCliQLParser.statsStatement_return statsStatement() throws RecognitionException {
        IspnCliQLParser.statsStatement_return retval = new IspnCliQLParser.statsStatement_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token cacheName=null;
        Token STATS76=null;
        Token set77=null;
        IspnCliQLParser.statementOptions_return opts =null;


        Object cacheName_tree=null;
        Object STATS76_tree=null;
        Object set77_tree=null;

        try {
            // org/infinispan/cli/interpreter/IspnCliQL.g:179:4: ( STATS opts= statementOptions (cacheName= STRINGLITERAL )? ( EOL | ';' ) !)
            // org/infinispan/cli/interpreter/IspnCliQL.g:179:6: STATS opts= statementOptions (cacheName= STRINGLITERAL )? ( EOL | ';' ) !
            {
            STATS76=(Token)match(input,STATS,FOLLOW_STATS_in_statsStatement1285); 
            STATS76_tree = 
            (Object)adaptor.create(STATS76)
            ;
            adaptor.addChild(root_0, STATS76_tree);


            pushFollow(FOLLOW_statementOptions_in_statsStatement1291);
            opts=statementOptions();

            state._fsp--;

            adaptor.addChild(root_0, opts.getTree());

            // org/infinispan/cli/interpreter/IspnCliQL.g:179:36: (cacheName= STRINGLITERAL )?
            int alt21=2;
            switch ( input.LA(1) ) {
                case STRINGLITERAL:
                    {
                    alt21=1;
                    }
                    break;
            }

            switch (alt21) {
                case 1 :
                    // org/infinispan/cli/interpreter/IspnCliQL.g:179:37: cacheName= STRINGLITERAL
                    {
                    cacheName=(Token)match(input,STRINGLITERAL,FOLLOW_STRINGLITERAL_in_statsStatement1298); 
                    cacheName_tree = 
                    (Object)adaptor.create(cacheName)
                    ;
                    adaptor.addChild(root_0, cacheName_tree);


                    }
                    break;

            }


            set77=(Token)input.LT(1);

            if ( input.LA(1)==EOL||input.LA(1)==74 ) {
                input.consume();
                state.errorRecovery=false;
            }
            else {
                MismatchedSetException mse = new MismatchedSetException(null,input);
                throw mse;
            }


             retval.stmt = new StatsStatement((opts!=null?opts.options:null), unquote((cacheName!=null?cacheName.getText():null))); 

            }

            retval.stop = input.LT(-1);


            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "statsStatement"


    public static class upgradeStatement_return extends ParserRuleReturnScope {
        public UpgradeStatement stmt;
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "upgradeStatement"
    // org/infinispan/cli/interpreter/IspnCliQL.g:182:1: upgradeStatement returns [UpgradeStatement stmt] : UPGRADE opts= statementOptions (cacheName= STRINGLITERAL )? ( EOL | ';' ) !;
    public final IspnCliQLParser.upgradeStatement_return upgradeStatement() throws RecognitionException {
        IspnCliQLParser.upgradeStatement_return retval = new IspnCliQLParser.upgradeStatement_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token cacheName=null;
        Token UPGRADE78=null;
        Token set79=null;
        IspnCliQLParser.statementOptions_return opts =null;


        Object cacheName_tree=null;
        Object UPGRADE78_tree=null;
        Object set79_tree=null;

        try {
            // org/infinispan/cli/interpreter/IspnCliQL.g:183:4: ( UPGRADE opts= statementOptions (cacheName= STRINGLITERAL )? ( EOL | ';' ) !)
            // org/infinispan/cli/interpreter/IspnCliQL.g:183:6: UPGRADE opts= statementOptions (cacheName= STRINGLITERAL )? ( EOL | ';' ) !
            {
            UPGRADE78=(Token)match(input,UPGRADE,FOLLOW_UPGRADE_in_upgradeStatement1330); 
            UPGRADE78_tree = 
            (Object)adaptor.create(UPGRADE78)
            ;
            adaptor.addChild(root_0, UPGRADE78_tree);


            pushFollow(FOLLOW_statementOptions_in_upgradeStatement1336);
            opts=statementOptions();

            state._fsp--;

            adaptor.addChild(root_0, opts.getTree());

            // org/infinispan/cli/interpreter/IspnCliQL.g:183:38: (cacheName= STRINGLITERAL )?
            int alt22=2;
            switch ( input.LA(1) ) {
                case STRINGLITERAL:
                    {
                    alt22=1;
                    }
                    break;
            }

            switch (alt22) {
                case 1 :
                    // org/infinispan/cli/interpreter/IspnCliQL.g:183:39: cacheName= STRINGLITERAL
                    {
                    cacheName=(Token)match(input,STRINGLITERAL,FOLLOW_STRINGLITERAL_in_upgradeStatement1343); 
                    cacheName_tree = 
                    (Object)adaptor.create(cacheName)
                    ;
                    adaptor.addChild(root_0, cacheName_tree);


                    }
                    break;

            }


            set79=(Token)input.LT(1);

            if ( input.LA(1)==EOL||input.LA(1)==74 ) {
                input.consume();
                state.errorRecovery=false;
            }
            else {
                MismatchedSetException mse = new MismatchedSetException(null,input);
                throw mse;
            }


             retval.stmt = new UpgradeStatement((opts!=null?opts.options:null), unquote((cacheName!=null?cacheName.getText():null))); 

            }

            retval.stop = input.LT(-1);


            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "upgradeStatement"


    public static class versionStatement_return extends ParserRuleReturnScope {
        public VersionStatement stmt;
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "versionStatement"
    // org/infinispan/cli/interpreter/IspnCliQL.g:186:1: versionStatement returns [VersionStatement stmt] : VERSION ( EOL | ';' ) !;
    public final IspnCliQLParser.versionStatement_return versionStatement() throws RecognitionException {
        IspnCliQLParser.versionStatement_return retval = new IspnCliQLParser.versionStatement_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token VERSION80=null;
        Token set81=null;

        Object VERSION80_tree=null;
        Object set81_tree=null;

        try {
            // org/infinispan/cli/interpreter/IspnCliQL.g:187:4: ( VERSION ( EOL | ';' ) !)
            // org/infinispan/cli/interpreter/IspnCliQL.g:187:6: VERSION ( EOL | ';' ) !
            {
            VERSION80=(Token)match(input,VERSION,FOLLOW_VERSION_in_versionStatement1375); 
            VERSION80_tree = 
            (Object)adaptor.create(VERSION80)
            ;
            adaptor.addChild(root_0, VERSION80_tree);


            set81=(Token)input.LT(1);

            if ( input.LA(1)==EOL||input.LA(1)==74 ) {
                input.consume();
                state.errorRecovery=false;
            }
            else {
                MismatchedSetException mse = new MismatchedSetException(null,input);
                throw mse;
            }


             retval.stmt = new VersionStatement(); 

            }

            retval.stop = input.LT(-1);


            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "versionStatement"


    public static class expirationClause_return extends ParserRuleReturnScope {
        public ExpirationData exp;
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "expirationClause"
    // org/infinispan/cli/interpreter/IspnCliQL.g:190:1: expirationClause returns [ExpirationData exp] : EXPIRES expires= timeLiteral ( MAXIDLE idle= timeLiteral )? ;
    public final IspnCliQLParser.expirationClause_return expirationClause() throws RecognitionException {
        IspnCliQLParser.expirationClause_return retval = new IspnCliQLParser.expirationClause_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token EXPIRES82=null;
        Token MAXIDLE83=null;
        IspnCliQLParser.timeLiteral_return expires =null;

        IspnCliQLParser.timeLiteral_return idle =null;


        Object EXPIRES82_tree=null;
        Object MAXIDLE83_tree=null;

        try {
            // org/infinispan/cli/interpreter/IspnCliQL.g:191:4: ( EXPIRES expires= timeLiteral ( MAXIDLE idle= timeLiteral )? )
            // org/infinispan/cli/interpreter/IspnCliQL.g:191:6: EXPIRES expires= timeLiteral ( MAXIDLE idle= timeLiteral )?
            {
            EXPIRES82=(Token)match(input,EXPIRES,FOLLOW_EXPIRES_in_expirationClause1405); 
            EXPIRES82_tree = 
            (Object)adaptor.create(EXPIRES82)
            ;
            adaptor.addChild(root_0, EXPIRES82_tree);


            pushFollow(FOLLOW_timeLiteral_in_expirationClause1411);
            expires=timeLiteral();

            state._fsp--;

            adaptor.addChild(root_0, expires.getTree());

            // org/infinispan/cli/interpreter/IspnCliQL.g:191:36: ( MAXIDLE idle= timeLiteral )?
            int alt23=2;
            switch ( input.LA(1) ) {
                case MAXIDLE:
                    {
                    alt23=1;
                    }
                    break;
            }

            switch (alt23) {
                case 1 :
                    // org/infinispan/cli/interpreter/IspnCliQL.g:191:37: MAXIDLE idle= timeLiteral
                    {
                    MAXIDLE83=(Token)match(input,MAXIDLE,FOLLOW_MAXIDLE_in_expirationClause1414); 
                    MAXIDLE83_tree = 
                    (Object)adaptor.create(MAXIDLE83)
                    ;
                    adaptor.addChild(root_0, MAXIDLE83_tree);


                    pushFollow(FOLLOW_timeLiteral_in_expirationClause1420);
                    idle=timeLiteral();

                    state._fsp--;

                    adaptor.addChild(root_0, idle.getTree());

                    }
                    break;

            }


             retval.exp = new ExpirationData((expires!=null?expires.l:null), (idle!=null?idle.l:null)); 

            }

            retval.stop = input.LT(-1);


            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "expirationClause"


    public static class keyIdentifier_return extends ParserRuleReturnScope {
        public KeyData key;
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "keyIdentifier"
    // org/infinispan/cli/interpreter/IspnCliQL.g:194:1: keyIdentifier returns [KeyData key] : ( STRINGLITERAL '.' literal | literal );
    public final IspnCliQLParser.keyIdentifier_return keyIdentifier() throws RecognitionException {
        IspnCliQLParser.keyIdentifier_return retval = new IspnCliQLParser.keyIdentifier_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token STRINGLITERAL84=null;
        Token char_literal85=null;
        IspnCliQLParser.literal_return literal86 =null;

        IspnCliQLParser.literal_return literal87 =null;


        Object STRINGLITERAL84_tree=null;
        Object char_literal85_tree=null;

        try {
            // org/infinispan/cli/interpreter/IspnCliQL.g:195:4: ( STRINGLITERAL '.' literal | literal )
            int alt24=2;
            switch ( input.LA(1) ) {
            case STRINGLITERAL:
                {
                switch ( input.LA(2) ) {
                case 72:
                    {
                    alt24=1;
                    }
                    break;
                case DOUBLELITERAL:
                case EOL:
                case FALSE:
                case FLOATLITERAL:
                case INTLITERAL:
                case LONGLITERAL:
                case NULL:
                case STRINGLITERAL:
                case TRUE:
                case UUIDLITERAL:
                case 74:
                case 78:
                    {
                    alt24=2;
                    }
                    break;
                default:
                    NoViableAltException nvae =
                        new NoViableAltException("", 24, 1, input);

                    throw nvae;

                }

                }
                break;
            case DOUBLELITERAL:
            case FALSE:
            case FLOATLITERAL:
            case INTLITERAL:
            case LONGLITERAL:
            case NULL:
            case TRUE:
            case UUIDLITERAL:
            case 78:
                {
                alt24=2;
                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 24, 0, input);

                throw nvae;

            }

            switch (alt24) {
                case 1 :
                    // org/infinispan/cli/interpreter/IspnCliQL.g:195:6: STRINGLITERAL '.' literal
                    {
                    STRINGLITERAL84=(Token)match(input,STRINGLITERAL,FOLLOW_STRINGLITERAL_in_keyIdentifier1443); 
                    STRINGLITERAL84_tree = 
                    (Object)adaptor.create(STRINGLITERAL84)
                    ;
                    adaptor.addChild(root_0, STRINGLITERAL84_tree);


                    char_literal85=(Token)match(input,72,FOLLOW_72_in_keyIdentifier1445); 
                    char_literal85_tree = 
                    (Object)adaptor.create(char_literal85)
                    ;
                    adaptor.addChild(root_0, char_literal85_tree);


                    pushFollow(FOLLOW_literal_in_keyIdentifier1447);
                    literal86=literal();

                    state._fsp--;

                    adaptor.addChild(root_0, literal86.getTree());

                     retval.key = new KeyData(unquote((STRINGLITERAL84!=null?STRINGLITERAL84.getText():null)), (literal86!=null?literal86.o:null)); 

                    }
                    break;
                case 2 :
                    // org/infinispan/cli/interpreter/IspnCliQL.g:196:6: literal
                    {
                    pushFollow(FOLLOW_literal_in_keyIdentifier1456);
                    literal87=literal();

                    state._fsp--;

                    adaptor.addChild(root_0, literal87.getTree());

                     retval.key = new KeyData((literal87!=null?literal87.o:null)); 

                    }
                    break;

            }
            retval.stop = input.LT(-1);


            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "keyIdentifier"


    public static class siteIdentifier_return extends ParserRuleReturnScope {
        public SiteData site;
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "siteIdentifier"
    // org/infinispan/cli/interpreter/IspnCliQL.g:199:1: siteIdentifier returns [SiteData site] : (cacheName= STRINGLITERAL '.' siteName= STRINGLITERAL |siteName= STRINGLITERAL );
    public final IspnCliQLParser.siteIdentifier_return siteIdentifier() throws RecognitionException {
        IspnCliQLParser.siteIdentifier_return retval = new IspnCliQLParser.siteIdentifier_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token cacheName=null;
        Token siteName=null;
        Token char_literal88=null;

        Object cacheName_tree=null;
        Object siteName_tree=null;
        Object char_literal88_tree=null;

        try {
            // org/infinispan/cli/interpreter/IspnCliQL.g:200:4: (cacheName= STRINGLITERAL '.' siteName= STRINGLITERAL |siteName= STRINGLITERAL )
            int alt25=2;
            switch ( input.LA(1) ) {
            case STRINGLITERAL:
                {
                switch ( input.LA(2) ) {
                case 72:
                    {
                    alt25=1;
                    }
                    break;
                case EOL:
                case 74:
                    {
                    alt25=2;
                    }
                    break;
                default:
                    NoViableAltException nvae =
                        new NoViableAltException("", 25, 1, input);

                    throw nvae;

                }

                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 25, 0, input);

                throw nvae;

            }

            switch (alt25) {
                case 1 :
                    // org/infinispan/cli/interpreter/IspnCliQL.g:200:6: cacheName= STRINGLITERAL '.' siteName= STRINGLITERAL
                    {
                    cacheName=(Token)match(input,STRINGLITERAL,FOLLOW_STRINGLITERAL_in_siteIdentifier1481); 
                    cacheName_tree = 
                    (Object)adaptor.create(cacheName)
                    ;
                    adaptor.addChild(root_0, cacheName_tree);


                    char_literal88=(Token)match(input,72,FOLLOW_72_in_siteIdentifier1483); 
                    char_literal88_tree = 
                    (Object)adaptor.create(char_literal88)
                    ;
                    adaptor.addChild(root_0, char_literal88_tree);


                    siteName=(Token)match(input,STRINGLITERAL,FOLLOW_STRINGLITERAL_in_siteIdentifier1489); 
                    siteName_tree = 
                    (Object)adaptor.create(siteName)
                    ;
                    adaptor.addChild(root_0, siteName_tree);


                     retval.site = new SiteData(unquote((cacheName!=null?cacheName.getText():null)), (siteName!=null?siteName.getText():null)); 

                    }
                    break;
                case 2 :
                    // org/infinispan/cli/interpreter/IspnCliQL.g:201:6: siteName= STRINGLITERAL
                    {
                    siteName=(Token)match(input,STRINGLITERAL,FOLLOW_STRINGLITERAL_in_siteIdentifier1502); 
                    siteName_tree = 
                    (Object)adaptor.create(siteName)
                    ;
                    adaptor.addChild(root_0, siteName_tree);


                     retval.site = new SiteData((siteName!=null?siteName.getText():null)); 

                    }
                    break;

            }
            retval.stop = input.LT(-1);


            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "siteIdentifier"


    public static class statementOptions_return extends ParserRuleReturnScope {
        public List<Option> options;
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "statementOptions"
    // org/infinispan/cli/interpreter/IspnCliQL.g:204:1: statementOptions returns [List<Option> options] : ( statementOption )* ;
    public final IspnCliQLParser.statementOptions_return statementOptions() throws RecognitionException {
        IspnCliQLParser.statementOptions_return retval = new IspnCliQLParser.statementOptions_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        IspnCliQLParser.statementOption_return statementOption89 =null;




           retval.options = new ArrayList<Option>();

        try {
            // org/infinispan/cli/interpreter/IspnCliQL.g:208:4: ( ( statementOption )* )
            // org/infinispan/cli/interpreter/IspnCliQL.g:208:6: ( statementOption )*
            {
            // org/infinispan/cli/interpreter/IspnCliQL.g:208:6: ( statementOption )*
            loop26:
            do {
                int alt26=2;
                switch ( input.LA(1) ) {
                case 71:
                    {
                    alt26=1;
                    }
                    break;

                }

                switch (alt26) {
            	case 1 :
            	    // org/infinispan/cli/interpreter/IspnCliQL.g:208:8: statementOption
            	    {
            	    pushFollow(FOLLOW_statementOption_in_statementOptions1530);
            	    statementOption89=statementOption();

            	    state._fsp--;

            	    adaptor.addChild(root_0, statementOption89.getTree());

            	     retval.options.add((statementOption89!=null?statementOption89.option:null)); 

            	    }
            	    break;

            	default :
            	    break loop26;
                }
            } while (true);


            }

            retval.stop = input.LT(-1);


            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "statementOptions"


    public static class statementOption_return extends ParserRuleReturnScope {
        public Option option;
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "statementOption"
    // org/infinispan/cli/interpreter/IspnCliQL.g:211:1: statementOption returns [Option option] : '--' optionName= STRINGLITERAL ( '=' optionParameter= STRINGLITERAL )? ;
    public final IspnCliQLParser.statementOption_return statementOption() throws RecognitionException {
        IspnCliQLParser.statementOption_return retval = new IspnCliQLParser.statementOption_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token optionName=null;
        Token optionParameter=null;
        Token string_literal90=null;
        Token char_literal91=null;

        Object optionName_tree=null;
        Object optionParameter_tree=null;
        Object string_literal90_tree=null;
        Object char_literal91_tree=null;

        try {
            // org/infinispan/cli/interpreter/IspnCliQL.g:212:4: ( '--' optionName= STRINGLITERAL ( '=' optionParameter= STRINGLITERAL )? )
            // org/infinispan/cli/interpreter/IspnCliQL.g:212:6: '--' optionName= STRINGLITERAL ( '=' optionParameter= STRINGLITERAL )?
            {
            string_literal90=(Token)match(input,71,FOLLOW_71_in_statementOption1554); 
            string_literal90_tree = 
            (Object)adaptor.create(string_literal90)
            ;
            adaptor.addChild(root_0, string_literal90_tree);


            optionName=(Token)match(input,STRINGLITERAL,FOLLOW_STRINGLITERAL_in_statementOption1560); 
            optionName_tree = 
            (Object)adaptor.create(optionName)
            ;
            adaptor.addChild(root_0, optionName_tree);


            // org/infinispan/cli/interpreter/IspnCliQL.g:212:38: ( '=' optionParameter= STRINGLITERAL )?
            int alt27=2;
            switch ( input.LA(1) ) {
                case 75:
                    {
                    alt27=1;
                    }
                    break;
            }

            switch (alt27) {
                case 1 :
                    // org/infinispan/cli/interpreter/IspnCliQL.g:212:39: '=' optionParameter= STRINGLITERAL
                    {
                    char_literal91=(Token)match(input,75,FOLLOW_75_in_statementOption1563); 
                    char_literal91_tree = 
                    (Object)adaptor.create(char_literal91)
                    ;
                    adaptor.addChild(root_0, char_literal91_tree);


                    optionParameter=(Token)match(input,STRINGLITERAL,FOLLOW_STRINGLITERAL_in_statementOption1569); 
                    optionParameter_tree = 
                    (Object)adaptor.create(optionParameter)
                    ;
                    adaptor.addChild(root_0, optionParameter_tree);


                    }
                    break;

            }


             retval.option = new Option(unquote((optionName!=null?optionName.getText():null)), unquote((optionParameter!=null?optionParameter.getText():null))); 

            }

            retval.stop = input.LT(-1);


            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "statementOption"


    public static class literal_return extends ParserRuleReturnScope {
        public Object o;
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "literal"
    // org/infinispan/cli/interpreter/IspnCliQL.g:215:1: literal returns [Object o] : ( INTLITERAL | LONGLITERAL | FLOATLITERAL | DOUBLELITERAL | NULL | STRINGLITERAL | UUIDLITERAL |b= ( TRUE | FALSE ) | jsonLiteral );
    public final IspnCliQLParser.literal_return literal() throws RecognitionException {
        IspnCliQLParser.literal_return retval = new IspnCliQLParser.literal_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token b=null;
        Token INTLITERAL92=null;
        Token LONGLITERAL93=null;
        Token FLOATLITERAL94=null;
        Token DOUBLELITERAL95=null;
        Token NULL96=null;
        Token STRINGLITERAL97=null;
        Token UUIDLITERAL98=null;
        IspnCliQLParser.jsonLiteral_return jsonLiteral99 =null;


        Object b_tree=null;
        Object INTLITERAL92_tree=null;
        Object LONGLITERAL93_tree=null;
        Object FLOATLITERAL94_tree=null;
        Object DOUBLELITERAL95_tree=null;
        Object NULL96_tree=null;
        Object STRINGLITERAL97_tree=null;
        Object UUIDLITERAL98_tree=null;

        try {
            // org/infinispan/cli/interpreter/IspnCliQL.g:216:4: ( INTLITERAL | LONGLITERAL | FLOATLITERAL | DOUBLELITERAL | NULL | STRINGLITERAL | UUIDLITERAL |b= ( TRUE | FALSE ) | jsonLiteral )
            int alt28=9;
            switch ( input.LA(1) ) {
            case INTLITERAL:
                {
                alt28=1;
                }
                break;
            case LONGLITERAL:
                {
                alt28=2;
                }
                break;
            case FLOATLITERAL:
                {
                alt28=3;
                }
                break;
            case DOUBLELITERAL:
                {
                alt28=4;
                }
                break;
            case NULL:
                {
                alt28=5;
                }
                break;
            case STRINGLITERAL:
                {
                alt28=6;
                }
                break;
            case UUIDLITERAL:
                {
                alt28=7;
                }
                break;
            case FALSE:
            case TRUE:
                {
                alt28=8;
                }
                break;
            case 78:
                {
                alt28=9;
                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 28, 0, input);

                throw nvae;

            }

            switch (alt28) {
                case 1 :
                    // org/infinispan/cli/interpreter/IspnCliQL.g:216:6: INTLITERAL
                    {
                    INTLITERAL92=(Token)match(input,INTLITERAL,FOLLOW_INTLITERAL_in_literal1592); 
                    INTLITERAL92_tree = 
                    (Object)adaptor.create(INTLITERAL92)
                    ;
                    adaptor.addChild(root_0, INTLITERAL92_tree);


                     retval.o = Integer.valueOf((INTLITERAL92!=null?INTLITERAL92.getText():null)); 

                    }
                    break;
                case 2 :
                    // org/infinispan/cli/interpreter/IspnCliQL.g:217:6: LONGLITERAL
                    {
                    LONGLITERAL93=(Token)match(input,LONGLITERAL,FOLLOW_LONGLITERAL_in_literal1601); 
                    LONGLITERAL93_tree = 
                    (Object)adaptor.create(LONGLITERAL93)
                    ;
                    adaptor.addChild(root_0, LONGLITERAL93_tree);


                     retval.o = Long.valueOf((LONGLITERAL93!=null?LONGLITERAL93.getText():null).substring(0, (LONGLITERAL93!=null?LONGLITERAL93.getText():null).length()-1)); 

                    }
                    break;
                case 3 :
                    // org/infinispan/cli/interpreter/IspnCliQL.g:218:6: FLOATLITERAL
                    {
                    FLOATLITERAL94=(Token)match(input,FLOATLITERAL,FOLLOW_FLOATLITERAL_in_literal1610); 
                    FLOATLITERAL94_tree = 
                    (Object)adaptor.create(FLOATLITERAL94)
                    ;
                    adaptor.addChild(root_0, FLOATLITERAL94_tree);


                     retval.o = Float.valueOf((FLOATLITERAL94!=null?FLOATLITERAL94.getText():null)); 

                    }
                    break;
                case 4 :
                    // org/infinispan/cli/interpreter/IspnCliQL.g:219:6: DOUBLELITERAL
                    {
                    DOUBLELITERAL95=(Token)match(input,DOUBLELITERAL,FOLLOW_DOUBLELITERAL_in_literal1619); 
                    DOUBLELITERAL95_tree = 
                    (Object)adaptor.create(DOUBLELITERAL95)
                    ;
                    adaptor.addChild(root_0, DOUBLELITERAL95_tree);


                     retval.o = Double.valueOf((DOUBLELITERAL95!=null?DOUBLELITERAL95.getText():null)); 

                    }
                    break;
                case 5 :
                    // org/infinispan/cli/interpreter/IspnCliQL.g:220:6: NULL
                    {
                    NULL96=(Token)match(input,NULL,FOLLOW_NULL_in_literal1628); 
                    NULL96_tree = 
                    (Object)adaptor.create(NULL96)
                    ;
                    adaptor.addChild(root_0, NULL96_tree);


                     retval.o = null; 

                    }
                    break;
                case 6 :
                    // org/infinispan/cli/interpreter/IspnCliQL.g:221:6: STRINGLITERAL
                    {
                    STRINGLITERAL97=(Token)match(input,STRINGLITERAL,FOLLOW_STRINGLITERAL_in_literal1637); 
                    STRINGLITERAL97_tree = 
                    (Object)adaptor.create(STRINGLITERAL97)
                    ;
                    adaptor.addChild(root_0, STRINGLITERAL97_tree);


                     retval.o = unquote((STRINGLITERAL97!=null?STRINGLITERAL97.getText():null)); 

                    }
                    break;
                case 7 :
                    // org/infinispan/cli/interpreter/IspnCliQL.g:222:6: UUIDLITERAL
                    {
                    UUIDLITERAL98=(Token)match(input,UUIDLITERAL,FOLLOW_UUIDLITERAL_in_literal1646); 
                    UUIDLITERAL98_tree = 
                    (Object)adaptor.create(UUIDLITERAL98)
                    ;
                    adaptor.addChild(root_0, UUIDLITERAL98_tree);


                     retval.o = UUID.fromString((UUIDLITERAL98!=null?UUIDLITERAL98.getText():null)); 

                    }
                    break;
                case 8 :
                    // org/infinispan/cli/interpreter/IspnCliQL.g:223:6: b= ( TRUE | FALSE )
                    {
                    b=(Token)input.LT(1);

                    if ( input.LA(1)==FALSE||input.LA(1)==TRUE ) {
                        input.consume();
                        adaptor.addChild(root_0, 
                        (Object)adaptor.create(b)
                        );
                        state.errorRecovery=false;
                    }
                    else {
                        MismatchedSetException mse = new MismatchedSetException(null,input);
                        throw mse;
                    }


                     retval.o = Boolean.valueOf((b!=null?b.getText():null)); 

                    }
                    break;
                case 9 :
                    // org/infinispan/cli/interpreter/IspnCliQL.g:224:6: jsonLiteral
                    {
                    pushFollow(FOLLOW_jsonLiteral_in_literal1676);
                    jsonLiteral99=jsonLiteral();

                    state._fsp--;

                    adaptor.addChild(root_0, jsonLiteral99.getTree());


                           retval.o = jsonMapper.readValue((jsonLiteral99!=null?input.toString(jsonLiteral99.start,jsonLiteral99.stop):null), Object.class);
                       

                    }
                    break;

            }
            retval.stop = input.LT(-1);


            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

        }
        catch (JsonProcessingException jpe) {
             throw new RecognitionException(input); 
        }
        catch (IOException ioe) {
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "literal"


    public static class timeLiteral_return extends ParserRuleReturnScope {
        public Long l;
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "timeLiteral"
    // org/infinispan/cli/interpreter/IspnCliQL.g:231:1: timeLiteral returns [Long l] : TIMELITERAL ;
    public final IspnCliQLParser.timeLiteral_return timeLiteral() throws RecognitionException {
        IspnCliQLParser.timeLiteral_return retval = new IspnCliQLParser.timeLiteral_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token TIMELITERAL100=null;

        Object TIMELITERAL100_tree=null;

        try {
            // org/infinispan/cli/interpreter/IspnCliQL.g:232:4: ( TIMELITERAL )
            // org/infinispan/cli/interpreter/IspnCliQL.g:232:6: TIMELITERAL
            {
            TIMELITERAL100=(Token)match(input,TIMELITERAL,FOLLOW_TIMELITERAL_in_timeLiteral1713); 
            TIMELITERAL100_tree = 
            (Object)adaptor.create(TIMELITERAL100)
            ;
            adaptor.addChild(root_0, TIMELITERAL100_tree);


             retval.l = millis((TIMELITERAL100!=null?TIMELITERAL100.getText():null)); 

            }

            retval.stop = input.LT(-1);


            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "timeLiteral"


    public static class jsonLiteral_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "jsonLiteral"
    // org/infinispan/cli/interpreter/IspnCliQL.g:235:1: jsonLiteral : '{' jsonPair ( ',' jsonPair )* '}' ;
    public final IspnCliQLParser.jsonLiteral_return jsonLiteral() throws RecognitionException {
        IspnCliQLParser.jsonLiteral_return retval = new IspnCliQLParser.jsonLiteral_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token char_literal101=null;
        Token char_literal103=null;
        Token char_literal105=null;
        IspnCliQLParser.jsonPair_return jsonPair102 =null;

        IspnCliQLParser.jsonPair_return jsonPair104 =null;


        Object char_literal101_tree=null;
        Object char_literal103_tree=null;
        Object char_literal105_tree=null;

        try {
            // org/infinispan/cli/interpreter/IspnCliQL.g:236:4: ( '{' jsonPair ( ',' jsonPair )* '}' )
            // org/infinispan/cli/interpreter/IspnCliQL.g:236:6: '{' jsonPair ( ',' jsonPair )* '}'
            {
            char_literal101=(Token)match(input,78,FOLLOW_78_in_jsonLiteral1730); 
            char_literal101_tree = 
            (Object)adaptor.create(char_literal101)
            ;
            adaptor.addChild(root_0, char_literal101_tree);


            pushFollow(FOLLOW_jsonPair_in_jsonLiteral1732);
            jsonPair102=jsonPair();

            state._fsp--;

            adaptor.addChild(root_0, jsonPair102.getTree());

            // org/infinispan/cli/interpreter/IspnCliQL.g:236:19: ( ',' jsonPair )*
            loop29:
            do {
                int alt29=2;
                switch ( input.LA(1) ) {
                case 70:
                    {
                    alt29=1;
                    }
                    break;

                }

                switch (alt29) {
            	case 1 :
            	    // org/infinispan/cli/interpreter/IspnCliQL.g:236:20: ',' jsonPair
            	    {
            	    char_literal103=(Token)match(input,70,FOLLOW_70_in_jsonLiteral1735); 
            	    char_literal103_tree = 
            	    (Object)adaptor.create(char_literal103)
            	    ;
            	    adaptor.addChild(root_0, char_literal103_tree);


            	    pushFollow(FOLLOW_jsonPair_in_jsonLiteral1737);
            	    jsonPair104=jsonPair();

            	    state._fsp--;

            	    adaptor.addChild(root_0, jsonPair104.getTree());

            	    }
            	    break;

            	default :
            	    break loop29;
                }
            } while (true);


            char_literal105=(Token)match(input,79,FOLLOW_79_in_jsonLiteral1741); 
            char_literal105_tree = 
            (Object)adaptor.create(char_literal105)
            ;
            adaptor.addChild(root_0, char_literal105_tree);


            }

            retval.stop = input.LT(-1);


            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "jsonLiteral"


    public static class jsonPair_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "jsonPair"
    // org/infinispan/cli/interpreter/IspnCliQL.g:239:1: jsonPair : jsonString ':' jsonValue ;
    public final IspnCliQLParser.jsonPair_return jsonPair() throws RecognitionException {
        IspnCliQLParser.jsonPair_return retval = new IspnCliQLParser.jsonPair_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token char_literal107=null;
        IspnCliQLParser.jsonString_return jsonString106 =null;

        IspnCliQLParser.jsonValue_return jsonValue108 =null;


        Object char_literal107_tree=null;

        try {
            // org/infinispan/cli/interpreter/IspnCliQL.g:240:4: ( jsonString ':' jsonValue )
            // org/infinispan/cli/interpreter/IspnCliQL.g:240:6: jsonString ':' jsonValue
            {
            pushFollow(FOLLOW_jsonString_in_jsonPair1756);
            jsonString106=jsonString();

            state._fsp--;

            adaptor.addChild(root_0, jsonString106.getTree());

            char_literal107=(Token)match(input,73,FOLLOW_73_in_jsonPair1758); 
            char_literal107_tree = 
            (Object)adaptor.create(char_literal107)
            ;
            adaptor.addChild(root_0, char_literal107_tree);


            pushFollow(FOLLOW_jsonValue_in_jsonPair1760);
            jsonValue108=jsonValue();

            state._fsp--;

            adaptor.addChild(root_0, jsonValue108.getTree());

            }

            retval.stop = input.LT(-1);


            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "jsonPair"


    public static class jsonString_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "jsonString"
    // org/infinispan/cli/interpreter/IspnCliQL.g:243:1: jsonString : STRINGLITERAL ;
    public final IspnCliQLParser.jsonString_return jsonString() throws RecognitionException {
        IspnCliQLParser.jsonString_return retval = new IspnCliQLParser.jsonString_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token STRINGLITERAL109=null;

        Object STRINGLITERAL109_tree=null;

        try {
            // org/infinispan/cli/interpreter/IspnCliQL.g:244:4: ( STRINGLITERAL )
            // org/infinispan/cli/interpreter/IspnCliQL.g:244:6: STRINGLITERAL
            {
            STRINGLITERAL109=(Token)match(input,STRINGLITERAL,FOLLOW_STRINGLITERAL_in_jsonString1775); 
            STRINGLITERAL109_tree = 
            (Object)adaptor.create(STRINGLITERAL109)
            ;
            adaptor.addChild(root_0, STRINGLITERAL109_tree);


            }

            retval.stop = input.LT(-1);


            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "jsonString"


    public static class jsonValue_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "jsonValue"
    // org/infinispan/cli/interpreter/IspnCliQL.g:247:1: jsonValue : ( jsonLiteral | jsonArray | INTLITERAL | DOUBLELITERAL | TRUE | FALSE | NULL | jsonString );
    public final IspnCliQLParser.jsonValue_return jsonValue() throws RecognitionException {
        IspnCliQLParser.jsonValue_return retval = new IspnCliQLParser.jsonValue_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token INTLITERAL112=null;
        Token DOUBLELITERAL113=null;
        Token TRUE114=null;
        Token FALSE115=null;
        Token NULL116=null;
        IspnCliQLParser.jsonLiteral_return jsonLiteral110 =null;

        IspnCliQLParser.jsonArray_return jsonArray111 =null;

        IspnCliQLParser.jsonString_return jsonString117 =null;


        Object INTLITERAL112_tree=null;
        Object DOUBLELITERAL113_tree=null;
        Object TRUE114_tree=null;
        Object FALSE115_tree=null;
        Object NULL116_tree=null;

        try {
            // org/infinispan/cli/interpreter/IspnCliQL.g:248:4: ( jsonLiteral | jsonArray | INTLITERAL | DOUBLELITERAL | TRUE | FALSE | NULL | jsonString )
            int alt30=8;
            switch ( input.LA(1) ) {
            case 78:
                {
                alt30=1;
                }
                break;
            case 76:
                {
                alt30=2;
                }
                break;
            case INTLITERAL:
                {
                alt30=3;
                }
                break;
            case DOUBLELITERAL:
                {
                alt30=4;
                }
                break;
            case TRUE:
                {
                alt30=5;
                }
                break;
            case FALSE:
                {
                alt30=6;
                }
                break;
            case NULL:
                {
                alt30=7;
                }
                break;
            case STRINGLITERAL:
                {
                alt30=8;
                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 30, 0, input);

                throw nvae;

            }

            switch (alt30) {
                case 1 :
                    // org/infinispan/cli/interpreter/IspnCliQL.g:248:6: jsonLiteral
                    {
                    pushFollow(FOLLOW_jsonLiteral_in_jsonValue1790);
                    jsonLiteral110=jsonLiteral();

                    state._fsp--;

                    adaptor.addChild(root_0, jsonLiteral110.getTree());

                    }
                    break;
                case 2 :
                    // org/infinispan/cli/interpreter/IspnCliQL.g:249:6: jsonArray
                    {
                    pushFollow(FOLLOW_jsonArray_in_jsonValue1797);
                    jsonArray111=jsonArray();

                    state._fsp--;

                    adaptor.addChild(root_0, jsonArray111.getTree());

                    }
                    break;
                case 3 :
                    // org/infinispan/cli/interpreter/IspnCliQL.g:250:6: INTLITERAL
                    {
                    INTLITERAL112=(Token)match(input,INTLITERAL,FOLLOW_INTLITERAL_in_jsonValue1804); 
                    INTLITERAL112_tree = 
                    (Object)adaptor.create(INTLITERAL112)
                    ;
                    adaptor.addChild(root_0, INTLITERAL112_tree);


                    }
                    break;
                case 4 :
                    // org/infinispan/cli/interpreter/IspnCliQL.g:251:6: DOUBLELITERAL
                    {
                    DOUBLELITERAL113=(Token)match(input,DOUBLELITERAL,FOLLOW_DOUBLELITERAL_in_jsonValue1811); 
                    DOUBLELITERAL113_tree = 
                    (Object)adaptor.create(DOUBLELITERAL113)
                    ;
                    adaptor.addChild(root_0, DOUBLELITERAL113_tree);


                    }
                    break;
                case 5 :
                    // org/infinispan/cli/interpreter/IspnCliQL.g:252:6: TRUE
                    {
                    TRUE114=(Token)match(input,TRUE,FOLLOW_TRUE_in_jsonValue1818); 
                    TRUE114_tree = 
                    (Object)adaptor.create(TRUE114)
                    ;
                    adaptor.addChild(root_0, TRUE114_tree);


                    }
                    break;
                case 6 :
                    // org/infinispan/cli/interpreter/IspnCliQL.g:252:13: FALSE
                    {
                    FALSE115=(Token)match(input,FALSE,FOLLOW_FALSE_in_jsonValue1822); 
                    FALSE115_tree = 
                    (Object)adaptor.create(FALSE115)
                    ;
                    adaptor.addChild(root_0, FALSE115_tree);


                    }
                    break;
                case 7 :
                    // org/infinispan/cli/interpreter/IspnCliQL.g:253:6: NULL
                    {
                    NULL116=(Token)match(input,NULL,FOLLOW_NULL_in_jsonValue1829); 
                    NULL116_tree = 
                    (Object)adaptor.create(NULL116)
                    ;
                    adaptor.addChild(root_0, NULL116_tree);


                    }
                    break;
                case 8 :
                    // org/infinispan/cli/interpreter/IspnCliQL.g:254:6: jsonString
                    {
                    pushFollow(FOLLOW_jsonString_in_jsonValue1836);
                    jsonString117=jsonString();

                    state._fsp--;

                    adaptor.addChild(root_0, jsonString117.getTree());

                    }
                    break;

            }
            retval.stop = input.LT(-1);


            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "jsonValue"


    public static class jsonArray_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "jsonArray"
    // org/infinispan/cli/interpreter/IspnCliQL.g:257:1: jsonArray : '[' jsonValue ( ',' jsonValue )* ']' ;
    public final IspnCliQLParser.jsonArray_return jsonArray() throws RecognitionException {
        IspnCliQLParser.jsonArray_return retval = new IspnCliQLParser.jsonArray_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token char_literal118=null;
        Token char_literal120=null;
        Token char_literal122=null;
        IspnCliQLParser.jsonValue_return jsonValue119 =null;

        IspnCliQLParser.jsonValue_return jsonValue121 =null;


        Object char_literal118_tree=null;
        Object char_literal120_tree=null;
        Object char_literal122_tree=null;

        try {
            // org/infinispan/cli/interpreter/IspnCliQL.g:258:4: ( '[' jsonValue ( ',' jsonValue )* ']' )
            // org/infinispan/cli/interpreter/IspnCliQL.g:258:6: '[' jsonValue ( ',' jsonValue )* ']'
            {
            char_literal118=(Token)match(input,76,FOLLOW_76_in_jsonArray1851); 
            char_literal118_tree = 
            (Object)adaptor.create(char_literal118)
            ;
            adaptor.addChild(root_0, char_literal118_tree);


            pushFollow(FOLLOW_jsonValue_in_jsonArray1853);
            jsonValue119=jsonValue();

            state._fsp--;

            adaptor.addChild(root_0, jsonValue119.getTree());

            // org/infinispan/cli/interpreter/IspnCliQL.g:258:20: ( ',' jsonValue )*
            loop31:
            do {
                int alt31=2;
                switch ( input.LA(1) ) {
                case 70:
                    {
                    alt31=1;
                    }
                    break;

                }

                switch (alt31) {
            	case 1 :
            	    // org/infinispan/cli/interpreter/IspnCliQL.g:258:21: ',' jsonValue
            	    {
            	    char_literal120=(Token)match(input,70,FOLLOW_70_in_jsonArray1856); 
            	    char_literal120_tree = 
            	    (Object)adaptor.create(char_literal120)
            	    ;
            	    adaptor.addChild(root_0, char_literal120_tree);


            	    pushFollow(FOLLOW_jsonValue_in_jsonArray1858);
            	    jsonValue121=jsonValue();

            	    state._fsp--;

            	    adaptor.addChild(root_0, jsonValue121.getTree());

            	    }
            	    break;

            	default :
            	    break loop31;
                }
            } while (true);


            char_literal122=(Token)match(input,77,FOLLOW_77_in_jsonArray1862); 
            char_literal122_tree = 
            (Object)adaptor.create(char_literal122)
            ;
            adaptor.addChild(root_0, char_literal122_tree);


            }

            retval.stop = input.LT(-1);


            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "jsonArray"

    // Delegated rules


 

    public static final BitSet FOLLOW_statement_in_statements70 = new BitSet(new long[]{0x80FF8088C0784F90L,0x0000000000000010L});
    public static final BitSet FOLLOW_EOL_in_statements74 = new BitSet(new long[]{0x80FF8088C0784F90L,0x0000000000000010L});
    public static final BitSet FOLLOW_EOF_in_statements79 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_abortBatchStatement_in_statement98 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_beginTransactionStatement_in_statement107 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_cacheStatement_in_statement116 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_clearCacheStatement_in_statement125 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_commitTransactionStatement_in_statement134 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_createStatement_in_statement143 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_denyStatement_in_statement152 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_encodingStatement_in_statement161 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_endBatchStatement_in_statement170 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_evictStatement_in_statement179 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_getStatement_in_statement188 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_grantStatement_in_statement197 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_infoStatement_in_statement206 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_locateStatement_in_statement215 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_pingStatement_in_statement224 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_putStatement_in_statement233 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_removeStatement_in_statement242 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_replaceStatement_in_statement251 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_rolesStatement_in_statement260 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_rollbackTransactionStatement_in_statement269 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_siteStatement_in_statement278 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_startBatchStatement_in_statement287 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_statsStatement_in_statement296 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_upgradeStatement_in_statement305 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_versionStatement_in_statement314 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_ABORT_in_abortBatchStatement336 = new BitSet(new long[]{0x0100000000200000L,0x0000000000000400L});
    public static final BitSet FOLLOW_STRINGLITERAL_in_abortBatchStatement343 = new BitSet(new long[]{0x0000000000200000L,0x0000000000000400L});
    public static final BitSet FOLLOW_set_in_abortBatchStatement347 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_BEGIN_in_beginTransactionStatement375 = new BitSet(new long[]{0x0100000000200000L,0x0000000000000400L});
    public static final BitSet FOLLOW_STRINGLITERAL_in_beginTransactionStatement382 = new BitSet(new long[]{0x0000000000200000L,0x0000000000000400L});
    public static final BitSet FOLLOW_set_in_beginTransactionStatement386 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_CACHE_in_cacheStatement414 = new BitSet(new long[]{0x0100000000200000L,0x0000000000000400L});
    public static final BitSet FOLLOW_STRINGLITERAL_in_cacheStatement421 = new BitSet(new long[]{0x0000000000200000L,0x0000000000000400L});
    public static final BitSet FOLLOW_set_in_cacheStatement425 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_CLEARCACHE_in_clearCacheStatement453 = new BitSet(new long[]{0x0100000000200000L,0x0000000000000400L});
    public static final BitSet FOLLOW_STRINGLITERAL_in_clearCacheStatement460 = new BitSet(new long[]{0x0000000000200000L,0x0000000000000400L});
    public static final BitSet FOLLOW_set_in_clearCacheStatement464 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_COMMIT_in_commitTransactionStatement492 = new BitSet(new long[]{0x0100000000200000L,0x0000000000000400L});
    public static final BitSet FOLLOW_STRINGLITERAL_in_commitTransactionStatement499 = new BitSet(new long[]{0x0000000000200000L,0x0000000000000400L});
    public static final BitSet FOLLOW_set_in_commitTransactionStatement503 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_CREATE_in_createStatement531 = new BitSet(new long[]{0x0100000000000000L});
    public static final BitSet FOLLOW_STRINGLITERAL_in_createStatement537 = new BitSet(new long[]{0x0000004000200000L,0x0000000000000400L});
    public static final BitSet FOLLOW_LIKE_in_createStatement540 = new BitSet(new long[]{0x0100000000000000L});
    public static final BitSet FOLLOW_STRINGLITERAL_in_createStatement546 = new BitSet(new long[]{0x0000000000200000L,0x0000000000000400L});
    public static final BitSet FOLLOW_set_in_createStatement550 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_DENY_in_denyStatement578 = new BitSet(new long[]{0x0100000000000000L});
    public static final BitSet FOLLOW_STRINGLITERAL_in_denyStatement584 = new BitSet(new long[]{0x1000000000000000L});
    public static final BitSet FOLLOW_TO_in_denyStatement586 = new BitSet(new long[]{0x0100000000000000L});
    public static final BitSet FOLLOW_STRINGLITERAL_in_denyStatement592 = new BitSet(new long[]{0x0000000000200000L,0x0000000000000400L});
    public static final BitSet FOLLOW_set_in_denyStatement594 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_ENCODING_in_encodingStatement623 = new BitSet(new long[]{0x0100000000200000L,0x0000000000000480L});
    public static final BitSet FOLLOW_statementOptions_in_encodingStatement629 = new BitSet(new long[]{0x0100000000200000L,0x0000000000000400L});
    public static final BitSet FOLLOW_STRINGLITERAL_in_encodingStatement636 = new BitSet(new long[]{0x0000000000200000L,0x0000000000000400L});
    public static final BitSet FOLLOW_set_in_encodingStatement640 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_END_in_endBatchStatement668 = new BitSet(new long[]{0x0100000000200000L,0x0000000000000400L});
    public static final BitSet FOLLOW_STRINGLITERAL_in_endBatchStatement675 = new BitSet(new long[]{0x0000000000200000L,0x0000000000000400L});
    public static final BitSet FOLLOW_set_in_endBatchStatement679 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_EVICT_in_evictStatement707 = new BitSet(new long[]{0x2100111018008000L,0x0000000000004081L});
    public static final BitSet FOLLOW_statementOptions_in_evictStatement713 = new BitSet(new long[]{0x2100111018008000L,0x0000000000004001L});
    public static final BitSet FOLLOW_keyIdentifier_in_evictStatement719 = new BitSet(new long[]{0x0000000000200000L,0x0000000000000400L});
    public static final BitSet FOLLOW_set_in_evictStatement721 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_GET_in_getStatement749 = new BitSet(new long[]{0x2100111018008000L,0x0000000000004081L});
    public static final BitSet FOLLOW_statementOptions_in_getStatement755 = new BitSet(new long[]{0x2100111018008000L,0x0000000000004001L});
    public static final BitSet FOLLOW_keyIdentifier_in_getStatement761 = new BitSet(new long[]{0x0000000000200000L,0x0000000000000400L});
    public static final BitSet FOLLOW_set_in_getStatement763 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_GRANT_in_grantStatement791 = new BitSet(new long[]{0x0100000000000000L});
    public static final BitSet FOLLOW_STRINGLITERAL_in_grantStatement797 = new BitSet(new long[]{0x1000000000000000L});
    public static final BitSet FOLLOW_TO_in_grantStatement799 = new BitSet(new long[]{0x0100000000000000L});
    public static final BitSet FOLLOW_STRINGLITERAL_in_grantStatement805 = new BitSet(new long[]{0x0000000000200000L,0x0000000000000400L});
    public static final BitSet FOLLOW_set_in_grantStatement807 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_INFO_in_infoStatement835 = new BitSet(new long[]{0x0100000000200000L,0x0000000000000400L});
    public static final BitSet FOLLOW_STRINGLITERAL_in_infoStatement842 = new BitSet(new long[]{0x0000000000200000L,0x0000000000000400L});
    public static final BitSet FOLLOW_set_in_infoStatement846 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_LOCATE_in_locateStatement874 = new BitSet(new long[]{0x2100111018008000L,0x0000000000004081L});
    public static final BitSet FOLLOW_statementOptions_in_locateStatement880 = new BitSet(new long[]{0x2100111018008000L,0x0000000000004001L});
    public static final BitSet FOLLOW_keyIdentifier_in_locateStatement886 = new BitSet(new long[]{0x0000000000200000L,0x0000000000000400L});
    public static final BitSet FOLLOW_set_in_locateStatement888 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_PING_in_pingStatement916 = new BitSet(new long[]{0x0000000000200000L,0x0000000000000400L});
    public static final BitSet FOLLOW_set_in_pingStatement918 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_PUT_in_putStatement946 = new BitSet(new long[]{0x2100111018008000L,0x0000000000004081L});
    public static final BitSet FOLLOW_statementOptions_in_putStatement952 = new BitSet(new long[]{0x2100111018008000L,0x0000000000004001L});
    public static final BitSet FOLLOW_keyIdentifier_in_putStatement958 = new BitSet(new long[]{0x2100111018008000L,0x0000000000004001L});
    public static final BitSet FOLLOW_literal_in_putStatement964 = new BitSet(new long[]{0x0000000000A00000L,0x0000000000000400L});
    public static final BitSet FOLLOW_expirationClause_in_putStatement971 = new BitSet(new long[]{0x0000000000200000L,0x0000000000000400L});
    public static final BitSet FOLLOW_set_in_putStatement975 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_REMOVE_in_removeStatement1003 = new BitSet(new long[]{0x2100111018008000L,0x0000000000004081L});
    public static final BitSet FOLLOW_statementOptions_in_removeStatement1009 = new BitSet(new long[]{0x2100111018008000L,0x0000000000004001L});
    public static final BitSet FOLLOW_keyIdentifier_in_removeStatement1015 = new BitSet(new long[]{0x2100111018208000L,0x0000000000004401L});
    public static final BitSet FOLLOW_literal_in_removeStatement1022 = new BitSet(new long[]{0x0000000000200000L,0x0000000000000400L});
    public static final BitSet FOLLOW_set_in_removeStatement1026 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_REPLACE_in_replaceStatement1054 = new BitSet(new long[]{0x2100111018008000L,0x0000000000004081L});
    public static final BitSet FOLLOW_statementOptions_in_replaceStatement1060 = new BitSet(new long[]{0x2100111018008000L,0x0000000000004001L});
    public static final BitSet FOLLOW_keyIdentifier_in_replaceStatement1066 = new BitSet(new long[]{0x2100111018008000L,0x0000000000004001L});
    public static final BitSet FOLLOW_literal_in_replaceStatement1072 = new BitSet(new long[]{0x2100111018A08000L,0x0000000000004401L});
    public static final BitSet FOLLOW_literal_in_replaceStatement1079 = new BitSet(new long[]{0x0000000000A00000L,0x0000000000000400L});
    public static final BitSet FOLLOW_expirationClause_in_replaceStatement1088 = new BitSet(new long[]{0x0000000000200000L,0x0000000000000400L});
    public static final BitSet FOLLOW_set_in_replaceStatement1092 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_ROLES_in_rolesStatement1120 = new BitSet(new long[]{0x0100000000200000L,0x0000000000000400L});
    public static final BitSet FOLLOW_STRINGLITERAL_in_rolesStatement1127 = new BitSet(new long[]{0x0000000000200000L,0x0000000000000400L});
    public static final BitSet FOLLOW_set_in_rolesStatement1131 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_ROLLBACK_in_rollbackTransactionStatement1159 = new BitSet(new long[]{0x0100000000200000L,0x0000000000000400L});
    public static final BitSet FOLLOW_STRINGLITERAL_in_rollbackTransactionStatement1166 = new BitSet(new long[]{0x0000000000200000L,0x0000000000000400L});
    public static final BitSet FOLLOW_set_in_rollbackTransactionStatement1170 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_SITE_in_siteStatement1201 = new BitSet(new long[]{0x0100000000200000L,0x0000000000000480L});
    public static final BitSet FOLLOW_statementOptions_in_siteStatement1207 = new BitSet(new long[]{0x0100000000200000L,0x0000000000000400L});
    public static final BitSet FOLLOW_siteIdentifier_in_siteStatement1214 = new BitSet(new long[]{0x0000000000200000L,0x0000000000000400L});
    public static final BitSet FOLLOW_set_in_siteStatement1218 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_START_in_startBatchStatement1246 = new BitSet(new long[]{0x0100000000200000L,0x0000000000000400L});
    public static final BitSet FOLLOW_STRINGLITERAL_in_startBatchStatement1253 = new BitSet(new long[]{0x0000000000200000L,0x0000000000000400L});
    public static final BitSet FOLLOW_set_in_startBatchStatement1257 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_STATS_in_statsStatement1285 = new BitSet(new long[]{0x0100000000200000L,0x0000000000000480L});
    public static final BitSet FOLLOW_statementOptions_in_statsStatement1291 = new BitSet(new long[]{0x0100000000200000L,0x0000000000000400L});
    public static final BitSet FOLLOW_STRINGLITERAL_in_statsStatement1298 = new BitSet(new long[]{0x0000000000200000L,0x0000000000000400L});
    public static final BitSet FOLLOW_set_in_statsStatement1302 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_UPGRADE_in_upgradeStatement1330 = new BitSet(new long[]{0x0100000000200000L,0x0000000000000480L});
    public static final BitSet FOLLOW_statementOptions_in_upgradeStatement1336 = new BitSet(new long[]{0x0100000000200000L,0x0000000000000400L});
    public static final BitSet FOLLOW_STRINGLITERAL_in_upgradeStatement1343 = new BitSet(new long[]{0x0000000000200000L,0x0000000000000400L});
    public static final BitSet FOLLOW_set_in_upgradeStatement1347 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_VERSION_in_versionStatement1375 = new BitSet(new long[]{0x0000000000200000L,0x0000000000000400L});
    public static final BitSet FOLLOW_set_in_versionStatement1377 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_EXPIRES_in_expirationClause1405 = new BitSet(new long[]{0x0800000000000000L});
    public static final BitSet FOLLOW_timeLiteral_in_expirationClause1411 = new BitSet(new long[]{0x0000080000000002L});
    public static final BitSet FOLLOW_MAXIDLE_in_expirationClause1414 = new BitSet(new long[]{0x0800000000000000L});
    public static final BitSet FOLLOW_timeLiteral_in_expirationClause1420 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_STRINGLITERAL_in_keyIdentifier1443 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000100L});
    public static final BitSet FOLLOW_72_in_keyIdentifier1445 = new BitSet(new long[]{0x2100111018008000L,0x0000000000004001L});
    public static final BitSet FOLLOW_literal_in_keyIdentifier1447 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_literal_in_keyIdentifier1456 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_STRINGLITERAL_in_siteIdentifier1481 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000100L});
    public static final BitSet FOLLOW_72_in_siteIdentifier1483 = new BitSet(new long[]{0x0100000000000000L});
    public static final BitSet FOLLOW_STRINGLITERAL_in_siteIdentifier1489 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_STRINGLITERAL_in_siteIdentifier1502 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_statementOption_in_statementOptions1530 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000080L});
    public static final BitSet FOLLOW_71_in_statementOption1554 = new BitSet(new long[]{0x0100000000000000L});
    public static final BitSet FOLLOW_STRINGLITERAL_in_statementOption1560 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000800L});
    public static final BitSet FOLLOW_75_in_statementOption1563 = new BitSet(new long[]{0x0100000000000000L});
    public static final BitSet FOLLOW_STRINGLITERAL_in_statementOption1569 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_INTLITERAL_in_literal1592 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_LONGLITERAL_in_literal1601 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_FLOATLITERAL_in_literal1610 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_DOUBLELITERAL_in_literal1619 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_NULL_in_literal1628 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_STRINGLITERAL_in_literal1637 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_UUIDLITERAL_in_literal1646 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_set_in_literal1659 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_jsonLiteral_in_literal1676 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_TIMELITERAL_in_timeLiteral1713 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_78_in_jsonLiteral1730 = new BitSet(new long[]{0x0100000000000000L});
    public static final BitSet FOLLOW_jsonPair_in_jsonLiteral1732 = new BitSet(new long[]{0x0000000000000000L,0x0000000000008040L});
    public static final BitSet FOLLOW_70_in_jsonLiteral1735 = new BitSet(new long[]{0x0100000000000000L});
    public static final BitSet FOLLOW_jsonPair_in_jsonLiteral1737 = new BitSet(new long[]{0x0000000000000000L,0x0000000000008040L});
    public static final BitSet FOLLOW_79_in_jsonLiteral1741 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_jsonString_in_jsonPair1756 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000200L});
    public static final BitSet FOLLOW_73_in_jsonPair1758 = new BitSet(new long[]{0x2100101008008000L,0x0000000000005000L});
    public static final BitSet FOLLOW_jsonValue_in_jsonPair1760 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_STRINGLITERAL_in_jsonString1775 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_jsonLiteral_in_jsonValue1790 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_jsonArray_in_jsonValue1797 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_INTLITERAL_in_jsonValue1804 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_DOUBLELITERAL_in_jsonValue1811 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_TRUE_in_jsonValue1818 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_FALSE_in_jsonValue1822 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_NULL_in_jsonValue1829 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_jsonString_in_jsonValue1836 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_76_in_jsonArray1851 = new BitSet(new long[]{0x2100101008008000L,0x0000000000005000L});
    public static final BitSet FOLLOW_jsonValue_in_jsonArray1853 = new BitSet(new long[]{0x0000000000000000L,0x0000000000002040L});
    public static final BitSet FOLLOW_70_in_jsonArray1856 = new BitSet(new long[]{0x2100101008008000L,0x0000000000005000L});
    public static final BitSet FOLLOW_jsonValue_in_jsonArray1858 = new BitSet(new long[]{0x0000000000000000L,0x0000000000002040L});
    public static final BitSet FOLLOW_77_in_jsonArray1862 = new BitSet(new long[]{0x0000000000000002L});

}