/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.cli.interpreter;

import java.util.Map;
import org.infinispan.Cache;
import org.infinispan.cli.interpreter.Interpreter;
import org.infinispan.cli.interpreter.MyClass;
import org.infinispan.cli.interpreter.logging.Log;
import org.infinispan.cli.interpreter.result.ResultKeys;
import org.infinispan.cli.interpreter.statement.CacheStatement;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.factories.GlobalComponentRegistry;
import org.infinispan.manager.CacheContainer;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.util.logging.LogFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="cli.interpreter.InterpreterTest")
public class InterpreterTest
extends SingleCacheManagerTest {
    protected EmbeddedCacheManager createCacheManager() throws Exception {
        ConfigurationBuilder c = this.getDefaultStandaloneCacheConfig(true);
        c.jmxStatistics().enable().dataContainer().invocationBatching().enable();
        return TestCacheManagerFactory.createCacheManager((ConfigurationBuilder)c);
    }

    private Interpreter getInterpreter() {
        GlobalComponentRegistry gcr = TestingUtil.extractGlobalComponentRegistry((CacheContainer)this.cacheManager);
        Interpreter interpreter = (Interpreter)gcr.getComponent(Interpreter.class);
        return interpreter;
    }

    private Map<String, String> execute(Interpreter interpreter, String sessionId, String commands) throws Exception {
        Map result = interpreter.execute(sessionId, commands);
        if (result.containsKey(ResultKeys.ERROR.toString())) {
            AssertJUnit.fail((String)String.format("%s\n%s", result.get(ResultKeys.ERROR.toString()), result.get(ResultKeys.STACKTRACE.toString())));
        }
        return result;
    }

    public void testSimple() throws Exception {
        Interpreter interpreter = this.getInterpreter();
        String sessionId = interpreter.createSessionId("___defaultcache");
        this.execute(interpreter, sessionId, "put 'a' 'b'; get 'a';");
        this.execute(interpreter, sessionId, "put 'c' {\"org.infinispan.cli.interpreter.MyClass\":{\"i\":5,\"x\":null,\"b\":true}};");
        Object o = this.cache.get((Object)"c");
        AssertJUnit.assertNotNull((Object)o);
        AssertJUnit.assertEquals(MyClass.class, o.getClass());
        AssertJUnit.assertEquals((int)5, (int)((MyClass)o).i);
        AssertJUnit.assertTrue((boolean)((MyClass)o).b);
        this.execute(interpreter, sessionId, "put 'f' 0.5;");
        Double f = (Double)this.cache.get((Object)"f");
        AssertJUnit.assertEquals((Object)0.5, (Object)f);
        this.execute(interpreter, sessionId, "put 'l' 1000l;");
        Long l = (Long)this.cache.get((Object)"l");
        AssertJUnit.assertEquals((long)1000L, (long)l);
    }

    public void testPutIfAbsent() throws Exception {
        Interpreter interpreter = this.getInterpreter();
        String sessionId = interpreter.createSessionId("___defaultcache");
        this.execute(interpreter, sessionId, "put 'a' 'a'; put --ifabsent 'a' 'b';");
        AssertJUnit.assertEquals((String)"a", (String)((String)this.cache.get((Object)"a")));
    }

    public void testCacheQualifier() throws Exception {
        Interpreter interpreter = this.getInterpreter();
        String sessionId = interpreter.createSessionId("___defaultcache");
        this.cacheManager.defineConfiguration("otherCache", new ConfigurationBuilder().build());
        Cache otherCache = this.cacheManager.getCache("otherCache");
        this.execute(interpreter, sessionId, "put 'a' 'a'; put 'otherCache'.'b' 'b'; cache 'otherCache'; put 'c' 'c';");
        Object a = this.cache.get((Object)"a");
        AssertJUnit.assertEquals((Object)"a", (Object)a);
        Object b = otherCache.get((Object)"b");
        AssertJUnit.assertEquals((Object)"b", (Object)b);
        Object c = otherCache.get((Object)"c");
        AssertJUnit.assertEquals((Object)"c", (Object)c);
    }

    public void testBatching() throws Exception {
        Interpreter interpreter = this.getInterpreter();
        String sessionId = interpreter.createSessionId("___defaultcache");
        this.execute(interpreter, sessionId, "start; put 'a' 'a'; put 'b' 'b'; end;");
        Object a = this.cache.get((Object)"a");
        AssertJUnit.assertEquals((Object)"a", (Object)a);
        Object b = this.cache.get((Object)"b");
        AssertJUnit.assertEquals((Object)"b", (Object)b);
    }

    public void testTx() throws Exception {
        Interpreter interpreter = this.getInterpreter();
        String sessionId = interpreter.createSessionId("___defaultcache");
        this.execute(interpreter, sessionId, "begin; put 'a' 'a'; commit;");
        Object a = this.cache.get((Object)"a");
        AssertJUnit.assertEquals((Object)"a", (Object)a);
        this.execute(interpreter, sessionId, "begin; put 'b' 'b'; rollback;");
        AssertJUnit.assertFalse((boolean)this.cache.containsKey((Object)"b"));
    }

    public void testDangling() throws Exception {
        Interpreter interpreter = this.getInterpreter();
        String sessionId = interpreter.createSessionId("___defaultcache");
        interpreter.execute(sessionId, "begin; put 'a' 'a';");
        AssertJUnit.assertNull((Object)this.cache.getAdvancedCache().getTransactionManager().getTransaction());
        AssertJUnit.assertFalse((boolean)this.cache.containsKey((Object)"a"));
        interpreter.execute(sessionId, "start; put 'a' 'a';");
        AssertJUnit.assertNull((Object)this.cache.getAdvancedCache().getBatchContainer().getBatchTransaction());
        AssertJUnit.assertFalse((boolean)this.cache.containsKey((Object)"a"));
    }

    public void testRemove() throws Exception {
        Interpreter interpreter = this.getInterpreter();
        String sessionId = interpreter.createSessionId("___defaultcache");
        interpreter.execute(sessionId, "put 'a' 'a';");
        Object a = this.cache.get((Object)"a");
        AssertJUnit.assertEquals((Object)"a", (Object)a);
        interpreter.execute(sessionId, "remove 'a';");
        AssertJUnit.assertFalse((boolean)this.cache.containsKey((Object)"a"));
        interpreter.execute(sessionId, "put 'b' 'b';");
        Object b = this.cache.get((Object)"b");
        AssertJUnit.assertEquals((Object)"b", (Object)b);
        interpreter.execute(sessionId, "remove 'b' 'c';");
        AssertJUnit.assertTrue((boolean)this.cache.containsKey((Object)"b"));
    }

    public void testEvict() throws Exception {
        Interpreter interpreter = this.getInterpreter();
        String sessionId = interpreter.createSessionId("___defaultcache");
        interpreter.execute(sessionId, "put 'a' 'a';");
        Object a = this.cache.get((Object)"a");
        AssertJUnit.assertEquals((Object)"a", (Object)a);
        interpreter.execute(sessionId, "evict 'a';");
        AssertJUnit.assertFalse((boolean)this.cache.containsKey((Object)"a"));
    }

    public void testReplace() throws Exception {
        Interpreter interpreter = this.getInterpreter();
        String sessionId = interpreter.createSessionId("___defaultcache");
        interpreter.execute(sessionId, "put 'a' 'a';");
        Object a = this.cache.get((Object)"a");
        AssertJUnit.assertEquals((Object)"a", (Object)a);
        interpreter.execute(sessionId, "replace 'a' 'b';");
        a = this.cache.get((Object)"a");
        AssertJUnit.assertEquals((Object)"b", (Object)a);
        interpreter.execute(sessionId, "replace 'a' 'b' 'c';");
        a = this.cache.get((Object)"a");
        AssertJUnit.assertEquals((Object)"c", (Object)a);
        interpreter.execute(sessionId, "replace 'a' 'b' 'd';");
        a = this.cache.get((Object)"a");
        AssertJUnit.assertEquals((Object)"c", (Object)a);
    }

    public void testCreateLocal() throws Exception {
        Interpreter interpreter = this.getInterpreter();
        String sessionId = interpreter.createSessionId("___defaultcache");
        interpreter.execute(sessionId, "create newcache;");
        AssertJUnit.assertTrue((boolean)this.cacheManager.cacheExists("newcache"));
        interpreter.execute(sessionId, "create anothercache like newcache;");
        AssertJUnit.assertTrue((boolean)this.cacheManager.cacheExists("anothercache"));
    }

    public void testUpgrade() throws Exception {
        Interpreter interpreter = this.getInterpreter();
        String sessionId = interpreter.createSessionId("___defaultcache");
        interpreter.execute(sessionId, "upgrade --dumpkeys;");
    }

    public void testInvalidSession() throws Exception {
        Interpreter interpreter = this.getInterpreter();
        String sessionId = "123";
        Map response = interpreter.execute(sessionId, "put 'a' 'a';");
        AssertJUnit.assertTrue((boolean)response.containsKey(ResultKeys.ERROR.toString()));
    }

    public void testCacheNotYetSelected() throws Exception {
        Interpreter interpreter = this.getInterpreter();
        String sessionId = interpreter.createSessionId(null);
        Map response = interpreter.execute(sessionId, "cache;");
        AssertJUnit.assertTrue((boolean)response.containsKey(ResultKeys.ERROR.toString()));
        String errorMsg = ((Log)LogFactory.getLog(CacheStatement.class, Log.class)).noCacheSelectedYet().getMessage();
        AssertJUnit.assertTrue((boolean)((String)response.get(ResultKeys.ERROR.toString())).contains(errorMsg));
    }

    public void testStats() throws Exception {
        Interpreter interpreter = this.getInterpreter();
        String sessionId = interpreter.createSessionId("___defaultcache");
        Map response = interpreter.execute(sessionId, "stats;");
        AssertJUnit.assertFalse((boolean)response.containsKey(ResultKeys.ERROR.toString()));
        response = interpreter.execute(sessionId, "stats --container;");
        AssertJUnit.assertFalse((boolean)response.containsKey(ResultKeys.ERROR.toString()));
    }

    public void testParserErrors() throws Exception {
        Interpreter interpreter = this.getInterpreter();
        String sessionId = interpreter.createSessionId("___defaultcache");
        Map response = interpreter.execute(sessionId, "got a;");
        AssertJUnit.assertTrue((boolean)response.containsKey(ResultKeys.ERROR.toString()));
    }

    public void testTemporarySession() throws Exception {
        Interpreter interpreter = this.getInterpreter();
        Map response = interpreter.execute(null, "put 'a' 'a';");
        AssertJUnit.assertFalse((boolean)response.containsKey(ResultKeys.ERROR.toString()));
        AssertJUnit.assertEquals((String)"a", (String)((String)this.cache.get((Object)"a")));
    }
}

