/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.cli.interpreter.statement;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Method;
import java.util.List;
import org.infinispan.Cache;
import org.infinispan.cli.interpreter.logging.Log;
import org.infinispan.cli.interpreter.result.Result;
import org.infinispan.cli.interpreter.result.StatementException;
import org.infinispan.cli.interpreter.result.StringResult;
import org.infinispan.cli.interpreter.session.Session;
import org.infinispan.cli.interpreter.statement.Option;
import org.infinispan.cli.interpreter.statement.Statement;
import org.infinispan.factories.components.ComponentMetadata;
import org.infinispan.factories.components.ComponentMetadataRepo;
import org.infinispan.factories.components.JmxAttributeMetadata;
import org.infinispan.factories.components.ManageableComponentMetadata;
import org.infinispan.interceptors.base.CommandInterceptor;
import org.infinispan.manager.DefaultCacheManager;
import org.infinispan.util.logging.LogFactory;

public class StatsStatement
implements Statement {
    private static final Log log = (Log)LogFactory.getLog(StatsStatement.class, Log.class);
    final String cacheName;
    private final List<Option> options;

    public StatsStatement(List<Option> options, String cacheName) {
        this.options = options;
        this.cacheName = cacheName;
    }

    @Override
    public Result execute(Session session) throws StatementException {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        if (this.options.size() > 0) {
            for (Option option : this.options) {
                switch (option.toEnum(Options.class)) {
                    case CONTAINER: {
                        this.printContainerStats(pw, (DefaultCacheManager)session.getCacheManager());
                        pw.flush();
                    }
                }
            }
        } else {
            this.printCacheStats(pw, session.getCache(this.cacheName));
        }
        pw.flush();
        return new StringResult(sw.toString());
    }

    private void printContainerStats(PrintWriter pw, DefaultCacheManager cacheManager) {
        pw.printf("%s: {\n", cacheManager.getClusterName());
        pw.printf("  status: %s\n", cacheManager.getCacheManagerStatus());
        pw.printf("  address: %s\n", cacheManager.getAddress());
        pw.printf("  coordinator: %s\n", cacheManager.getCoordinator());
        pw.printf("  is coordinator? %s\n", cacheManager.isCoordinator());
        pw.printf("  clusterSize: %d\n", cacheManager.getClusterSize());
        pw.printf("  clusterMembers: %s\n", cacheManager.getClusterMembers());
        pw.printf("  createdCacheCount: %s\n", cacheManager.getCreatedCacheCount());
        pw.printf("  definedCacheCount: %s\n", cacheManager.getDefinedCacheCount());
        pw.printf("  definedCacheNames: %s\n", cacheManager.getDefinedCacheNames());
        pw.printf("  version: %s\n", cacheManager.getVersion());
        pw.println("}");
    }

    private void printCacheStats(PrintWriter pw, Cache<?, ?> cache) throws StatementException {
        if (!cache.getCacheConfiguration().jmxStatistics().enabled()) {
            throw log.statisticsNotEnabled(cache.getName());
        }
        for (CommandInterceptor interceptor : cache.getAdvancedCache().getInterceptorChain()) {
            this.printComponentStats(pw, cache, interceptor);
        }
        this.printComponentStats(pw, cache, cache.getAdvancedCache().getLockManager());
        this.printComponentStats(pw, cache, cache.getAdvancedCache().getRpcManager());
    }

    private void printComponentStats(PrintWriter pw, Cache<?, ?> cache, Object component) {
        if (component == null) {
            return;
        }
        ComponentMetadataRepo mr = cache.getAdvancedCache().getComponentRegistry().getComponentMetadataRepo();
        ComponentMetadata cm = mr.findComponentMetadata(component.getClass().getName());
        if (cm == null || !(cm instanceof ManageableComponentMetadata)) {
            return;
        }
        ManageableComponentMetadata mcm = cm.toManageableComponentMetadata();
        pw.printf("%s: {\n", mcm.getJmxObjectName());
        for (JmxAttributeMetadata s : mcm.getAttributeMetadata()) {
            pw.printf("  %s: %s\n", s.getName(), this.getAttributeValue(component, s));
        }
        pw.println("}");
    }

    private Object getAttributeValue(Object o, JmxAttributeMetadata attr) {
        String name = attr.getName();
        String methodName = (attr.isIs() ? "is" : "get") + name.substring(0, 1).toUpperCase() + name.substring(1);
        try {
            Method method = o.getClass().getMethod(methodName, new Class[0]);
            return method.invoke(o, new Object[0]);
        }
        catch (Exception e) {
            return "N/A";
        }
    }

    private static enum Options {
        CONTAINER;

    }
}

