/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.cli.interpreter;

import java.util.Map;
import org.infinispan.Cache;
import org.infinispan.cli.interpreter.Interpreter;
import org.infinispan.cli.interpreter.result.ResultKeys;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.test.HotRodClientTestingUtil;
import org.infinispan.factories.GlobalComponentRegistry;
import org.infinispan.manager.CacheContainer;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.persistence.remote.configuration.RemoteStoreConfigurationBuilder;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.server.hotrod.test.HotRodTestingUtil;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(testName="cli.interpreter.UpgradeTest", groups={"functional"})
public class UpgradeTest
extends AbstractInfinispanTest {
    private HotRodServer sourceServer;
    private HotRodServer targetServer;
    private EmbeddedCacheManager sourceContainer;
    private Cache<byte[], byte[]> sourceServerCache;
    private EmbeddedCacheManager targetContainer;
    private Cache<byte[], byte[]> targetServerCache;
    private RemoteCacheManager sourceRemoteCacheManager;
    private RemoteCache<String, String> sourceRemoteCache;
    private RemoteCacheManager targetRemoteCacheManager;

    @BeforeClass
    public void setup() throws Exception {
        org.infinispan.configuration.cache.ConfigurationBuilder serverBuilder = HotRodTestingUtil.hotRodCacheConfiguration((org.infinispan.configuration.cache.ConfigurationBuilder)TestCacheManagerFactory.getDefaultCacheConfiguration((boolean)false));
        this.sourceContainer = TestCacheManagerFactory.createCacheManager((org.infinispan.configuration.cache.ConfigurationBuilder)serverBuilder);
        this.sourceServerCache = this.sourceContainer.getCache();
        this.sourceServer = HotRodClientTestingUtil.startHotRodServer((EmbeddedCacheManager)this.sourceContainer);
        org.infinispan.configuration.cache.ConfigurationBuilder targetConfigurationBuilder = HotRodTestingUtil.hotRodCacheConfiguration((org.infinispan.configuration.cache.ConfigurationBuilder)TestCacheManagerFactory.getDefaultCacheConfiguration((boolean)false));
        ((RemoteStoreConfigurationBuilder)targetConfigurationBuilder.persistence().addStore(RemoteStoreConfigurationBuilder.class)).hotRodWrapping(true).addServer().host("localhost").port(this.sourceServer.getPort());
        this.targetContainer = TestCacheManagerFactory.createCacheManager((org.infinispan.configuration.cache.ConfigurationBuilder)targetConfigurationBuilder);
        this.targetServerCache = this.targetContainer.getCache();
        this.targetServer = HotRodClientTestingUtil.startHotRodServer((EmbeddedCacheManager)this.targetContainer);
        this.sourceRemoteCacheManager = new RemoteCacheManager(new ConfigurationBuilder().addServers("localhost:" + this.sourceServer.getPort()).build());
        this.sourceRemoteCacheManager.start();
        this.sourceRemoteCache = this.sourceRemoteCacheManager.getCache();
        this.targetRemoteCacheManager = new RemoteCacheManager(new ConfigurationBuilder().addServers("localhost:" + this.sourceServer.getPort()).build());
        this.targetRemoteCacheManager.start();
    }

    public void testSynchronization() throws Exception {
        for (char ch = 'A'; ch <= 'Z'; ch = (char)(ch + '\u0001')) {
            String s = Character.toString(ch);
            this.sourceRemoteCache.put((Object)s, (Object)s);
        }
        Interpreter targetInterpreter = this.getInterpreter(this.targetContainer);
        String targetSessionId = targetInterpreter.createSessionId("___defaultcache");
        Map synchronizeResult = targetInterpreter.execute(targetSessionId, "upgrade --synchronize=hotrod;");
        this.checkNoErrors(synchronizeResult);
        Map disconnectResult = targetInterpreter.execute(targetSessionId, "upgrade --disconnectsource=hotrod;");
        this.checkNoErrors(disconnectResult);
        AssertJUnit.assertEquals((int)this.sourceServerCache.size(), (int)this.targetServerCache.size());
    }

    private Interpreter getInterpreter(EmbeddedCacheManager cm) {
        GlobalComponentRegistry gcr = TestingUtil.extractGlobalComponentRegistry((CacheContainer)cm);
        return (Interpreter)gcr.getComponent(Interpreter.class);
    }

    private void checkNoErrors(Map<String, String> result) {
        AssertJUnit.assertFalse((String)result.get(ResultKeys.ERROR.toString()), (boolean)result.containsKey(ResultKeys.ERROR.toString()));
    }

    @BeforeMethod
    public void cleanup() {
        this.sourceServerCache.clear();
        this.targetServerCache.clear();
    }

    @AfterClass
    public void tearDown() {
        HotRodClientTestingUtil.killRemoteCacheManagers((RemoteCacheManager[])new RemoteCacheManager[]{this.sourceRemoteCacheManager, this.targetRemoteCacheManager});
        HotRodClientTestingUtil.killServers((HotRodServer[])new HotRodServer[]{this.sourceServer, this.targetServer});
        TestingUtil.killCacheManagers((EmbeddedCacheManager[])new EmbeddedCacheManager[]{this.targetContainer, this.sourceContainer});
    }
}

